#!/bin/bash
#
# $Id: convert.sh,v 1.4 2003/07/22 15:48:50 mad Exp $
#
# handy wrapper script for mass-migrations
#

## OPTIONS
#
# use "-v -v" to be more verbose
C2C_VERBOSE="-v"

# path to cyrus2courier binary
C2C_BINARY="../src/cyrus2courier"


## CYRUS
#
# path to your cyrus partition(s)
CY_PARTITIONS="/mnt/backup4/umstellung/mailbox/user /mnt/backup4/umstellung/mailbox2/user"

# path to quota/subscribe dirs
CY_QUOTA="/mnt/backup4/umstellung/daten/conf/quota"
CY_SUBSCRIBE="/mnt/backup4/umstellung/daten/conf/user"

# are they "hashed"-style?
CY_QUOTA_HASHED="yes"
CY_SUBSCRIBE_HASHED="yes"


## COURIER
#
# path to courier/dest folder
CO_ROOT="/mnt/mail/mpriv1"

# apply hashing? like ...co_root/m/mailbox
CO_HASHED="yes"

# chown to
CO_CHOWN="mail:mail"





## MAIN / CONVERT #########################
#
LOG_BEGIN=`/bin/date`

if [ $CY_QUOTA_HASHED = "yes" ]; then
	CY_HASHED_VAL="q"
fi
if [ $CY_SUBSCRIBE_HASHED = "yes" ]; then
	CY_HASHED_VAL="${CY_HASHED_VAL}s"
fi

if [ "x$CY_HASHED_VAL" != "x" ]; then
	CY_HASHED="--hashed=$CY_HASHED_VAL"
fi

## setup courier dir-hash
#
if [ $CO_HASHED = "yes" ]; then
	for i in `echo "a b c d e f g h i j k l m n o p q r s t u v w x y z"`; do
		mkdir -p "$CO_ROOT/$i"
		if [ "x$CO_CHOWN" != "x" ]; then
			chown $CO_CHOWN $CO_ROOT/$i
		fi

	done
	for i in `echo "0 1 2 3 4 5 6 7 8 9"`; do
		mkdir -p "$CO_ROOT/$i"
		if [ "x$CO_CHOWN" != "x" ]; then
			chown $CO_CHOWN $CO_ROOT/$i
		fi

	done
fi

for PARTITION in `echo "$CY_PARTITIONS"`; do
	PART_BEGIN=`/bin/date`
	echo "PART    BEGIN $PARTITION $PART_BEGIN"
	for MAILBOX in `ls "$PARTITION"`; do
		if [ $CO_HASHED = "yes" ]; then
			$C2C_BINARY $C2C_VERBOSE --quota-dir="$CY_QUOTA" --subscribe-dir="$CY_SUBSCRIBE" $CY_HASHED "$PARTITION" "$CO_ROOT/${MAILBOX:0:1}" $MAILBOX
			if [ $? != 0 ]; then
				echo "FAIL   $MAILBOX"
				echo "       (${0}) ${C2C_BINARY} Oops."
				echo "        *** $C2C_BINARY $C2C_VERBOSE --quota-dir=$CY_QUOTA --subscribe-dir=$CY_SUBSCRIBE $CY_HASHED $PARTITION $CO_ROOT/${MAILBOX:0:1} $MAILBOX"
			else
				if [ "x$CO_CHOWN" != "x" ]; then
					chown -R $CO_CHOWN "$CO_ROOT/${MAILBOX:0:1}/$MAILBOX"
				fi
			fi
		else
			$C2C_BINARY $C2C_VERBOSE --quota-dir="$CY_QUOTA" --subscribe-dir="$CY_SUBSCRIBE" $CY_HASHED "$PARTITION" "$CO_ROOT" $MAILBOX
			if [ $? != 0 ]; then
				echo "FAIL   $MAILBOX"
				echo "       (${0}) ${C2C_BINARY} Oops."
				echo "        *** $C2C_BINARY $C2C_VERBOSE --quota-dir=$CY_QUOTA --subscribe-dir=$CY_SUBSCRIBE $CY_HASHED $PARTITION $CO_ROOT/${MAILBOX:0:1} $MAILBOX"
			else
				if [ "x$CO_CHOWN" != "x" ]; then
					chown -R $CO_CHOWN "$CO_ROOT/$MAILBOX"
				fi
			fi
		fi
	done
	PART_END=`/bin/date`
	echo "PART    END $PARTITION $PART_END"
done

LOG_END=`/bin/date`

echo "STAT    BEGIN $LOG_BEGIN"
echo "STAT      END $LOG_END"

