/* (C) 1999-2000 Patrick Lambert <drow@post.com> */
#include "easygtk.h"

void E_NO_FUNC()
{
}

int e_assert_widget(GtkWidget *widget, gchar *errmsg)
{
 if(E_DEBUG)
 if(widget==NULL || !GTK_IS_WIDGET(widget))
 {
  printf("*** EasyGTK: %s\n", errmsg);
  return -1;
 }
 return 0;
}

GtkWidget *e_window_create(char *title, gint size_x, gint size_y, gint position_x, gint position_y, GtkSignalFunc window_destroy)
{
 GtkWidget *i_win;
 i_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize(GTK_WIDGET(i_win), size_x, size_y);
 gtk_signal_connect(GTK_OBJECT(i_win), "delete_event",
 GTK_SIGNAL_FUNC(window_destroy), i_win);
 gtk_window_set_title(GTK_WINDOW(i_win), title);
 if(position_x == 0 && position_y == 0)
 gtk_window_set_position(GTK_WINDOW(i_win), GTK_WIN_POS_CENTER);
 else gtk_widget_set_uposition(GTK_WIDGET(i_win), position_x, position_y);
 gtk_container_border_width(GTK_CONTAINER(i_win), 2);
 gtk_widget_show(i_win);
 return i_win;
}

GtkWidget *e_box_create(GtkWidget *parent, gint placement, gint border)
{
 GtkWidget *i_box;
 e_assert_widget(parent, "parent is not a GtkWidget");
 if(placement == E_VERTICAL) i_box = gtk_vbox_new(FALSE, 0);
 else i_box = gtk_hbox_new(FALSE, 0);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_box);
 else gtk_box_pack_start(GTK_BOX(parent), i_box, TRUE, TRUE, 0);
 gtk_container_border_width(GTK_CONTAINER(i_box), border);
 gtk_widget_show(i_box);
 return i_box;
}

void e_box_add(GtkWidget *parent, GtkWidget *widget, gint placement, gint fill)
{
 e_assert_widget(parent, "parent is not a GtkWidget");
 e_assert_widget(widget, "widget is not a GtkWidget");
 if(fill==TRUE)
 {
  if(placement==E_LEFT)  gtk_box_pack_start(GTK_BOX(parent), widget, TRUE, TRUE, 0);
  if(placement==E_RIGHT)  gtk_box_pack_end(GTK_BOX(parent), widget, TRUE, TRUE, 0);
 }
 else
 {
  if(placement==E_LEFT)  gtk_box_pack_start(GTK_BOX(parent), widget, FALSE, FALSE, 0);
  if(placement==E_RIGHT)  gtk_box_pack_end(GTK_BOX(parent), widget, FALSE, FALSE, 0);
 }
}

GtkWidget *e_box_fixed(GtkWidget *parent, gint placement, gint border)
{
 GtkWidget *i_box;
 e_assert_widget(parent, "parent is not a GtkWidget");
 if(placement == E_VERTICAL) i_box = gtk_vbox_new(FALSE, 0);
 else i_box = gtk_hbox_new(FALSE, 0);
 gtk_box_pack_start(GTK_BOX(parent), i_box, FALSE, FALSE, 0);
 gtk_container_border_width(GTK_CONTAINER(i_box), border);
 gtk_widget_show(i_box);
 return i_box;
}

GtkWidget *e_text_create(GtkWidget *parent, gint editable, char *initial_text, GtkSignalFunc text_changed)
{
 GtkWidget *i_table, *i_text, *i_sb;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_table = gtk_table_new(2, 2, FALSE);
 gtk_table_set_row_spacing(GTK_TABLE(i_table), 0, 2);
 gtk_table_set_col_spacing(GTK_TABLE(i_table), 0, 2);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_table);
 else gtk_box_pack_start(GTK_BOX(parent), i_table, TRUE, TRUE, 0);
 gtk_widget_show(i_table);

 i_text = gtk_text_new(NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT(i_text), TRUE);
 gtk_table_attach_defaults(GTK_TABLE(i_table), i_text, 0, 1, 0, 1);
 gtk_text_set_editable(GTK_TEXT(i_text), editable);
 gtk_widget_show(i_text);

 i_sb = gtk_vscrollbar_new(GTK_TEXT(i_text)->vadj);
 gtk_table_attach (GTK_TABLE(i_table), i_sb, 1, 2, 0, 1,
 GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show(i_sb);

 gtk_signal_connect(GTK_OBJECT(i_text), "changed",
 GTK_SIGNAL_FUNC(text_changed), i_text);

 gtk_text_freeze(GTK_TEXT(i_text));
 gtk_widget_realize(i_text);
 gtk_text_insert(GTK_TEXT(i_text), NULL, NULL, NULL, initial_text, -1);
 gtk_text_thaw(GTK_TEXT(i_text));
 return i_text;
}

gint e_text_find(GtkWidget *text, char *search_string)
{
 int i, j, string_len, text_len, begin_at, result, line_number=0, line_total=0;                   
 char findbuf[1024];
 char *alltext;                                                                                   
 e_assert_widget(text, "textarea is not a GtkWidget");
 strcpy(findbuf, "");                                                                             
 gtk_text_freeze(GTK_TEXT(text));                                                                 
 text_len = gtk_text_get_length(GTK_TEXT(text));                                                  
 string_len = strlen(search_string);                                                              
 begin_at = 0;
 for(i=0;i<(text_len-string_len);i++)                                                             
 {                                                                                                
  alltext = gtk_editable_get_chars(GTK_EDITABLE(text), i, i+1);                                   
  if(*alltext=='\n') line_number++;                                                               
  g_free(alltext);                                                                                
  alltext = gtk_editable_get_chars(GTK_EDITABLE(text), i, i+string_len);                          
  strncpy(findbuf, alltext, 50);                                                                  
  g_free(alltext);                                                                                
  result = strcmp(findbuf, search_string);                                                   
  if(i>begin_at && result==0)                                                                     
  {                                                                                               
   for(j=0;j<(text_len-string_len);j++)                                                           
   {                                                                                              
    alltext = gtk_editable_get_chars(GTK_EDITABLE(text), j, j+1);                                 
    if(*alltext=='\n') line_total++;                                                              
    g_free(alltext);                                                                              
   }                                                                                              
   gtk_text_thaw(GTK_TEXT(text));                                                                 
   if(i>100)                                                                                      
   gtk_adjustment_set_value(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj), ((line_number * GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->upper) / line_total - GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->page_increment));
   gtk_editable_insert_text(GTK_EDITABLE(text), " ", 1, &i);                                      
   gtk_editable_delete_text(GTK_EDITABLE(text), i-1, i);                                          
   gtk_text_set_point(GTK_TEXT(text), i+string_len-1);                                            
   return i;
  }                                                                                               
 }
 gtk_text_thaw(GTK_TEXT(text));
 return -1;
}

void e_text_insert(GtkWidget *textarea, gchar *text)
{
 e_assert_widget(textarea, "textarea is not a GtkWidget");
 gtk_text_freeze(GTK_TEXT(textarea));
 gtk_text_insert(GTK_TEXT(textarea), NULL, NULL, NULL, text, -1);
 gtk_text_thaw(GTK_TEXT(textarea));
}

void e_text_insert_file(GtkWidget *textarea, gchar *filename)
{
 FILE *txt_fd;
 gchar internal[1024];
 e_assert_widget(textarea, "textarea is not a GtkWidget");
 txt_fd = fopen(filename, "r");
 if(txt_fd == NULL)
 {
  if(E_DEBUG) printf("EasyGTK: filename could not be open\n");
  return;
 }
 gtk_text_freeze(GTK_TEXT(textarea));
 while(fgets(internal, 1000, txt_fd)!=NULL)
 {
  gtk_text_insert(GTK_TEXT(textarea), NULL, NULL, NULL, internal, -1);
 }
 gtk_text_thaw(GTK_TEXT(textarea));
 fclose(txt_fd);
}

void e_text_delete(GtkWidget *textarea)
{
 e_assert_widget(textarea, "textarea is not a GtkWidget");
 gtk_text_set_point(GTK_TEXT(textarea), 0);
 gtk_text_forward_delete(GTK_TEXT(textarea),
 gtk_text_get_length(GTK_TEXT(textarea)));
}

char *e_text_get(GtkWidget *textarea)
{
 e_assert_widget(textarea, "textarea is not a GtkWidget");
 return (char*)gtk_editable_get_chars(GTK_EDITABLE(textarea), 0, gtk_text_get_length(GTK_TEXT(textarea)));
}

GtkWidget *e_label_create(GtkWidget *parent, gchar *text)
{
 GtkWidget *i_label;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_label = gtk_label_new(text);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_label);
 else gtk_box_pack_start(GTK_BOX(parent), i_label, TRUE, TRUE, 0);
 gtk_widget_show(i_label);
 return i_label;
}

GtkWidget *e_entry_create(GtkWidget *parent, gchar *initial_text)
{
 GtkWidget *i_entry;
 e_assert_widget(parent, "parent is not a GtkWidget"); 
 i_entry = gtk_entry_new();
 gtk_entry_set_text(GTK_ENTRY(i_entry), initial_text);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_entry);
 else gtk_box_pack_start(GTK_BOX(parent), i_entry, TRUE, TRUE, 0);
 gtk_widget_show(i_entry);
 return i_entry;
}

gchar *e_entry_get(GtkWidget *entry)
{
 e_assert_widget(entry, "entry is not a GtkWidget");
 return gtk_entry_get_text(GTK_ENTRY(entry));
}

GtkWidget *e_button_create(GtkWidget *parent, gchar *text, GtkSignalFunc button_click)
{
 GtkWidget *i_but;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_but = gtk_button_new_with_label(text);
 gtk_signal_connect_object(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(button_click), GTK_OBJECT(i_but));
 gtk_box_pack_start(GTK_BOX(parent), i_but, TRUE, TRUE, 0);
 gtk_widget_show(i_but);
 return i_but;
}

GtkWidget *e_button_fixed(GtkWidget *parent, gchar *text, GtkSignalFunc button_click)
{
 GtkWidget *i_but;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_but = gtk_button_new_with_label(text);
 gtk_signal_connect_object(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(button_click), GTK_OBJECT(i_but));
 gtk_box_pack_start(GTK_BOX(parent), i_but, FALSE, FALSE, 0);
 gtk_widget_show(i_but);
 return i_but;
}

GtkWidget *e_combo_create(GtkWidget *parent, gchar *initial_text, gchar *combo_list[], gint num, GtkSignalFunc item_selected)
{
 GtkWidget *i_combo;
 GList *cbitems = NULL;
 int i;
 e_assert_widget(parent, "parent is not a GtkWidget");
 for(i = 0; i < num; i++)
 {
  cbitems = g_list_append(cbitems, g_strdup((gchar*)combo_list[i]));
 }
 i_combo = gtk_combo_new();
 gtk_combo_set_popdown_strings(GTK_COMBO(i_combo), cbitems);
 gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(i_combo)->entry), initial_text);
 gtk_signal_connect(GTK_OBJECT(GTK_COMBO(i_combo)->entry), "changed",
 GTK_SIGNAL_FUNC(item_selected), i_combo);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_combo);
 else gtk_box_pack_start(GTK_BOX(parent), i_combo, TRUE, TRUE, 0);
 gtk_widget_show(i_combo);
 return i_combo;
}

gchar *e_combo_get(GtkWidget *combo)
{
 e_assert_widget(combo, "combo is not a GtkWidget");
 return gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
}

GtkWidget *e_list_create(GtkWidget *parent, gint cols, GtkSignalFunc item_selected)
{
 GtkWidget *i_s, *i_list;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_s = gtk_scrolled_window_new(NULL, NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(i_s),
 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_s);
 else gtk_box_pack_start(GTK_BOX(parent), i_s, TRUE, TRUE, 0);
 gtk_widget_show(i_s);

 i_list = gtk_clist_new_with_titles(cols, NULL);
 gtk_signal_connect(GTK_OBJECT(i_list), "select_row",
 GTK_SIGNAL_FUNC(e_internal_list_select), i_list);
 gtk_signal_connect(GTK_OBJECT(i_list), "select_row",
 GTK_SIGNAL_FUNC(item_selected), i_list);
 gtk_clist_set_shadow_type(GTK_CLIST(i_list), GTK_SHADOW_OUT);
 gtk_clist_set_selection_mode(GTK_CLIST(i_list), GTK_SELECTION_SINGLE);
 gtk_clist_column_titles_show(GTK_CLIST(i_list));
 gtk_container_add(GTK_CONTAINER(i_s), i_list);
 gtk_widget_show(i_list);
 return i_list;
}

void e_list_setup(GtkWidget *list, gint col, gchar *title, gint width)
{
 e_assert_widget(list, "list is not a GtkWidget");
 gtk_clist_set_column_title(GTK_CLIST(list), col, title);
 gtk_clist_set_column_width(GTK_CLIST(list), col, width);
}

void e_internal_list_select(GtkWidget *list, gint c, gint r)
{
 gchar *internal;
 int i;
 e_assert_widget(list, "list is not a GtkWidget");
 strcpy(current_list_selection, "");
 current_list_row = c;
 for(i = 0; i < GTK_CLIST(list)->columns; i++)
 {
  gtk_clist_get_text(GTK_CLIST(list), c, i, &internal);
  sprintf(current_list_selection, "%s | %s", current_list_selection, internal);
 }
}

gchar *e_list_get()
{
 return current_list_selection;
}

void e_list_insert(GtkWidget *list, gchar *text[])
{
 e_assert_widget(list, "list is not a GtkWidget");
 gtk_clist_append(GTK_CLIST(list), text);
}

void e_list_remove(GtkWidget *list)
{
 e_assert_widget(list, "list is not a GtkWidget");
 gtk_clist_remove(GTK_CLIST(list), current_list_row);
}

GtkWidget *e_buttonbox_create(GtkWidget *parent, gint orientation, gchar *button1_text, gchar *button2_text, GtkSignalFunc button1_click, GtkSignalFunc button2_click)
{
 GtkWidget *i_box, *i_but1, *i_but2;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_box = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(i_box), orientation);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(i_box), 10);
 gtk_box_pack_start(GTK_BOX(parent), i_box, FALSE, FALSE, 0);
 gtk_widget_show(i_box);

 i_but1 = gtk_button_new_with_label(button1_text);
 gtk_signal_connect_object(GTK_OBJECT(i_but1), "clicked",
 GTK_SIGNAL_FUNC(button1_click), GTK_OBJECT(i_but1));
 gtk_box_pack_start(GTK_BOX(i_box), i_but1, TRUE, TRUE, 0);
 gtk_widget_show(i_but1);

 i_but2 = gtk_button_new_with_label(button2_text);
 gtk_signal_connect_object(GTK_OBJECT(i_but2), "clicked",
 GTK_SIGNAL_FUNC(button2_click), GTK_OBJECT(i_but2));
 gtk_box_pack_start(GTK_BOX(i_box), i_but2, TRUE, TRUE, 0);
 gtk_widget_show(i_but2);
 return i_box;
}

/* e_buttonbox_unlim original by Chuck Mason, fixed by Piotr Klaban */
GtkWidget *e_buttonbox_unlim(GtkWidget *parent, gint orientation, guint num_buttons, ...)
{
 GtkWidget *i_box;
 guint temp;
 /*gchar *pointer;*/
 va_list ap;
 e_assert_widget(parent, "parent is not a GtkWidget");
 if(num_buttons < 1) return (GtkWidget *)NULL;
 
 i_box = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(i_box), orientation);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(i_box), 5);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_box);
 else gtk_box_pack_start(GTK_BOX(parent), i_box, FALSE, FALSE, 0);
 gtk_widget_show(i_box);

 va_start(ap, num_buttons); 
 /*pointer  = (gchar *)(&num_buttons);*/
 /*pointer += 4;*/

 for(temp = 0; temp < num_buttons; temp++)
 {
  /*guchar b1, b2, b3, b4;*/
  gchar *button_text;
  GtkSignalFunc button_click = NULL;
  GtkWidget *button;
  
  /*b1 = *pointer++; b2 = *pointer++; b3 = *pointer++; b4 = *pointer++;*/
  /*#ifdef __LSB__*/
  /*button_text = (gchar *)E_LSB_LONG_ADDR(b1, b2, b3, b4);*/
  /*#else*/
  /*button_text = (gchar *)E_MSB_LONG_ADDR(b1, b2, b3, b4);*/
  /*#endif*/

  /*b1 = *pointer++; b2 = *pointer++; b3 = *pointer++; b4 = *pointer++;*/
  /*#ifdef __LSB__*/
  /*button_click = (GtkSignalFunc)E_LSB_LONG_ADDR(b1, b2, b3, b4);*/
  /*#else*/
  /*button_text = (gchar *)E_MSB_LONG_ADDR(b1, b2, b3, b4);*/
  /*button_click = (GtkSignalFunc)E_MSB_LONG_ADDR(b1, b2, b3, b4);*/
  /*#endif*/
  button_text = va_arg(ap, gchar *);
  button_click = va_arg(ap, GtkSignalFunc);

  button = gtk_button_new_with_label(button_text);
  gtk_signal_connect_object(GTK_OBJECT(button), "clicked", 
  GTK_SIGNAL_FUNC(button_click), GTK_OBJECT(button));
  gtk_box_pack_start(GTK_BOX(i_box), button, TRUE, TRUE, 0);
  gtk_widget_show(button);
 }
 va_end(ap);
 return i_box;
}
 
void e_set_size(GtkWidget *widget, gint size_x, gint size_y)
{
 e_assert_widget(widget, "widget is not a GtkWidget");
 gtk_widget_set_usize(GTK_WIDGET(widget), size_x, size_y);
}

GSList *e_radiobuttons_create(GtkWidget *parent, gchar *items[], gint num)
{
 int i = 0;
 GSList *group;
 GtkWidget *i_but;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_but = gtk_radio_button_new_with_label(NULL, items[i]);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_but);
 else gtk_box_pack_start(GTK_BOX(parent), i_but, TRUE, TRUE, 0);
 gtk_signal_connect(GTK_OBJECT(i_but), "toggled", (GtkSignalFunc)e_internal_radiobutton, (gpointer)i);
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(i_but), TRUE);
 gtk_widget_show(i_but);

 group = gtk_radio_button_group(GTK_RADIO_BUTTON(i_but));

 i++;
 for(i=i; i < num; i++)
 {
  i_but = gtk_radio_button_new_with_label(gtk_radio_button_group (GTK_RADIO_BUTTON(i_but)), items[i]);
  if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_but);
  else gtk_box_pack_start(GTK_BOX(parent), i_but, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(i_but), "toggled", (GtkSignalFunc)e_internal_radiobutton, (gpointer)i);
  gtk_widget_show(i_but);
 }
 return group;
}

void e_internal_radiobutton(GtkWidget *widget, gint t)
{
 e_assert_widget(widget, "widget is not a GtkWidget");
 current_radiobutton = (++t);
 if(current_radiobutton==0) current_radiobutton=1;
}

gint e_radiobuttons_get()
{
 return current_radiobutton;
}

void e_radiobuttons_setdefault(gint choice)
{
 current_radiobutton = choice;
}

GtkWidget *e_checkbutton_create(GtkWidget *parent, gchar *text, gint default_state, GtkSignalFunc button_checked)
{
 GtkWidget *i_but;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_but = gtk_check_button_new_with_label(text);
 gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(i_but), default_state);
 gtk_signal_connect (GTK_OBJECT(i_but), "toggled",
 GTK_SIGNAL_FUNC(button_checked), i_but);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_but);
 else gtk_box_pack_start(GTK_BOX(parent), i_but, TRUE, TRUE, 0);
 gtk_widget_show(i_but);
 return i_but;
}

gint e_checkbutton_get(GtkWidget *checkbutton)
{
 e_assert_widget(checkbutton, "checkbutton is not a GtkWidget");
 return gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton));
}

GtkWidget *e_notebook_create(GtkWidget *parent, gint placement)
{
 GtkWidget *i_nb;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_nb = gtk_notebook_new();
 gtk_notebook_set_tab_pos(GTK_NOTEBOOK(i_nb), placement);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_nb);
 else gtk_box_pack_start(GTK_BOX(parent), i_nb, TRUE, TRUE, 0);
 gtk_notebook_set_scrollable(GTK_NOTEBOOK(i_nb), TRUE);
 gtk_widget_show(i_nb);
 return i_nb;
}

GtkWidget *e_notebook_new_page(GtkWidget *notebook, gchar *title, gchar *description)
{
 GtkWidget *i_frame, *i_label, *i_box;
 e_assert_widget(notebook, "notebook is not a GtkWidget");
 i_frame = gtk_frame_new(description);
 gtk_container_border_width(GTK_CONTAINER(i_frame), 5);
 gtk_widget_show(i_frame);

 i_label = gtk_label_new(title);
 gtk_notebook_append_page(GTK_NOTEBOOK(notebook), i_frame, i_label);

 i_box = gtk_vbox_new(FALSE, 0);
 gtk_container_add(GTK_CONTAINER(i_frame), i_box);
 gtk_container_border_width(GTK_CONTAINER(i_box), 2);
 gtk_widget_show(i_box);
 return i_box;
}

GtkWidget *e_show_message(gchar *title, gchar *message, GtkSignalFunc window_destroy)
{
 GtkWidget *i_win, *i_label, *i_but;

 i_win = gtk_dialog_new();
 gtk_widget_set_usize(GTK_WIDGET(i_win), strlen(message)+400, 120);
 gtk_signal_connect(GTK_OBJECT(i_win), "delete_event",
 GTK_SIGNAL_FUNC(window_destroy), i_win);
 gtk_window_set_title(GTK_WINDOW(i_win), title);
 gtk_container_border_width(GTK_CONTAINER(i_win), 5);
 gtk_window_set_position(GTK_WINDOW(i_win), GTK_WIN_POS_CENTER);
 gtk_widget_show(i_win);

 i_label = gtk_label_new(message);
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(i_win)->vbox), i_label, TRUE, TRUE, 0);
 gtk_widget_show(i_label);

 i_but = gtk_button_new_with_label("OK");
 gtk_signal_connect_object(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(window_destroy), GTK_OBJECT(i_win));
 gtk_box_pack_start(GTK_BOX(GTK_DIALOG(i_win)->action_area), i_but, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS(i_but, GTK_CAN_DEFAULT);
 gtk_widget_grab_default(i_but);
 gtk_widget_show(i_but);
 return i_win;
}

GtkWidget *e_browse_create(gchar *title, GtkSignalFunc ok_clicked, GtkSignalFunc cancel_clicked)
{
 GtkWidget *i_fs;
 i_fs = gtk_file_selection_new(title);
 gtk_signal_connect(GTK_OBJECT(i_fs), "delete_event",
 GTK_SIGNAL_FUNC(cancel_clicked), i_fs);
 gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION(i_fs)->ok_button),
 "clicked", GTK_SIGNAL_FUNC(ok_clicked), i_fs);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(i_fs)->cancel_button),
 "clicked", GTK_SIGNAL_FUNC(cancel_clicked), i_fs);
 gtk_window_set_position(GTK_WINDOW(i_fs), GTK_WIN_POS_CENTER);
 gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(i_fs));
 gtk_widget_show(i_fs);
 return i_fs;
}

gchar *e_browse_get(GtkWidget *browse)
{
 e_assert_widget(browse, "browse is not a GtkWidget");
 return gtk_file_selection_get_filename(GTK_FILE_SELECTION(browse));
}

GtkWidget *e_font_create(gchar *title, GtkSignalFunc ok_clicked, GtkSignalFunc cancel_clicked)
{
 GtkWidget *i_ft;
 i_ft = gtk_font_selection_dialog_new(title);
 gtk_window_set_position(GTK_WINDOW(i_ft), GTK_WIN_POS_CENTER);
 gtk_signal_connect(GTK_OBJECT(i_ft), "destroy",
 GTK_SIGNAL_FUNC(cancel_clicked), i_ft);
 gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(i_ft)->ok_button), "clicked", GTK_SIGNAL_FUNC(ok_clicked), GTK_FONT_SELECTION_DIALOG(i_ft));
 gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG (i_ft)->cancel_button), "clicked", GTK_SIGNAL_FUNC(cancel_clicked),GTK_OBJECT(i_ft));
 gtk_widget_show(i_ft);
 return i_ft;
}

gchar *e_font_get(GtkWidget *fs)
{
 e_assert_widget(fs, "fs is not a GtkWidget");
 return gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(fs));
}

GtkWidget *e_scrolled_create(GtkWidget *parent)
{
 GtkWidget *i_s;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_s = gtk_scrolled_window_new(NULL, NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(i_s),
 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_s);
 else gtk_box_pack_start(GTK_BOX(parent), i_s, TRUE, TRUE, 0);
 gtk_widget_show(i_s);
 return i_s;
}

GtkWidget *e_toolbar_create(GtkWidget *parent, int orientation)
{
 GtkWidget *i_tb;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_tb = gtk_toolbar_new(orientation, GTK_TOOLBAR_BOTH);
 gtk_toolbar_set_button_relief(GTK_TOOLBAR(i_tb), GTK_RELIEF_NONE);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_tb);
 else gtk_box_pack_start(GTK_BOX(parent), i_tb, FALSE, FALSE, 0);
 gtk_widget_show(i_tb);
 return i_tb;
}

void e_toolbar_insert(GtkWidget *toolbar, gchar *name, gchar *description, GtkWidget *icon, GtkSignalFunc button_clicked)
{
 e_assert_widget(toolbar, "toolbar is not a GtkWidget");
 gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), name, description, "", icon, GTK_SIGNAL_FUNC(button_clicked), GTK_OBJECT(toolbar));
}

GtkWidget *e_icon_create(GtkWidget *window, gchar *filename)
{ 
 GtkStyle *style;
 GdkPixmap *pix;
 GdkBitmap *mask;
 GtkWidget *i_w;
 e_assert_widget(window, "window is not a GtkWidget");
 style = gtk_widget_get_style(window);
 pix = gdk_pixmap_create_from_xpm(window->window, &mask, &style->bg[GTK_STATE_NORMAL], filename);
 i_w = gtk_pixmap_new(pix, mask);
 return i_w;
}

#ifdef USE_IMLIB
GtkWidget *e_image_create(GtkWidget *parent, gchar *filename)
{
 gint w, h;
 GdkPixmap             *p;
 GdkImlibImage         *im;
 GtkWidget *i_pix;
 e_assert_widget(parent, "parent is not a GtkWidget");
 gtk_widget_push_visual(gdk_imlib_get_visual());
 gtk_widget_push_colormap(gdk_imlib_get_colormap());
 im=gdk_imlib_load_image(filename);
 w=im->rgb_width;h=im->rgb_height;
 gdk_imlib_render(im,w,h);
 gdk_flush();
 g_im = im;
 p = gdk_imlib_copy_image(im);
 i_pix = gtk_pixmap_new(p, gdk_imlib_copy_mask(im));
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_pix);
 else gtk_box_pack_start(GTK_BOX(parent), i_pix, TRUE, TRUE, 0);
 gtk_widget_show(i_pix);
 return i_pix;
}

GtkWidget *e_image_scaled(GtkWidget *parent, gchar *filename, gint size_x, gint size_y)
{
 gint w, h;
 GdkPixmap *p;
 GdkImlibImage *im;
 GtkWidget *i_pix;
 e_assert_widget(parent, "parent is not a GtkWidget");
 gtk_widget_push_visual(gdk_imlib_get_visual());
 gtk_widget_push_colormap(gdk_imlib_get_colormap());
 im=gdk_imlib_load_image(filename);
 w=size_x; h=size_y;
 gdk_imlib_render(im,w,h);
 gdk_flush();
 g_im = im;
 p = gdk_imlib_copy_image(im);
 i_pix = gtk_pixmap_new(p, gdk_imlib_copy_mask(im));
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_pix);
 else gtk_box_pack_start(GTK_BOX(parent), i_pix, TRUE, TRUE, 0);
 gtk_widget_show(i_pix);
 return i_pix;
}

GdkWindow *e_image_window(gchar *filename)
{
 GdkWindowAttr attr;
 GdkWindow *win;
 GdkPixmap *p,*m;
 GdkImlibImage *im;
 gint w,h;
 gtk_widget_push_visual(gdk_imlib_get_visual());
 gtk_widget_push_colormap(gdk_imlib_get_colormap());       
 im=gdk_imlib_load_image(filename);
 w=im->rgb_width;h=im->rgb_height;
 attr.window_type=GDK_WINDOW_TOPLEVEL;
 attr.wclass=GDK_INPUT_OUTPUT;
 attr.event_mask=GDK_STRUCTURE_MASK;
 attr.width=w;
 attr.height=h;
 win=gdk_window_new(NULL,&attr,0);
 gdk_imlib_render(im,w,h);
 p=gdk_imlib_move_image(im);
 m=gdk_imlib_move_mask(im);
 gdk_window_set_back_pixmap(win,p,0);
 if(m) gdk_window_shape_combine_mask(win,m,0,0);
 gdk_window_show(win);
 gdk_flush();
 g_im = im;
 return win;
}

GdkImlibImage *e_image_get()
{
 return g_im;
}
#endif

GtkWidget *e_menu_create(GtkWidget *parent)
{
 GtkWidget *i_menu;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_menu = gtk_menu_bar_new();
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_menu);
 else gtk_box_pack_start(GTK_BOX(parent), i_menu, FALSE, FALSE, 0);
 gtk_widget_show(i_menu);
 return i_menu;
}

GtkWidget *e_menu_insert_menu(GtkWidget *menubar, gchar *name, gint justify)
{
 GtkWidget *i_menu, *i_item;
 e_assert_widget(menubar, "menubar is not a GtkWidget");
 i_menu = gtk_menu_new();
 i_item = gtk_menu_item_new_with_label(name);
 gtk_widget_show(i_item);
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(i_item), i_menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), i_item);
 if(justify == E_RIGHT)
 gtk_menu_item_right_justify(GTK_MENU_ITEM(i_item));
 return i_menu;
}

GtkWidget *e_menu_insert_item(GtkWidget *menu, gchar *name, GtkSignalFunc item_clicked)
{
 GtkWidget *i_item;
 e_assert_widget(menu, "menu is not a GtkWidget");
 i_item = gtk_menu_item_new_with_label(name);
 gtk_menu_append(GTK_MENU(menu), i_item);
 gtk_signal_connect_object(GTK_OBJECT(i_item), "activate",
 GTK_SIGNAL_FUNC(item_clicked), NULL);
 gtk_widget_show(i_item);
 return i_item;
}

GtkWidget *e_menu_insert_line(GtkWidget *menu)
{
 GtkWidget *i_item;
 e_assert_widget(menu, "menu is not a GtkWidget");
 i_item = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(menu), i_item);
 gtk_widget_show(i_item);
 return i_item;
}

gint e_config_insert(gchar *filename, gchar *key, gchar *data)
{
#ifdef USE_GNOME_CONFIG
 gchar path[strlen(key) + strlen("/General/") + strlen(filename) + 2];
 sprintf(path, "%s/General/%s", filename, key);
 gnome_config_set_string(path, data);
#else
 FILE *cfg_fd;
 gint internal_i;
 for(internal_i=0;*(data+internal_i)!='\0';internal_i++)
 {
  if(*(data+internal_i)=='\n') *(data+internal_i)=' ';
 }
 cfg_fd = fopen(filename, "a");
 if(cfg_fd==NULL)
 {
  if(E_DEBUG) printf("EasyGTK: Could not open file for writing\n");
  return -1;
 }
 fputs("|", cfg_fd);
 fputs(key, cfg_fd);
 fputs("|", cfg_fd);
 fputs(data,cfg_fd);
 fputs("|\n",cfg_fd);
 fclose(cfg_fd);
#endif
 return 0;
}

gint e_config_update(gchar *filename, gchar *key, gchar *data)
{
#ifdef USE_GNOME_CONFIG
 gchar path[strlen(key) + strlen("/General/") + strlen(filename) + 2];
 sprintf(path, "%s/General/%s", filename, key);
 gnome_config_set_string(path, data);
#else
 gchar internal[1024], tmp_file[100];
 gint internal_count = -1, internal_i;
 FILE *cfg_fd1, *cfg_fd2;
 for(internal_i=0;*(data+internal_i)!='\0';internal_i++)
 {
  if(*(data+internal_i)=='\n') *(data+internal_i)=' ';
 }
 strncpy(tmp_file, tempnam(NULL,".eag"), 50);
 cfg_fd1 = fopen(filename, "r");
 cfg_fd2 = fopen(tmp_file, "a");
 if(cfg_fd1==NULL)
 {
  if(E_DEBUG) printf("EasyGTK: Could not open file for reading\n");
  return -1;
 }
 if(cfg_fd2==NULL)
 {
  if(E_DEBUG) printf("EasyGTK: Could not temporary file for writing\n");
  return -1;
 }
 while(fgets(internal, 1000, cfg_fd1)!=NULL)
 {
  if(!strcmp(e_lindex_delim(internal,0,"|"),key))
  {
   fputs("|", cfg_fd2);
   fputs(key, cfg_fd2);
   fputs("|", cfg_fd2);
   fputs(data, cfg_fd2);
   fputs("|\n", cfg_fd2);
   internal_count = 0;
  }
  else fputs(internal, cfg_fd2);
 }
 if(internal_count == -1)
 {
  fputs("|", cfg_fd2);
  fputs(key, cfg_fd2);
  fputs("|", cfg_fd2);
  fputs(data, cfg_fd2);
  fputs("|\n", cfg_fd2);
 }
 fclose(cfg_fd1);
 fclose(cfg_fd2);
 sprintf(internal, "mv \"%s\" \"%s\"", tmp_file, filename);
 system(internal);
 return internal_count;
#endif
 return 0;
}

gchar *e_config_fetch(gchar *filename, gchar *key)
{
#ifdef USE_GNOME_CONFIG
 gchar path[strlen(key) + strlen("/General/") + strlen(filename) + 2];
 sprintf(path, "%s/General/%s", filename, key);
 return gnome_config_get_string(path);
#else
 gchar internal[1024];
 FILE *cfg_fd;
 cfg_fd = fopen(filename, "r");
 if(cfg_fd==NULL)
 {
  if(E_DEBUG) printf("EasyGTK: Could not open file for reading\n");
  return "";
 }
 while(fgets(internal, 1000, cfg_fd)!=NULL)
 {
  if(!strcmp(e_lindex_delim(internal,0,"|"),key))
  {
   fclose(cfg_fd);
   return g_strdup(e_lindex_delim(internal,1,"|"));
  }
 }
 fclose(cfg_fd);
 return "";
#endif
}

gchar *e_lrange(gchar *input_string, gint starting_at)
{
 gchar *tokens[1024];
 static gchar tmpstring[1024]="";
 gint i;
 gchar out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);
  strncpy(internal_result,out_string,1000);
  return g_strdup(internal_result); }
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while(((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at)
 {
  return (char *)"";
 }
 while(tokens[starting_at] != NULL)
 {
  strncat(out_string,tokens[starting_at],1024);
  strcat(out_string, " ");
  starting_at++;
 }
 strncpy(internal_result, out_string, 1000);
 return g_strdup(internal_result);
}

gchar *e_lindex(gchar *input_string, gint word_number)
{
 gchar *tokens[1024];
 static gchar tmpstring[1024];
 gint i;
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while (((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 return(g_strdup(tokens[word_number]));
}

gchar *e_lindex_delim(gchar *input_string, gint word_number, gchar *delim)
{
 gchar *tokens[1024];
 static gchar tmpstring[1024];
 gint i;
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, delim);
 while (((char *)tokens[++i] = (char *)strtok(NULL, delim)));
 tokens[i] = NULL;
 return(g_strdup(tokens[word_number]));
}

GtkWidget *e_tree_create(GtkWidget *parent)
{
 GtkWidget *i_s, *i_tree;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_s = gtk_scrolled_window_new(NULL, NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(i_s),
 GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_s);
 else gtk_box_pack_start(GTK_BOX(parent), i_s, TRUE, TRUE, 0);
 gtk_widget_show(i_s);
 i_tree = gtk_tree_new();
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(i_s), i_tree);
 gtk_tree_set_selection_mode(GTK_TREE(i_tree), GTK_SELECTION_SINGLE);
 gtk_widget_show(i_tree);
 return i_tree;
}

GtkWidget *e_tree_insert_subtree(GtkWidget *tree, gchar *name)
{
 GtkWidget *i_item, *i_tree;
 e_assert_widget(tree, "tree is not a GtkWidget");
 i_item = gtk_tree_item_new_with_label(name);
 gtk_tree_append(GTK_TREE(tree), i_item);
 gtk_widget_show(i_item);
 i_tree = gtk_tree_new();
 gtk_tree_set_selection_mode(GTK_TREE(i_tree), GTK_SELECTION_SINGLE);
 gtk_tree_set_view_mode(GTK_TREE(i_tree), GTK_TREE_VIEW_ITEM);
 gtk_tree_item_set_subtree(GTK_TREE_ITEM(i_item), i_tree);
 return i_tree;
}

GtkWidget *e_tree_insert_item(GtkWidget *tree, gchar *name, GtkSignalFunc item_clicked)
{
 GtkWidget *i_item;
 e_assert_widget(tree, "tree is not a GtkWidget");
 i_item = gtk_tree_item_new_with_label(name);
 gtk_tree_append(GTK_TREE(tree), i_item);
 gtk_signal_connect(GTK_OBJECT(i_item), "select",
 GTK_SIGNAL_FUNC(e_internal_tree_item), i_item);
 gtk_signal_connect(GTK_OBJECT(i_item), "select",
 GTK_SIGNAL_FUNC(item_clicked), i_item);
 gtk_widget_show(i_item);
 return i_item;
}

void e_internal_tree_item(GtkWidget *item)
{
 gchar *i_c;
 GtkLabel *i_label = GTK_LABEL(GTK_BIN(item)->child);
 e_assert_widget(item, "item is not a GtkWidget");
 gtk_label_get(i_label, &i_c);
 strncpy(internal_tree, i_c, 1000);
}

gchar *e_tree_get()
{
 return internal_tree;
}

#ifdef USE_MAGICK
gint e_image_convert(gchar *infile, gchar *outfile)
{
 Image *image;
 ImageInfo image_info;
 GetImageInfo(&image_info);
 strcpy(image_info.filename, infile);
 image=ReadImage(&image_info);
 if(image == (Image *)NULL) return -1;
 strcpy(image->filename, outfile);
 WriteImage(&image_info, image);
 DestroyImage(image);
 return 0;
}

void e_image_display(gchar *filename)
{
 Image *image;
 ImageInfo image_info;
 GetImageInfo(&image_info);
 strcpy(image_info.filename, filename);
 image=ReadImage(&image_info);
 DisplayImages(&image_info, image);
}
#endif

GtkWidget *e_pixmap_create(char **xpm_data, GdkWindow *window)
{
 GdkColormap *i_cmap;
 GdkColor i_color;
 GtkWidget *i_pix;
 GdkPixmap *pixm;
 GdkBitmap *mask;
 i_cmap = gdk_colormap_get_system();
 e_internal_extract_color(&i_color, 0, 0, 0);
 gdk_color_alloc(i_cmap, &i_color);
 pixm = gdk_pixmap_create_from_xpm_d(window, &mask, &i_color, (gchar**)xpm_data);
 i_pix = gtk_pixmap_new(pixm, mask);
 gtk_widget_show(i_pix);
 return i_pix;
}

gushort e_internal_convert_color(unsigned c)
{
 if (c==0) return(0);
 c *= 257;
 return(c > 0xffff)? 0xffff : c;
}

void e_internal_extract_color(GdkColor *color, unsigned red, unsigned green, unsigned blue)
{
 color->red = e_internal_convert_color(red);
 color->green = e_internal_convert_color(green);
 color->blue = e_internal_convert_color(blue);
}

GtkWidget *e_button_create_with_pixmap(GtkWidget *parent, GtkWidget *icon, GtkSignalFunc button_clicked)
{
 GtkWidget *i_but;
 e_assert_widget(parent, "parent is not a GtkWidget");
 i_but = gtk_button_new();
 gtk_signal_connect(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(button_clicked), NULL);
 gtk_container_add(GTK_CONTAINER(i_but), icon);
 if(GTK_IS_CONTAINER(parent)) gtk_container_add(GTK_CONTAINER(parent), i_but);
 else gtk_box_pack_start(GTK_BOX(parent), i_but, TRUE, TRUE, 0);
 gtk_widget_show(i_but);
 return i_but;
}

GtkWidget *e_event_create(GtkWidget *parent, gint size_x, gint size_y, GtkSignalFunc area_clicked)
{
 GtkWidget *i_area, *i_s;
 e_assert_widget(parent, "parent is not a GtkWidget");

 i_s = e_scrolled_create(parent);

 e_table = gtk_table_new(3, 2, FALSE);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(i_s), e_table);

 i_area = gtk_event_box_new();
 gtk_table_attach(GTK_TABLE(e_table), i_area, 1, 2, 1, 2, GTK_EXPAND|GTK_FILL, GTK_FILL, 0, 0 );
 gtk_widget_unrealize(GTK_WIDGET(i_area));
 gtk_widget_set_events(i_area, GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_PRESS_MASK);
 gtk_signal_connect(GTK_OBJECT(i_area), "button_press_event",
 GTK_SIGNAL_FUNC(e_internal_event_clicked), NULL);
 gtk_signal_connect(GTK_OBJECT(i_area), "button_press_event",
 GTK_SIGNAL_FUNC(area_clicked), NULL);

 e_hruler = gtk_hruler_new();
 gtk_ruler_set_metric(GTK_RULER(e_hruler), GTK_PIXELS);
 gtk_ruler_set_range(GTK_RULER(e_hruler), 0, 100, 0, size_x);
 gtk_signal_connect_object(GTK_OBJECT(i_area), "motion_notify_event",
 (GtkSignalFunc)E_EVENT_METHOD(e_hruler, motion_notify_event), GTK_OBJECT(e_hruler));
 gtk_table_attach(GTK_TABLE(e_table), e_hruler, 1, 2, 0, 1,
 GTK_EXPAND|GTK_SHRINK|GTK_FILL, GTK_FILL, 0, 0 );
         
 e_vruler = gtk_vruler_new();
 gtk_ruler_set_metric(GTK_RULER(e_vruler), GTK_PIXELS);
 gtk_ruler_set_range(GTK_RULER(e_vruler), 0, 100, 10, size_y );
 gtk_signal_connect_object(GTK_OBJECT(i_area), "motion_notify_event",
 (GtkSignalFunc)E_EVENT_METHOD(e_vruler, motion_notify_event), GTK_OBJECT(e_vruler));
 gtk_table_attach(GTK_TABLE(e_table), e_vruler, 0, 1, 1, 2,
 GTK_FILL, GTK_EXPAND|GTK_SHRINK|GTK_FILL, 0, 0 );
 gtk_widget_show(i_area);
 gtk_widget_show(e_hruler);
 gtk_widget_show(e_vruler);
 gtk_widget_show(e_table);
 return i_area;
}

void e_internal_event_clicked()
{
 internal_event_x = GTK_RULER(e_hruler)->position;
 internal_event_y = GTK_RULER(e_vruler)->position;
}

gint e_event_get_x()
{
 return (gint)internal_event_x;
}

gint e_event_get_y()
{
 return (gint)internal_event_y;
}

GtkWidget *e_query_create(gchar *title, gchar *message, GtkSignalFunc ok_clicked, GtkSignalFunc cancel_clicked)
{
 GtkWidget *i_win, *i_entry, *i_box, *i_label, *i_but, *i_box2;

 i_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize(GTK_WIDGET(i_win), strlen(message)+400, 150);
 gtk_signal_connect(GTK_OBJECT(i_win), "delete_event",
 GTK_SIGNAL_FUNC(cancel_clicked), i_win);
 gtk_window_set_title(GTK_WINDOW(i_win), title);
 gtk_window_set_position(GTK_WINDOW(i_win), GTK_WIN_POS_CENTER);
 gtk_container_border_width(GTK_CONTAINER(i_win), 10);
 gtk_widget_show(i_win);

 i_box = gtk_vbox_new(FALSE, 0);
 gtk_container_add(GTK_CONTAINER(i_win), i_box);
 gtk_widget_show(i_box);

 i_label = gtk_label_new(message);
 gtk_box_pack_start(GTK_BOX(i_box), i_label, TRUE, TRUE, 0);
 gtk_widget_show(i_label);

 i_entry = gtk_entry_new();
 gtk_box_pack_start(GTK_BOX(i_box), i_entry, TRUE, TRUE, 0);
 gtk_widget_show(i_entry);

 i_box2 = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(i_box2), E_SPREAD);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(i_box2), 10);
 gtk_box_pack_start(GTK_BOX(i_box), i_box2, FALSE, FALSE, 0);
 gtk_widget_show(i_box2);

 i_but = gtk_button_new_with_label("OK");
 gtk_signal_connect_object(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(ok_clicked), GTK_OBJECT(i_win));
 gtk_box_pack_start(GTK_BOX(i_box2), i_but, TRUE, TRUE, 0);
 gtk_widget_show(i_but);

 i_but = gtk_button_new_with_label("Cancel");
 gtk_signal_connect_object(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(cancel_clicked), GTK_OBJECT(i_win));
 gtk_box_pack_start(GTK_BOX(i_box2), i_but, TRUE, TRUE, 0);
 gtk_widget_show(i_but);

 return i_entry;
}

gchar *e_query_get(GtkWidget *query)
{
 e_assert_widget(query, "query is not a GtkWidget");
 return gtk_entry_get_text(GTK_ENTRY(query));
}

GtkWidget *e_show_textbox(gchar *title, gchar *initext, GtkSignalFunc close_window)
{
 GtkWidget *i_win, *i_box, *i_but;
 i_win = e_window_create(title, 400, 250, 0, 0, close_window);
 i_box = e_box_create(i_win, E_VERTICAL, 10);
 e_text_create(i_box, FALSE, initext, E_NO_FUNC);
 i_but = gtk_button_new_with_label("Close");
 gtk_signal_connect_object(GTK_OBJECT(i_but), "clicked",
 GTK_SIGNAL_FUNC(close_window), GTK_OBJECT(i_win));
 gtk_box_pack_start(GTK_BOX(i_box), i_but, FALSE, FALSE, 0);
 gtk_widget_show(i_but);
 return i_win;
}

E_Wizard *e_wizard_create(gchar *title, GtkWidget *icon, gchar *text, gint entry_box, GtkSignalFunc prev_button, GtkSignalFunc next_button, GtkSignalFunc cancel_button)
{
 GtkWidget *i_box, *i_box2;
 E_Wizard *i_w;
 i_w = malloc(sizeof(struct _E_Wizard));
 i_w->window = e_window_create(title, 550, 400, 0, 0, cancel_button);
 i_box = e_box_create(i_w->window, E_VERTICAL, 10);
 i_box2 = e_box_create(i_box, E_HORIZONTAL, 0);
 e_box_add(i_box2, icon, E_RIGHT, FALSE);
 e_text_create(i_box, FALSE, text, E_NO_FUNC);
 if(entry_box==TRUE) i_w->entry = e_entry_create(i_box, "");
 else i_w->entry = NULL;
 e_buttonbox_unlim(i_box, E_END, 3, "Cancel", GTK_SIGNAL_FUNC(cancel_button), "<- Previous", GTK_SIGNAL_FUNC(prev_button), "Next ->", GTK_SIGNAL_FUNC(next_button));
 return i_w;
}

void e_editor_create(E_Editor *editor)
{
 GtkWidget *i_menubar, *i_menu, *i_box;
 editor->window = e_window_create(editor->filename, 500, 400, 0, 0, editor->menu_close);
 editor->box = e_box_create(editor->window, E_VERTICAL, 5);
 i_box = e_box_fixed(editor->box, E_HORIZONTAL, 0);
 i_menubar = e_menu_create(i_box);
 if(editor->menu_file)
 {
  i_menu = e_menu_insert_menu(i_menubar, "File", E_LEFT);
  e_menu_insert_item(i_menu, "New", GTK_SIGNAL_FUNC(editor->menu_new));
  e_menu_insert_item(i_menu, "Open", GTK_SIGNAL_FUNC(editor->menu_open));
  e_menu_insert_item(i_menu, "Save", GTK_SIGNAL_FUNC(editor->menu_save));
  e_menu_insert_line(i_menu);
  e_menu_insert_item(i_menu, "Close", GTK_SIGNAL_FUNC(editor->menu_close));
 }
 if(editor->menu_edit)
 {
  i_menu = e_menu_insert_menu(i_menubar, "Edit", E_LEFT);
  e_menu_insert_item(i_menu, "Cut", GTK_SIGNAL_FUNC(editor->menu_cut));
  e_menu_insert_item(i_menu, "Copy", GTK_SIGNAL_FUNC(editor->menu_copy));
  e_menu_insert_item(i_menu, "Paste", GTK_SIGNAL_FUNC(editor->menu_paste)); 
 }
 if(editor->menu_help)
 {
  i_menu = e_menu_insert_menu(i_menubar, "Help", E_RIGHT);
  e_menu_insert_item(i_menu, "About", GTK_SIGNAL_FUNC(editor->menu_about));
 }
 editor->text = e_text_create(editor->box, editor->editable, "", E_NO_FUNC);
 if(editor->init_load) e_text_insert_file(editor->text, editor->filename);
}
