/*                                                            -*- C -*-
 * Copyright (c) 1997, 98, 99, 2000, 01  
 *    Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef EB_BUILD_POST_H
#define EB_BUILD_POST_H

#include "defs.h"

/*
 * Text domain name.
 */
#define EB_TEXT_DOMAIN_NAME	"eb"

/*
 * Locale directory.
 */
#define LOCALEDIR		"/usr/private/share/locale"

/*
 * Directory names.
 */
#define EB_DIRECTORY_NAME_DATA		"data"
#define EB_DIRECTORY_NAME_GAIJI		"gaiji"
#define EB_DIRECTORY_NAME_STREAM	"stream"
#define EB_DIRECTORY_NAME_MOVIE		"movie"

/*
 * Search word types.
 */
#define EB_WORD_ALPHABET		0
#define EB_WORD_KANA			1
#define EB_WORD_OTHER			2
#define EB_WORD_INVALID			-1

/*
 * Index Style flags.
 */
#define EB_INDEX_STYLE_CONVERT		0
#define EB_INDEX_STYLE_ASIS		1
#define EB_INDEX_STYLE_REVERSED_CONVERT	2
#define EB_INDEX_STYLE_DELETE		2

/*
 * Text content currently read.
 */
#define EB_TEXT_TEXT			1
#define EB_TEXT_HEADING			2
#define EB_TEXT_RAWTEXT			3
#define EB_TEXT_OPTIONAL_TEXT		4
#define EB_TEXT_SEEKED			0
#define EB_TEXT_INVALID			-1

/*
 * Search method currently processed.
 */
#define EB_SEARCH_EXACTWORD		0
#define EB_SEARCH_WORD			1
#define EB_SEARCH_ENDWORD		2
#define EB_SEARCH_KEYWORD		3
#define EB_SEARCH_MULTI			4
#define EB_SEARCH_NONE			-1

/*
 * Arrangement style of entries in a search index page.
 */
#define EB_ARRANGE_FIXED		0
#define EB_ARRANGE_VARIABLE		1
#define EB_ARRANGE_INVALID		-1

/*
 * Binary data types.
 */
#define EB_BINARY_MONO_GRAPHIC		0
#define EB_BINARY_COLOR_GRAPHIC		1
#define EB_BINARY_WAVE			2
#define EB_BINARY_MPEG			3
#define EB_BINARY_GRAY_GRAPHIC		4
#define EB_BINARY_INVALID		-1

/*
 * The maximum index depth of search indexes.
 */
#define EB_MAX_INDEX_DEPTH		6

/*
 * The environment variable name to enable/disable debug messages.
 */
#define EB_DEBUG_ENVIRONMENT_VARIABLE	"EB_DEBUG"

/*
 * Trace log macro.
 */
#define LOG(x) do {if (eb_log_flag) eb_log x;} while (0)

/*
 * Get an unsigned value from an octet stream buffer.
 */
#define eb_uint1(p) (*(const unsigned char *)(p))

#define eb_uint2(p) ((*(const unsigned char *)(p) << 8) \
        + (*(const unsigned char *)((p) + 1)))

#define eb_uint3(p) ((*(const unsigned char *)(p) << 16) \
        + (*(const unsigned char *)((p) + 1) << 8) \
        + (*(const unsigned char *)((p) + 2)))

#define eb_uint4(p) ((*(const unsigned char *)(p) << 24) \
        + (*(const unsigned char *)((p) + 1) << 16) \
        + (*(const unsigned char *)((p) + 2) << 8) \
        + (*(const unsigned char *)((p) + 3)))

#define eb_uint4_le(p) ((*(const unsigned char *)(p)) \
        + (*(const unsigned char *)((p) + 1) << 8) \
        + (*(const unsigned char *)((p) + 2) << 16) \
        + (*(const unsigned char *)((p) + 3) << 24))

/*
 * External variable declarations.
 */
/* log.c */
extern int eb_log_flag;

/* hook.c */
extern EB_Hookset eb_default_hookset;

/*
 * Function declarations.
 */
/* appendix.c */
void eb_initialize_alt_caches EB_P((EB_Appendix *));
void eb_finalize_alt_caches EB_P((EB_Appendix *));

/* appsub.c */
void eb_initialize_appendix_subbooks EB_P((EB_Appendix *));
void eb_finalize_appendix_subbooks EB_P((EB_Appendix *));

/* binary.c */
void eb_initialize_binary_context EB_P((EB_Book *));
void eb_reset_binary_context EB_P((EB_Book *));
void eb_finalize_binary_context EB_P((EB_Book *));

/* filename.c */
EB_Error_Code eb_canonicalize_path_name EB_P((char *));
void eb_canonicalize_file_name EB_P((char *));
EB_Error_Code eb_fix_directory_name EB_P((const char *, char *));
EB_Error_Code eb_fix_directory_name2 EB_P((const char *, const char *,
    char *));
void eb_fix_path_name_suffix EB_P((char *, const char *suffix));
EB_Error_Code eb_find_file_name EB_P((const char *, const char *, char *));
EB_Error_Code eb_find_file_name2 EB_P((const char *, const char *,
    const char *, char *));
EB_Error_Code eb_find_file_name3 EB_P((const char *, const char *,
    const char *, const char *, char *));
void eb_compose_path_name EB_P((const char *, const char *, char *));
void eb_compose_path_name2 EB_P((const char *, const char *, const char *,
    char *));
void eb_compose_path_name3 EB_P((const char *, const char *, const char *,
    const char *, char *));
void eb_path_name_zio_code EB_P((const char *, Zio_Code, Zio_Code *));

/* font.c */
void eb_initialize_fonts EB_P((EB_Book *));
void eb_finalize_fonts EB_P((EB_Book *));

/* hook.c */
void eb_initialize_default_hookset EB_P((void));

/* jacode.c */
void eb_jisx0208_to_euc EB_P((char *, const char *));
void eb_sjis_to_euc EB_P((char *, const char *));

/* lock.c */
#ifdef ENABLE_PTHREAD
void eb_initialize_lock EB_P((EB_Lock *));
void eb_finalize_lock EB_P((EB_Lock *));
void eb_lock EB_P((EB_Lock *));
void eb_unlock EB_P((EB_Lock *));
#else /* not ENABLE_PTHREAD */
#define eb_lock(x)
#define eb_unlock(x)
#define eb_initialize_lock(x)
#define eb_finalize_lock(x)
#endif /* not ENABLE_PTHREAD */

/* log.c */
void eb_initialize_log EB_P((void));
const char *eb_quoted_stream EB_P((const char *, size_t));
const char *eb_quoted_string EB_P((const char *));

/* match.c */
int eb_match_canonicalized_word EB_P((const char *, const char *, size_t));
int eb_exact_match_canonicalized_word EB_P((const char *, const char *,
    size_t));
int eb_match_word_latin EB_P((const char *, const char *, size_t));
int eb_match_word_jis EB_P((const char *, const char *, size_t));
int eb_exact_match_word_latin EB_P((const char *, const char *, size_t));
int eb_exact_match_word_jis EB_P((const char *, const char *, size_t));

/* message.c */
EB_Error_Code eb_initialize_messages EB_P((EB_Book *));

/* multi.c */
void eb_initialize_multi_searches EB_P((EB_Book *));
void eb_finalize_multi_searches EB_P((EB_Book *));
EB_Error_Code eb_load_multi_searches EB_P((EB_Book *));

/* narwfont.c */
EB_Error_Code eb_load_narrow_font EB_P((EB_Book *));

/* search.c */
void eb_initialize_search_contexts EB_P((EB_Book *));
void eb_finalize_search_contexts EB_P((EB_Book *));
void eb_reset_search_contexts EB_P((EB_Book *));
void eb_initialize_search EB_P((EB_Search *));
void eb_finalize_search EB_P((EB_Search *));
void eb_initialize_searches EB_P((EB_Book *book));
void eb_finalize_searches EB_P((EB_Book *book));
EB_Error_Code eb_presearch_word EB_P((EB_Book *, EB_Search_Context *));
EB_Error_Code eb_hit_list EB_P((EB_Book *, int, EB_Hit *, int *));

/* setword.c */
EB_Error_Code eb_set_word EB_P((EB_Book *, const char *, char *, char *,
    EB_Word_Code *));
EB_Error_Code eb_set_endword EB_P((EB_Book *, const char *, char *, char *,
    EB_Word_Code *));
EB_Error_Code eb_set_keyword EB_P((EB_Book *, const char *, char *, char *,
    EB_Word_Code *));
EB_Error_Code eb_set_multiword EB_P((EB_Book *, EB_Multi_Search_Code,
    EB_Multi_Entry_Code, const char *, char *, char *, EB_Word_Code *));

/* subbook.c */
void eb_initialize_subbooks EB_P((EB_Book *book));
void eb_finalize_subbooks EB_P((EB_Book *book));

/* text.c */
void eb_initialize_text_context EB_P((EB_Book *));
void eb_finalize_text_context EB_P((EB_Book *));
void eb_reset_text_context EB_P((EB_Book *));
void eb_invalidate_text_context EB_P((EB_Book *));
EB_Error_Code eb_forward_heading EB_P((EB_Book *));

/* widefont.c */
EB_Error_Code eb_load_wide_font EB_P((EB_Book *));

/* uint.c */
unsigned eb_bcd2 EB_P((const char *));
unsigned eb_bcd4 EB_P((const char *));
unsigned eb_bcd6 EB_P((const char *));

/* memmove.c */
#ifdef __STDC__
void *eb_memmove(void *, const void *, size_t);
#else
char *eb_memmove();
#endif

/* strcasecmp.c */
int eb_strcasecmp EB_P((const char *, const char *));
int eb_strncasecmp EB_P((const char *, const char *, size_t));

#endif /* not EB_BUILD_POST_H */
