/* $Id: tstring.cc,v 1.3 2002/02/13 03:53:56 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "tstring.h"

TString::TString(int l) {
  initl=l;
  data=(char *)g_malloc0(initl);
  dtoken=data;
}

TString::TString(char *s) {
  initl=strlen(s)+1;
  data=(char *)g_malloc0(initl);
  strcpy(data,s);
  dtoken=data;
}

TString::~TString() {
  g_free(data);
}

char * TString::contains(char *t) {
  return(strstr(data,t));
}

char * TString::token(char *t) {
  char *p,*m,*at;

  m=data+initl;

  for(p=dtoken;p<m;p++) {
    if (strchr(t,p[0])==NULL)
      break;
  }
  if (p==m) { return NULL; }

  at=p;
  for(p=at;p<m;p++) {
    if ((p[0]==0)||(strchr(t,p[0])!=NULL)) {
      p[0]=0;
      dtoken=&p[1];
      return at;
    }
  }
  return NULL;
}

char *TString::advance(char *t) {
  char *p,*m;

  m=data+initl;

  for(p=dtoken;p<m;p++) {
    if (strchr(t,p[0])!=NULL)
      break;
  }
  p++;
  if (p>=m) { return NULL; }
  dtoken=p;
  return p;
}
/* advances token position until
   next occurence of a character in t 
   
   e.g.: in "foo bar !give me!" 
   advance("!") will return
   the string suffix
   
   "give me!"
*/

void TString::set(char *s) {
  memset(data,0,initl);
  strncpy(data,s,initl=strlen(s));
  initl++;
  dtoken=data;
}
