/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef DIALOGS_H
#define DIALOGS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>

#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/label.h>
#include <gtk--/button.h>
#include <gtk--/fileselection.h>
#include <gtk--/text.h>
#include <gtk--/pixmap.h>

#include "prog_defs.h"


class FileReadSelectDialog: public Gtk::FileSelection {
  bool in_run_loop;
  int standard_size;
  Gtk::Window& parent;
  void selected(bool);
  std::string result;
protected:
  virtual gint delete_event_impl(GdkEventAny*);
public:
  void finish(void);
  std::string run(void);
  FileReadSelectDialog(int standard_size, Gtk::Window& window);
};

class GplDialog;

class GplEditor: public Gtk::Text {
  GplEditor(void) {} // private class
                     // only GplDialog can create an object
  friend class GplDialog;
};


class GplDialog: public Gtk::Window {
public:
  enum Result {rejected, accepted};
private:
  bool in_run_loop;
  Result result;
  GplEditor editbox;
  Gtk::Button accept_button;
  Gtk::Button reject_button;
  Gtk::Label label;
  Gtk::Table table;
  void selected(Result);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  int run(void);
  GplDialog(int standard_size);
};

class InfoDialog: public Gtk::Window {
  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Pixmap* pixmap_p;
  Gtk::Window& parent;
  void selected(void);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  enum InfoType {information, warning, critical};
  void run(void);
  InfoDialog(const char* text, const char* caption, int standard_size, InfoType info_type, Gtk::Window&);
  ~InfoDialog(void);
};

class PromptDialog: public Gtk::Window {
  bool in_run_loop;
  Gtk::Button accept_button;
  Gtk::Button reject_button;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Window& parent;
  void selected(bool);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  SigC::Signal0<void> accepted;
  SigC::Signal0<void> rejected;
  void run(void);
  PromptDialog(const char* text, const char* caption, int standard_size, Gtk::Window& window, const char* accept_name = "OK", const char* reject_name = "Cancel");
};

class HelpEditor: public Gtk::Text {
private:
  HelpEditor(void) {} // private class
                      // only HelpDialog can create an object
  friend class HelpDialog;
};

class HelpDialog: public Gtk::Window {
  HelpEditor editbox;
  Gtk::Button cancel_button;
  Gtk::Table table;
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  void kill_dialog(void);
  HelpDialog(const int size);
};

#endif
