/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SETTINGS_H
#define SETTINGS_H

#include "prog_defs.h"

#include <unistd.h>

#include <string>

#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/notebook.h>
#include <gtkmm/entry.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/box.h>
#include <gtkmm/frame.h>
#include <gtkmm/tooltips.h>
#include <gtkmm/alignment.h>
#include <glibmm/convert.h>

#include "settings_help.h"

class IdentityTable: public  Gtk::Alignment {
  IdentityMessages help_messages;
  Gtk::Table table;
  Gtk::Label name_label;
  Gtk::Label number_label;
  Gtk::Alignment name_label_alignment;
  Gtk::Alignment number_label_alignment;
  Gtk::Entry name_entry;
  Gtk::Entry number_entry;
  Gtk::Button name_help_button;
  Gtk::Button number_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_name(void) const {return name_entry.get_text();}
  Glib::ustring get_number(void) const {return number_entry.get_text();}
  void set_name(const Glib::ustring& name) {name_entry.set_text(name);}
  void set_number(const Glib::ustring& number) {number_entry.set_text(number);}
  void clear(void);
  IdentityTable(const int);
};

class ModemTable: public  Gtk::Alignment {
  ModemMessages help_messages;
  Gtk::Table table;
  Gtk::Label device_label;
  Gtk::Label lock_label;
  Gtk::Label capabilities_label;
  Gtk::Label rings_label;
  Gtk::Label class_label;
  Gtk::Label dialmode_label;
  Gtk::Alignment device_label_alignment;
  Gtk::Alignment lock_label_alignment;
  Gtk::Alignment capabilities_label_alignment;
  Gtk::Alignment rings_label_alignment;
  Gtk::Alignment class_label_alignment;
  Gtk::Alignment dialmode_label_alignment;
  Gtk::Entry device_entry;
  Gtk::Entry lock_entry;
  Gtk::Entry capabilities_entry;
  Gtk::Entry rings_entry;
  Gtk::RadioButton auto_button;
  Gtk::RadioButton class1_button;
  Gtk::RadioButton class2_button;
  Gtk::RadioButton class20_button;
  Gtk::RadioButton tone_button;
  Gtk::RadioButton pulse_button;
  Gtk::HBox class_box;
  Gtk::HBox dialmode_box;
  Gtk::Alignment class_box_alignment;
  Gtk::Alignment dialmode_box_alignment;
  Gtk::Frame class_frame;
  Gtk::Frame dialmode_frame;
  Gtk::Button device_help_button;
  Gtk::Button lock_help_button;
  Gtk::Button class_help_button;
  Gtk::Button dialmode_help_button;
  Gtk::Button capabilities_help_button;
  Gtk::Button rings_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_device(void) const {return device_entry.get_text();}
  Glib::ustring get_lock(void) const {return lock_entry.get_text();}
  Glib::ustring get_class(void) const ;
  Glib::ustring get_dialmode(void) const;
  Glib::ustring get_capabilities(void) const {return capabilities_entry.get_text();}
  Glib::ustring get_rings(void) const {return rings_entry.get_text();}
  void set_device(const Glib::ustring& device) {device_entry.set_text(device);}
  void set_lock(const Glib::ustring& lock) {lock_entry.set_text(lock);}
  void set_class(const Glib::ustring& class_string);
  void set_dialmode(const Glib::ustring& dialmode);
  void set_capabilities(const Glib::ustring& capabilities) {capabilities_entry.set_text(capabilities);}
  void set_rings(const Glib::ustring& rings) {rings_entry.set_text(rings);}
  void clear(void);
  ModemTable(const int);
};

class ParmsTable: public  Gtk::Alignment {
  ParmsMessages help_messages;
  Gtk::Table table;
  Gtk::Label init_label;
  Gtk::Label reset_label;
  Gtk::Label parms_label;
  Gtk::Alignment init_label_alignment;
  Gtk::Alignment reset_label_alignment;
  Gtk::Alignment parms_label_alignment;
  Gtk::Entry init_entry;
  Gtk::Entry reset_entry;
  Gtk::Entry parms_entry;
  Gtk::Button init_help_button;
  Gtk::Button reset_help_button;
  Gtk::Button parms_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_init(void) const {return init_entry.get_text();}
  Glib::ustring get_reset(void) const {return reset_entry.get_text();}
  Glib::ustring get_parms(void) const {return parms_entry.get_text();}
  void set_init(const Glib::ustring& init) {init_entry.set_text(init);}
  void set_reset(const Glib::ustring& reset) {reset_entry.set_text(reset);}
  void set_parms(const Glib::ustring& parms) {parms_entry.set_text(parms);}
  void clear(void);
  ParmsTable(const int);
};

class PrintTable: public  Gtk::Alignment {
  PrintMessages help_messages;
  Gtk::Table table;
  Gtk::Label command_label;
  Gtk::Label shrink_label;
  Gtk::Label popup_label;
  Gtk::Alignment command_label_alignment;
  Gtk::Alignment shrink_label_alignment;
  Gtk::Alignment popup_label_alignment;
  Gtk::Entry command_entry;
  Gtk::Entry shrink_entry;
  Gtk::CheckButton popup_button;
  Gtk::Alignment popup_button_alignment;
  Gtk::Button command_help_button;
  Gtk::Button shrink_help_button;
  Gtk::Button popup_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_command(void) const {return command_entry.get_text();}
  Glib::ustring get_shrink(void) const {return shrink_entry.get_text();}
  Glib::ustring get_popup(void) const;
  void set_command(const Glib::ustring& command) {command_entry.set_text(command);}
  void set_shrink(const Glib::ustring& shrink) {shrink_entry.set_text(shrink);}
  void set_popup(const Glib::ustring& popup_string);
  void clear(void);
  PrintTable(const int);
};

class ViewTable: public  Gtk::Alignment {
  ViewMessages help_messages;
  Gtk::Table table;
  Gtk::Label ps_view_command_label;
  Gtk::Entry ps_view_command_entry;
  Gtk::Button ps_view_command_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_ps_view_command(void) const {return ps_view_command_entry.get_text();}
  void set_ps_view_command(const Glib::ustring& command) {ps_view_command_entry.set_text(command);}
  void clear(void);
  ViewTable(const int);
};

class SockTable: public  Gtk::Alignment {
  SockMessages help_messages;
  Gtk::Table table;
  Gtk::Label run_server_label;
  Gtk::Label popup_label;
  Gtk::Label port_label;
  Gtk::Label client_address_label;
  Gtk::Alignment run_server_label_alignment;
  Gtk::Alignment popup_label_alignment;
  Gtk::Alignment port_label_alignment;
  Gtk::Alignment client_address_label_alignment;
  Gtk::CheckButton run_server_button;
  Gtk::CheckButton popup_button;
  Gtk::RadioButton localhost_button;
  Gtk::RadioButton other_address_button;
  Gtk::Entry port_entry;
  Gtk::Entry other_addresses_entry;
  Gtk::HBox client_address_box;
  Gtk::Alignment run_server_button_alignment;
  Gtk::Alignment popup_button_alignment;
  Gtk::Alignment client_address_box_alignment;
  Gtk::VBox client_address_frame_box;
  Gtk::Frame client_address_frame;
  Gtk::Button run_server_help_button;
  Gtk::Button popup_help_button;
  Gtk::Button port_help_button;
  Gtk::Button client_address_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
  void other_address_button_toggled_slot(void);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_run_server(void) const ;
  Glib::ustring get_popup(void) const;
  Glib::ustring get_port(void) const {return port_entry.get_text();}
  Glib::ustring get_if_other_address(void) const;
  Glib::ustring get_other_addresses(void) const {return other_addresses_entry.get_text();}
  void set_run_server(const Glib::ustring& run_server_string);
  void set_popup(const Glib::ustring& popup_string);
  void set_port(const Glib::ustring& port_string) {port_entry.set_text(port_string);}
  void set_if_other_address(const Glib::ustring& if_other_address_string);
  void set_other_addresses(const Glib::ustring& other_addresses_string)
                            {other_addresses_entry.set_text(other_addresses_string);}
  void clear(void);
  SockTable(const int);
};

class ReceiveTable: public  Gtk::Alignment {
  ReceiveMessages help_messages;
  Gtk::Table table;
  Gtk::Label popup_label;
  Gtk::Label exec_label;
  Gtk::Alignment popup_label_alignment;
  Gtk::Alignment exec_label_alignment;
  Gtk::CheckButton popup_button;
  Gtk::CheckButton exec_button;
  Gtk::Entry prog_entry;
  Gtk::Alignment popup_button_alignment;
  Gtk::Alignment exec_button_alignment;
  Gtk::VBox exec_frame_box;
  Gtk::Frame exec_frame;
  Gtk::Button popup_help_button;
  Gtk::Button exec_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
  void exec_button_toggled_slot(void);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_popup(void) const;
  Glib::ustring get_exec(void) const;
  Glib::ustring get_prog(void) const {return prog_entry.get_text();}
  void set_popup(const Glib::ustring& popup_string);
  void set_exec(const Glib::ustring& exec_string);
  void set_prog(const Glib::ustring& prog_string) {prog_entry.set_text(prog_string);}
  void clear(void);
  ReceiveTable(const int);
};

class LoggingTable: public  Gtk::Alignment {
  LoggingMessages help_messages;
  Gtk::Table table;
  Gtk::Label logfile_label;
  Gtk::Entry logfile_entry;
  Gtk::Button logfile_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_logfile(void) const {return logfile_entry.get_text();}
  void set_logfile(const Glib::ustring& logfile) {logfile_entry.set_text(logfile);}
  void clear(void);
  LoggingTable(const int);
};

class PageTable: public  Gtk::Alignment {
  PageMessages help_messages;
  Gtk::Table table;
  Gtk::Label page_label;
  Gtk::Label res_label;
  Gtk::Alignment page_label_alignment;
  Gtk::Alignment res_label_alignment;
  Gtk::RadioButton a4_button;
  Gtk::RadioButton letter_button;
  Gtk::RadioButton legal_button;
  Gtk::RadioButton standard_button;
  Gtk::RadioButton fine_button;
  Gtk::HBox page_box;
  Gtk::HBox res_box;
  Gtk::Alignment page_box_alignment;
  Gtk::Alignment res_box_alignment;
  Gtk::Frame page_frame;
  Gtk::Frame res_frame;
  Gtk::Button page_help_button;
  Gtk::Button res_help_button;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  sigc::signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_page(void) const;
  Glib::ustring get_res(void) const;
  void set_page(const Glib::ustring& page);
  void set_res(const Glib::ustring& res);
  void clear(void);
  PageTable(const int);
};

class SettingsDialog: public Gtk::Window {

  const int standard_size;
  bool in_exec_loop;
  bool is_home_config;
  std::string rcfile;

  Gtk::Label label;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::Table window_table;
  Gtk::Notebook notebook;
  Gtk::Window& parent;

  IdentityTable identity_table;
  ModemTable modem_table;
  ParmsTable parms_table;
  PrintTable print_table;
  ViewTable view_table;
  SockTable sock_table;
  ReceiveTable receive_table;
  LoggingTable logging_table;
  PageTable page_table;

  void selected(bool);
  void read_config(bool search_localfile = true);
  bool write_config(void);
  bool get_prog_parm(const char*, std::string&, Glib::ustring&, Glib::ustring(*)(const std::string&));
  bool get_prog_parm(const char* name, std::string& line, Glib::ustring& result)
    {return get_prog_parm(name, line, result, Glib::locale_to_utf8);}
  bool find_prog_parm(const char*, const std::string&);
  bool get_rcfile_path(bool search_localfile = true);
  void get_reset_settings_prompt(void);
  void get_reset_settings(void);
  void show_help(const Glib::ustring& message, const Glib::ustring& caption);
  void strip(Glib::ustring&);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  // this signal can be used to indicate that settings have changed
  // it is emitted after this dialog has rewritten the ~/.efax-gtkrc
  // and has called configure_prog() and passes the messages
  // returned by configure_prog() together with a bool indicating
  // whether the socket server should be running
  sigc::signal1<void, const Glib::ustring&> accepted;
  void exec(void);
  SettingsDialog(const int standard_size, Gtk::Window& window, bool skip_old_settings = false);
};

#endif
