/* soccon.c - function to open a connection to a socket
 * $Id: soccon.c,v 1.2 2002/03/06 02:25:18 mgorse Exp $
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

int sockconnect(const char *fname)
{
  struct sockaddr_un addr;
  int sock;

  if (!fname) return -1;
  sock = socket(AF_UNIX, SOCK_STREAM, 0);
  if (sock == -1)
  {
    perror("socket");
    return -1;
  }
  addr.sun_family = AF_UNIX;
  strncpy(addr.sun_path, fname, sizeof(addr.sun_path));
  if (connect(sock, (struct sockaddr *)&addr, sizeof(addr)) == -1)
  {
    close(sock);
    return -1;
  }
  return sock;
}
