-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkColorsel objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_colorsel_writer.e,v 1.4 2000/07/10 11:31:12 elphick Exp $"

class GTK_COLORSEL_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_COLORSEL"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			policy := widget_tree.get_string_from_field("policy")
		end
			
	policy: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".selection_set_update_policy(" + policy +")")
			add_widget_code(code)
		end

end
