# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core import common
from elisa.core import player

import gtk.gdk, gobject

from pgm.timing import implicit

from twisted.internet import reactor

plugin_registry = common.application.plugin_registry
PigmentView = plugin_registry.get_component_class('pigment:pigment_view')

class ElisaView(PigmentView):

    supported_controllers = ('raval:elisa_controller',)
    bindings = (('player', 'player'),
                ('manager', 'manager'),
                ('show_popup', 'show_popup'),
                ('focused_window', 'focused_window'))

    def __init__(self):
        super(ElisaView, self).__init__()
        path = 'raval:focus_transition'
        self._player_in = plugin_registry.create_component(path)
        path = 'raval:unfocus_transition'
        self._player_out = plugin_registry.create_component(path)
        self.context_handle.opacity = 0

    def frontend_changed(self, previous_frontend, new_frontend):
        super(ElisaView, self).frontend_changed(previous_frontend, new_frontend)
        if new_frontend == None:
            return
 
        # FIXME: is this the right place to do that?
        icon_path = self.frontend.theme.get_media("elisa_icon")
        try:
            icon = gtk.gdk.pixbuf_new_from_file(icon_path)
        except gobject.GError:
            self.warning("Icon file not found: %r", icon_path)
        else:
            self.frontend.context.viewport_handle.icon = icon

        # animated wrapper for the top level pgm.Group of Elisa:
        # ElisaView.context_handle
        self.animated = implicit.AnimatedObject(self.context_handle, ('opacity',))
        reactor.callLater(1.0, self._fade_in)

    def _fade_in(self):
        self.animated.setup_next_animations(duration=2000,
                                            transformation=implicit.ACCELERATE)
        self.animated.opacity = 255

    def controller__set(self, controller):
        if controller != None:
            # FIXME: slideshow view needs to be created before the bound
            # attribute focused_window
            if self.frontend.context.touchscreen:
                self._create_child_view("slideshow",
                                        "slideshow:translating_slideshow_view")
            else:
                self._create_child_view("slideshow",
                                        "slideshow:fading_slideshow_view")
            self.slideshow.controller = controller.slideshow

            # create the slideshow
            self._create_child_view("popup", "raval:popup_view")
            self.popup.controller = controller.popup

            # create the player
            self._create_child_view("player", "player:player_view")
            self.player.controller = controller.player

        super(ElisaView, self).controller__set(controller)

    def show_popup__set(self, value):
        self.popup.visible = value 

    def focused_window__set(self, focused_window):
        self.debug("new focused window: %s" % focused_window)
        players = ('player', 'slideshow')

        # FIXME: hackish ways to find out faded views
        slideshow_faded = float(self.slideshow.context_handle.opacity) < 255.0
        player_faded = float(self.player.context_handle.opacity) < 255.0
        self.debug("player_faded: %r, slideshow_faded: %r",
                   player_faded, slideshow_faded)
        
        try:
            if self._focused_window == focused_window:
                return
            
            old_view = getattr(self, self._focused_window)
        except AttributeError, e:
            # there was no previously focused window
            pass
        else:
            if self._focused_window in players:
                self._player_out.apply(old_view)
                path = 'player_out'
            else:
                if slideshow_faded and focused_window != 'slideshow':
                    path = 'pigment:fadeout_transition'
                    fadeout = plugin_registry.create_component(path)
                    view = self.slideshow
                    fadeout.apply(view)
                    self.debug("Faded out slideshow")
                if player_faded and focused_window != 'player':
                    path = 'pigment:fadeout_transition'
                    fadeout = plugin_registry.create_component(path)
                    view = self.player
                    fadeout.apply(view)
                    self.debug("Faded out player")
                    
                path = 'pigment:fadeout_transition'
                fadeout = plugin_registry.create_component(path)
                fadeout.apply(old_view)
            self.debug("Fade out applied to %r : %r", old_view, path)
            
        new_view = getattr(self, focused_window)

        if focused_window in players:
            self._player_in.apply(new_view)
            path = 'player_in'
        else:
            path = 'pigment:fadein_transition'
            fadein = plugin_registry.create_component(path)
            fadein.apply(new_view)
            
        self.debug("Fade in applied to %r : %r", new_view, path)
        
        self._focused_window = focused_window

    def canvas_resized(self, new_size):
        self.context_handle.regenerate()
