/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.Vector;

public class SequenceIdMatcher {
    private Hashtable names = new Hashtable();

    public SequenceIdMatcher(SequenceI[] seqs) {
        for (int i = 0; i < seqs.length; ++i) {
            this.names.put(new SeqIdName(seqs[i].getName()), seqs[i]);
        }
    }

    private SequenceI pickbestMatch(SeqIdName candName, Vector matches) {
        SequenceI match = null;
        if (candName == null || matches == null || matches.size() == 0) {
            return null;
        }
        match = (SequenceI)matches.elementAt(0);
        matches.removeElementAt(0);
        this.names.put(new SeqIdName(match.getName()), match);
        int matchlen = match.getName().length();
        int namlen = candName.id.length();
        while (matches.size() > 0) {
            SequenceI cand = (SequenceI)matches.elementAt(0);
            this.names.put(new SeqIdName(cand.getName()), cand);
            int candlen = cand.getName().length();
            if (Math.abs(matchlen - namlen) <= Math.abs(candlen - namlen) || candlen <= matchlen) continue;
            match = cand;
            matchlen = candlen;
        }
        return match;
    }

    SequenceI findIdMatch(SequenceI seq) {
        SeqIdName nam = new SeqIdName(seq.getName());
        return this.findIdMatch(nam);
    }

    SequenceI findIdMatch(String seqnam) {
        SeqIdName nam = new SeqIdName(seqnam);
        return this.findIdMatch(nam);
    }

    SequenceI[] findIdMatch(SequenceI[] seqs) {
        SequenceI[] namedseqs = null;
        int i = 0;
        if (seqs.length > 0) {
            namedseqs = new SequenceI[seqs.length];
            do {
                SeqIdName nam;
                namedseqs[i] = this.names.containsKey(nam = new SeqIdName(seqs[i].getName())) ? this.findIdMatch(nam) : null;
            } while (++i < seqs.length);
        }
        return namedseqs;
    }

    private SequenceI findIdMatch(SeqIdName nam) {
        Vector matches = new Vector();
        while (this.names.containsKey(nam)) {
            matches.addElement(this.names.remove(nam));
        }
        return this.pickbestMatch(nam, matches);
    }

    private class SeqIdName {
        String id;
        private String WORD_SEP = "~. |#\\/<>!\"\ufffd$%^*)}[@',?_";

        SeqIdName(String s) {
            this.id = s != null ? new String(s) : "";
        }

        public int hashCode() {
            return this.id.length() >= 4 ? this.id.substring(0, 4).hashCode() : this.id.hashCode();
        }

        public boolean equals(Object s) {
            if (s instanceof SeqIdName) {
                return this.equals((SeqIdName)s);
            }
            if (s instanceof String) {
                return this.equals((String)s);
            }
            return false;
        }

        public boolean equals(SeqIdName s) {
            if (this.id.length() > s.id.length()) {
                return this.id.startsWith(s.id) ? this.WORD_SEP.indexOf(this.id.charAt(s.id.length())) > -1 : false;
            }
            return s.id.startsWith(this.id) ? (s.id.equals(this.id) ? true : this.WORD_SEP.indexOf(s.id.charAt(this.id.length())) > -1) : false;
        }

        public boolean equals(String s) {
            if (this.id.length() > s.length()) {
                return this.id.startsWith(s) ? this.WORD_SEP.indexOf(this.id.charAt(s.length())) > -1 : false;
            }
            return s.startsWith(this.id) ? (s.equals(this.id) ? true : this.WORD_SEP.indexOf(s.charAt(this.id.length())) > -1) : false;
        }
    }
}

