/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

/* These are here so MIN/MAX don't get redefined */
#include "util.h"
#include <glib.h>


/* **************************************** */

unsigned int
millitime (void)
{
  struct timeval tv;
  
  gettimeofday (&tv, NULL);

  return ((tv.tv_sec * 1000) + (tv.tv_usec / 1000));
}



/* **************************************** */

void
rand_timer_set (guint* timer, guint time, guint delay, 
		  GSourceFunc func, gpointer user_data)
{
  g_return_if_fail (timer);
  g_return_if_fail (func);

  if (!*timer)
    {
      if (delay)
	time += rand() % delay;

      *timer = g_timeout_add (time, func, user_data);
    }
}


void
rand_timer_cancel (guint* timer)
{
  g_return_if_fail (timer);

  if (*timer)
    {
      g_source_remove(*timer);
      *timer = 0;
    }
}


void
rand_timer_reset (guint* timer, guint time, guint delay, 
		    GSourceFunc func, gpointer user_data)
{
  rand_timer_cancel (timer);
  rand_timer_set (timer, time, delay, func, user_data);
}


/* **************************************** */

size_t
strnlen (const char* s, size_t len)
{
  size_t l = 0;
  const char* end = s + len;

  while (s < end && *s) 
    { 
      ++s; 
      ++l;
    }

  return l;
}

