/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>

#define IA_CONT 00001

#ifndef CRAY
#ifdef FORTRAN_NO_UNDERSCORE
#define MY_IALLOC my_ialloc 
#else
#define MY_IALLOC my_ialloc_
#endif
#endif

void MY_IALLOC( FILE ** kunit, long * isize, long * kret)
{
#ifdef CRAY
int fdesc;
int status;
#endif

    *kret = 0;
#ifdef CRAY
    fdesc = fileno( *kunit);
    status = ialloc( fdesc, *isize, IA_CONT, 0);
    if ( status == -1 ) *kret = 1;
#endif
    return;

}
