/***************************************************************************
                          exportdlg.h  -  description
                             -------------------
    begin                : Fri Nov 15 2002
    copyright            : (C) 2002 by 
    email                : mmdigitizer@earthlink.net
    $Log: exportdlg.h,v $
    Revision 1.3  2005/03/20 01:47:05  markmitch
    After KDevelop 3 restructuring

    Revision 1.7  2004/09/27 04:52:26  markmitch
    KDevelop does not allow renaming source directory to src

    Revision 1.5  2003/12/29 06:55:10  markmitch
    Cvs log cleanup. Color chooser


 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EXPORTDLG_H
#define EXPORTDLG_H

#include <qdialog.h>
#include <qstring.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qbuttongroup.h>

#include "digitdef.h"

class PointSets;

// this dialog box edits the export settings
class ExportDlg : public QDialog
{
  Q_OBJECT
  
  public: 

    ExportDlg(QString title, PointSets* pointSets, const CoordSettings* coord,
      const GridMeshSettings* grid, ExportSettings* xport);
    ~ExportDlg();

  public slots:

    void slotIncluded(QListBoxItem* item);
    void slotExcluded(QListBoxItem* item);
    void slotInclude(void);
    void slotExclude(void);
    void slotXAllCurves(bool toggle);
    void slotXFirstCurve(bool toggle);
    void slotXGridLines(bool toggle);
    void slotXYAllCurves(bool toggle);
    void slotAllCurvesOnEachLine(bool toggle);
    void slotOneCurveOnEachLine(bool toggle);
    void slotCommas(bool toggle);
    void slotSpaces(bool toggle);
    void slotTabs(bool toggle);
    void slotNone(bool toggle);
    void slotSimple(bool toggle);
    void slotGnuplot(bool toggle);
    void slotWhat(void);

  private:

    PointSets* pointSets;

    // reset included and excluded lists
    void resetLists(void);

    // enable or disable buttons as appropriate
    void toggleActions(void);

    // update preview after modifying a property
    void updatePreview(void);

    QGroupBox* groupCurveSelection;
    QLabel* labelIncluded;
    QLabel* labelExcluded;
    QListBox* listIncluded;
    QListBox* listExcluded;
    QPushButton* buttonInclude;
    QPushButton* buttonExclude;

    QButtonGroup* groupPointsSelection;
    QRadioButton* buttonXAllCurves;
    QRadioButton* buttonXFirstCurve;
    QRadioButton* buttonXGridLines;
    QRadioButton* buttonXYAllCurves;

    QButtonGroup* groupLayout;
    QRadioButton* buttonAllCurvesOnEachLine;
    QRadioButton* buttonOneCurveOnEachLine;

    QButtonGroup* groupDelimiters;
    QRadioButton* buttonCommas;
    QRadioButton* buttonSpaces;
    QRadioButton* buttonTabs;

    QButtonGroup* groupHeader;
    QRadioButton* buttonNone;
    QRadioButton* buttonSimple;
    QRadioButton* buttonGnuplot;

    // immediately update the preview screen after each setting change, so user can
    // see the effects. if it turns out the user is blocked for an unacceptably long
    // time, then the update calculations should have processEvents calls inserted. if
    // another setting change occurs before the preview update finishes, a new
    // preview update can be started
    QLabel* labelPreview;
    QListBox* listPreview;

    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    QPushButton* buttonWhat;

    const CoordSettings* coord;
    const GridMeshSettings* grid;
    ExportSettings* xport;
};

#endif
