#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"



/*--element

Element Name: <[vh]pane>

created a resizeable paned area.

%widget%

*/

static void
rendgtk_pane_parenter (ENode * parent_node, ENode * child_node)
{
    GtkWidget *pane;
    GtkWidget *widget;
    gint loc;

    pane = enode_get_kv (parent_node, "top-widget");
    widget = enode_get_kv (child_node, "top-widget");
    if (!pane || !widget)
	return;

    /* Find the location of child in the xml. */
    loc = g_slist_index (parent_node->children, child_node);

    if (0 == loc) {
	gtk_paned_add1 (GTK_PANED (pane), widget);
    } else if (1 == loc) {
	gtk_paned_add2 (GTK_PANED (pane), widget);
    } else {
	g_warning ("Unfortunately, GtkPane's can only have two children.");
    }
}

static void
rendgtk_pane_render (ENode * node)
{
    GtkWidget *pane;		/* The new pane. */

    if (ebuf_equal_str (node->element, "vpane"))
	pane = gtk_vpaned_new ();
    else
	pane = gtk_hpaned_new ();

    enode_set_kv (node, "top-widget", pane);
    enode_set_kv (node, "buttom-widget", pane);

    enode_attribs_sync (node);

    rendgtk_show_cond (node, pane);
}

void
pane_renderer_register (void)
{
    Element *element;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_pane_render;
    element->destroy_func = NULL;
    element->parent_func = rendgtk_pane_parenter;
    element->tag = "vpane";
    element->description = "Create a new vertical pane.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_PANED);

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_pane_render;
    element->destroy_func = NULL;
    element->parent_func = rendgtk_pane_parenter;
    element->tag = "hpane";
    element->description = "Create a new horizontal pane.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_PANED);
}
