<object default-lang="perl">
  <window title="csink listen test" ondelete="my_exit" border="5">
    <csink name="listener" 
     local-port="8081"
     onnewdata="on_new_data" 
     onclose="listener_on_close"
     onconnect="on_connect"
     onerror="on_error"/>

    <csink-ssl name="listener-ssl" 
      local-port="8082"
      onnewdata="on_new_data" 
      onclose="listener_on_close"
      onconnect="on_connect"
      onerror="on_error"
      certfile="/net/home/jim/projects/entity/t/server.pem"
      certdir="/net/home/jim/projects/entity/t/"
      />

    <button label="Is it still there?"/>

    <label linewrap="true" 
     text="Try telnetting to localhost 8081 to test, or localhost 8082 for SSL connections."/>
    <label name="conncount" text="Number of Connections: 0"/>

    <frame title="Options">
      <checkbox name="do_echo" value="TRUE" ontoggle="toggle_echo">
        <label text="Echo incoming lines?"/>
      </checkbox>

      <checkbox name="do_proc" value="FALSE" ontoggle="toggle_proc">
        <label text="Do heavy processing (increase load)?"/>
      </checkbox>

      <checkbox name="do_print" value="FALSE" ontoggle="toggle_print">
        <label text="Print incoming data to console?"/>
      </checkbox>

    </frame>

    <scrollwindow expand="true">
      <ctree name="transactions" cols="2" onbuttonpress="popup_menu">
        <ctree-column title="Connection to .." width="100"/>
	<ctree-column title="Last message" width="200"/>
      </ctree>
    </scrollwindow>
  </window>

  <popupmenu name="connlist_context">
    <menuitem onselect="menu_kill_connection" label="Disconnect"/>
    <menuitem onselect="menu_open_talk_window" label="Talk"/>
  </popupmenu>

  <norender>
    <talkwindow name="template">
      <window name="talk-%sink%" associate_sink="%sink%" title="Talking to %who%"
       ondelete="talkwindow_delete"><vpane expand="true" fill="true">
        <scrollwindow>
          <text name="receive" width="300" height="150"
           expand="true" fill="true" editable="false"/>
        </scrollwindow>
        <scrollwindow>
          <text name="send" width="300" height="150"
          expand="true" fill="true" onkeypress="talkwindow_send"/>
        </scrollwindow>
        </vpane></window>
    </talkwindow>
  </norender>
  
<?perl
$conncount = 0;
$do_echo = 1;
$do_proc = 0;
$do_print = 0;

sub on_connect
{
  my $node = shift;


  my $listen_sink = $node->parent();
  my $sinkname = $listen_sink->attrib("name");
  if ($sinkname eq "listener")
    {
      print "accepted inet connection\n";
    }
  elsif ($sinkname eq "listener-ssl")
    {
      print "accepted ssl connection\n";
    }
  else 
    {
      print "accepted connection from an unknown sink??!?\n";
      print "sinkname was $sinkname\n";
    }
  
  $node->attrib("_write" => "hello there!\n");
  $node->attrib("onclose" => "on_close");

  my $src_addr = $node->attrib("__remote-ip");

  # add it to the list of connections
  my $ctree = enode("ctree.transactions");
  my $row = $ctree->new_child("ctree-row");
  $row->attrib("associate_sink" => $node->basename());
  my $c1 = $row->new_child("ctree-cell");
  $c1->attrib("text" => $node->attrib("remote-host")."(".
	      $node->attrib("__remote-ip").")");
  if ($sinkname eq "listener-ssl")
    {
      $c1->attrib("image" => "ssl.xpm");
    }
  my $c2 = $row->new_child("ctree-cell");
  $c2->attrib("text" => "-none-");

  # update the count label
  $conncount += 1;
  enode("label.conncount")->attrib("text" => "Number of Connections: $conncount");

  print "connected from $src_addr\n";
}
  
sub on_new_data
  {
    my $node = shift;
    my $data = shift;
    my $length = shift;

    # reflect this in the list
    my  $id = $node->basename();
    foreach $row (enode("ctree.transactions")->children("ctree-row"))
      {	
	if ($row->attrib("associate_sink") eq $id)
	  {
	    my @children = $row->children("ctree-cell");
	    $children[1]->attrib("text" => $data);
	    last;
	  }
      }
  
    # show it in the talk window, if there
    my $basename = $node->basename();
    my $window=enode("window.talk-$basename");
    if ($window)
      {
	talkwindow_recv ($window, $data, $length);
      }

    # print it out, if printing is on
    if ($do_print)
      {
        print $data;
      }

    # echo it back, if echo is on
    if ($do_echo)
      {
	if ($do_proc)
	  {
	    my $proc_stuff = super_lame_proc($data);
	    $node->attrib("_write" => $proc_stuff);
	  }
	else
	  {
	    $node->attrib("_write" => $data);
	  }
      }
  }  

sub listener_on_close
  {
    my $node = shift;
    print "listener closing down.\n";
  }

sub on_close
  {
    my $node = shift;

    my $src_addr = $node->attrib("__remote-ip");

    # remove it from the list of connections
    $id = $node->basename();
    my $ctree = enode("ctree.transactions");

    if (not $ctree)
      {
	# if we're shutting down.
	print "goodbye from $src_addr!\n";
	return;
      }

    my @rows = $ctree->children("ctree-row");
    my $row;
    my $marked_for_death;
    foreach $row (@rows)
      {
	if ($row->attrib("associate_sink") eq $id)
	  {
	    $marked_for_death = $row;
	    last;
	  }
      }
    if (defined $marked_for_death)
      {
	$marked_for_death->destroy();
      }

    # kill the talk window
    my $window = enode("window.talk-$id");
    if ($window)
      {
	$window->destroy();
      }
  
    # update the count label
    $conncount -= 1;
    enode("label.conncount")->attrib("text" => "Number of Connections: $conncount");

    print "disconnected from $src_addr\n";
  }

sub on_error
  {
    my $node=shift;
    my $err=shift;

    my $name = $node->basename();

    print "we have received an error: (from sink $name):";
    print "$err\n";
  }

sub toggle_echo
  {
    $do_echo = 1 - $do_echo;
  }

sub toggle_proc
  {
    $do_proc = 1 - $do_proc;
  }
   
sub toggle_print
  {
     $do_print = 1 - $do_print;
  }

sub popup_menu
  {
    #my $tree=shift;
    #my $row=shift;
    #my $cell=shift;
    #my $button=shift;
    #my $column=shift;

    my $row = shift;
    
    #if($button == 3)
    #{
    $row->attrib("selected" => "true");
    my $menu = enode("popupmenu.connlist_context");
    $menu->attrib("popup" => "true");
    #}
  }

sub menu_kill_connection
  {
    my $node = shift;

    my @selected = enode("ctree.transactions")->children_attrib("selected","true");
    my $len = @selected;
    if ($len == 0)
      {
	return;
      }
    my $selected = @selected[0];

    my $sink_str = $selected->attrib("associate_sink");
    print "closing $sink_str\n";
    my $sink = enode($sink_str);
    $sink->attrib("action"=>"disconnect");
  }


sub menu_open_talk_window
  {
    my $node=shift;
    my @selected = enode("ctree.transactions")->children_attrib("selected","true");
    my $len = @selected;
    if ($len == 0)
      {
	return;
      }
    my $selected = @selected[0];

    my $template = enode("talkwindow.template")->get_child_xml();

    my $sink_str = $selected->attrib("associate_sink");
    my $who_str = enode($sink_str)->attrib("__remote-ip");

    $template =~ s/%who%/$who_str/g;
    $template =~ s/%sink%/$sink_str/g;

    enode("object")->append_xml($template);
  }

sub talkwindow_delete
  {
    my $node=shift;
    $node->destroy();
  }


$talkwindow_line = "";
sub talkwindow_send
  {
    my $node=shift;
    my $key_name=shift;
    my $key_val=shift;

    if ($key_name eq "Return")
      {
	my $window = $node->parent("window");
	my $sinkname = $window->attrib("associate_sink");
	my $sink = enode($sinkname);

	$sink->attrib("_write" => $talkwindow_line."\n");
	$node->append_data("\n");
	$talkwindow_line = "";
      }
    else
      {
	$talkwindow_line .= chr $key_val;
	$node->append_data( chr $key_val);
      }
  }

sub talkwindow_recv
  {
    my $node=shift;
    my $data=shift;
    my $length=shift;

    $node = $node->child("text.receive");
    $node->append_data($data);
  }


$saved = "";
sub super_lame_proc
  {
    my $input = shift;
    my $tmp = "";
    my $tmp2 = "";
    my $count = 0;
    
    $saved = $saved . $input;
    $len = (length ($saved)) > 4000 ? 4000 : length ($saved);
    print "len is $len\n";
    foreach $count (1 .. $len)
      {
	my $chr = chop ($saved);
	print "chr is $chr\n";
	$tmp = $tmp . $chr;
	print "tmp is $tmp\n";
      }    
    
    $input = $tmp;
    $saved = $tmp;

    # add the sum of the previous three letters to each letter
    foreach $index  (3 .. length ($tmp) )
      {
	my @list_of_str = split //, $tmp;	
	my $chr = $list_of_str[$index];
	my $ascii = ord ($chr);
	
	$ascii += ord ($list_of_str[$index-1]);
	$ascii += ord ($list_of_str[$index-2]);
	$ascii += ord ($list_of_str[$index-3]);

	$ascii = $ascii % 255;
	$chr = chr ($ascii);

	$tmp2 = $tmp2 . $chr;
	print "tmp2 is $tmp2\n";
      }

    return $tmp2;
  }

sub my_exit 
  {
    my $node = shift;

    print "\n\nEXITING\n\n\n\n";
    $node->call("entity:exit");
  }


# startup 
$node = enode("csink.listener");
$node->attrib("action" => "listen"); 

$node = enode("csink-ssl.listener-ssl");
$node->attrib("action" => "listen"); 

  
?>
</object>
