/* Baby's role is to bind a .e file to its propper entity * entity server
 * based on its execution class. * * Currently we init the baby main loop
 * and service io * requests.  We use glib's io channels to do all the * io
 * work. * * Baby Entity might someday redirect std[in,out,err]. */

#include <gtk/gtk.h>
#include <xmlparse.h>
#include <stdlib.h>
#include <string.h>

#include "entity.h"


/* Some of this stuff isn't used but i might be some day... */
typedef struct {
    EIOFunc func;		/* Thier callback function. */
    void *data;			/* Thier data for the callback. */
    GIOChannel *chan;		/* The io struct for this watch. */
    gint tag;			/* The watch tag. */
} BabyIO;

gint 
baby_eio_cond_met (GIOChannel * chan, GIOCondition gcond, gpointer data)
{
    EIOCond cond = 0;
    BabyIO *ioptr;
    int fd;

    ioptr = (BabyIO *) data;
    fd = g_io_channel_unix_get_fd (chan);

    /* Init the condition. */
    if (gcond & G_IO_IN || gcond & G_IO_HUP)
	cond = EIO_READ;
    else if (gcond & G_IO_OUT /* All by self. */ )
	cond = EIO_WRITE;
    else if (gcond & G_IO_ERR || gcond & G_IO_NVAL)
	cond = EIO_ERROR;

    if (gcond & G_IO_IN || gcond & G_IO_HUP) {
	cond |= EIO_READ;
    }
    if (gcond & G_IO_OUT) {
	cond |= EIO_WRITE;
    }
    if (gcond & G_IO_ERR || gcond & G_IO_NVAL) {
	cond |= EIO_ERROR;
    }

    /* Pass thru. */
    return ioptr->func (fd, cond, ioptr->data);
}

void *
baby_eio_add (int fd, EIOCond cond, EIOFunc func, void *data)
{
    BabyIO *ioptr;
    GIOCondition gcond = 0;

    ioptr = g_new0 (BabyIO, 1);
    ioptr->func = func;
    ioptr->data = data;

    ioptr->chan = g_io_channel_unix_new (fd);

    if (cond & EIO_READ) {
	gcond |= (G_IO_IN | G_IO_HUP);
    }
    if (cond & EIO_WRITE) {
	gcond |= G_IO_OUT;
    }
    if (cond & EIO_ERROR) {
	gcond |= (G_IO_ERR | G_IO_NVAL);
    }

    /* Connect up the watching function. */
    ioptr->tag = g_io_add_watch (ioptr->chan, gcond, baby_eio_cond_met, ioptr);

    /* Adding the watch inc()s the ref count for us. */
    g_io_channel_unref (ioptr->chan);

    return (void *) ioptr;
}

void
baby_eio_remove (void *tag)
{
    BabyIO *ioptr = (BabyIO *) tag;

    /* g_source_remove decs the channel's refcount, freeing it. */
    g_source_remove (ioptr->tag);

    g_free (ioptr);
}

GMainLoop *baby_main_loop;

void
baby_main (void)
{
    g_main_run (baby_main_loop);
}

void
baby_main_init (void)
{
    baby_main_loop = g_main_new (1);

    mainloop_register ("baby_main", baby_main, baby_eio_add, baby_eio_remove);
}


