#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"

/*--element

Element Name: <fixed>

This creates a container widget that allows you to specify absolute X/Y
coordinates of the widgets placed in it.  Any elements that are children
of a fixed, may use the "x-fixed" and "y-fixed" attributes specifying
an integer value of x/y coordinates (in pixels).

%widget%

*/



static void
rendgtk_fixed_render (ENode * node)
{
    GtkWidget *fixed;

    fixed = gtk_fixed_new ();

    enode_set_kv (node, "top-widget", fixed);
    enode_set_kv (node, "bottom-widget", fixed);

    rendgtk_show_cond (node, fixed);

    /* We may want to enable this in the future, but it should be able to
     * figure out x/y coords for drop. */
    /* rendgtk_dnd_dragtag_target_create (node, widget); */

    enode_attribs_sync (node);
}


static void
rendgtk_fixed_parent (ENode * parent_node, ENode * child_node)
{
    EBuf *value;
    gint x = 0;
    gint y = 0;
    GtkWidget *child;
    GtkWidget *parent;

    child = enode_get_kv (child_node, "top-widget");
    parent = enode_get_kv (parent_node, "bottom-widget");

    if (!child || !parent)
	return;

    value = enode_attrib (child_node, "x-fixed", NULL);
    x = erend_get_integer (value);

    value = enode_attrib (child_node, "y-fixed", NULL);
    y = erend_get_integer (value);

    gtk_fixed_put (GTK_FIXED (parent), child, x, y);
}


void
rendgtk_fixed_child_attr_set (ENode * parent_node, ENode * child_node,
			      EBuf * attr, EBuf * value)
{
    EBuf *xv;
    EBuf *yv;
    gint x,
     y;
    GtkWidget *child_widget;
    GtkWidget *fixed;

    fixed = enode_get_kv (parent_node, "bottom-widget");
    child_widget = enode_get_kv (child_node, "top-widget");

    if (!fixed || !child_widget)
	return;

    EDEBUG (
	    ("fixed-renderer", "child_attr_set for fixed.  attr/val %s/%s",
	     attr, value));

    xv = enode_attrib (child_node, "x-fixed", NULL);
    if (ebuf_not_empty (xv))
	x = erend_get_integer (xv);
    else
	x = -1;

    yv = enode_attrib (child_node, "y-fixed", NULL);
    if (ebuf_not_empty (yv))
	y = erend_get_integer (yv);
    else
	y = -1;

    gtk_fixed_move (GTK_FIXED (fixed), child_widget, x, y);
}



void
fixed_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    /* vailgn */
    element = g_malloc0 (sizeof (Element));
    element->render_func = rendgtk_fixed_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_fixed_parent;
    element->tag = "fixed";
    element->description =
	"A container widget for positioning children at absolute x/y coordinates.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "x-fixed";
    e_attr->description = "Horizontal position of widget in fixed.";
    e_attr->value_desc = "integer";
    e_attr->possible_values = "0,*";
    e_attr->set_child_attr_func = rendgtk_fixed_child_attr_set;
    element_register_child_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "y-fixed";
    e_attr->description = "Vertical position of widget in fixed.";
    e_attr->value_desc = "integer";
    e_attr->possible_values = "0,*";
    e_attr->set_child_attr_func = rendgtk_fixed_child_attr_set;
    element_register_child_attrib (element, e_attr);

    rendgtk_widget_attr_register (element, GTK_TYPE_FIXED);
}
