/***************************************************************************
 *   Copyright (C) 2006, 2007 by Niklas Knutsson                           *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef IMPORT_CSV_DIALOG_H
#define IMPORT_CSV_DIALOG_H

#include <kwizard.h>

class Budget;
class QButtonGroup;
class QLabel;
class QRadioButton;
class QSpinBox;
class KDateEdit;
class EqonomizeValueEdit;
class KLineEdit;
class KComboBox;
class KURLRequester;
class QCheckBox;
struct csv_info;

class ImportCSVDialog : public KWizard {

	Q_OBJECT
	
	protected:

		Budget *budget;

		QLabel *typeDescriptionLabel;
		QButtonGroup *typeGroup, *dateGroup, *valueGroup, *costGroup, *descriptionGroup, *AC1Group, *AC2Group, *commentsGroup;

		KURLRequester *fileEdit;
		QSpinBox *rowEdit;
		KComboBox *delimiterCombo;
		KLineEdit *delimiterEdit;

		QRadioButton *columnDescriptionButton, *valueDescriptionButton;
		QSpinBox *columnDescriptionEdit;
		KLineEdit *valueDescriptionEdit;

		QLabel *valueLabel;
		QRadioButton *columnValueButton, *valueValueButton;
		QSpinBox *columnValueEdit;
		EqonomizeValueEdit *valueValueEdit;

		QLabel *costLabel;
		QRadioButton *columnCostButton, *valueCostButton;
		QSpinBox *columnCostEdit;
		EqonomizeValueEdit *valueCostEdit;

		QRadioButton *columnDateButton, *valueDateButton;
		QSpinBox *columnDateEdit;
		KDateEdit *valueDateEdit;

		QLabel *AC1Label;
		QRadioButton *columnAC1Button, *valueAC1Button;
		QSpinBox *columnAC1Edit;
		KComboBox *valueAC1Edit;

		QLabel *AC2Label;
		QRadioButton *columnAC2Button, *valueAC2Button;
		QSpinBox *columnAC2Edit;
		KComboBox *valueAC2Edit;

		QRadioButton *columnCommentsButton, *valueCommentsButton;
		QSpinBox *columnCommentsEdit;
		KLineEdit *valueCommentsEdit;

		QCheckBox *createMissingButton;

		bool import(bool test, csv_info *ci);
		
	public:
		
		ImportCSVDialog(Budget *budg, QWidget *parent);
		~ImportCSVDialog();		

	protected slots:

		void next();
		void typeChanged(int);
		void delimiterChanged(int);
		void accept();
		
};

#endif
