# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Qt configuration page.
"""

from PyQt4.QtCore import QDir, pyqtSignature
from PyQt4.QtGui import QFileDialog

from KdeQt import KQFileDialog

from E4Gui.E4Completers import E4DirCompleter

from ConfigurationPageBase import ConfigurationPageBase
from Ui_QtPage import Ui_QtPage

import Preferences
import Utilities

class QtPage(ConfigurationPageBase, Ui_QtPage):
    """
    Class implementing the Qt configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("QtPage")
        
        self.qtCompleter = E4DirCompleter(self.qtEdit)
        self.qt4TransCompleter = E4DirCompleter(self.qt4TransEdit)
        
        # set initial values
        self.disableQt3CheckBox.setChecked(Preferences.getQt("DisableQt3"))
        self.qtEdit.setText(Preferences.getQt("QtDir"))
        self.exportQtDirCheckBox.setChecked(Preferences.getQt("ExportQtDir"))
        self.qt4TransEdit.setText(Preferences.getQt("Qt4TranslationsDir"))
        self.qt3PrefixEdit.setText(Preferences.getQt("QtToolsPrefix3"))
        self.qt3PostfixEdit.setText(Preferences.getQt("QtToolsPostfix3"))
        self.__updateQt3Sample()
        self.qt4PrefixEdit.setText(Preferences.getQt("QtToolsPrefix4"))
        self.qt4PostfixEdit.setText(Preferences.getQt("QtToolsPostfix4"))
        self.__updateQt4Sample()
        
    def save(self):
        """
        Public slot to save the Qt configuration.
        """
        Preferences.setQt("DisableQt3", 
            int(self.disableQt3CheckBox.isChecked()))
        Preferences.setQt("QtDir", self.qtEdit.text())
        Preferences.setQt("ExportQtDir", 
            int(self.exportQtDirCheckBox.isChecked()))
        Preferences.setQt("Qt4TranslationsDir", self.qt4TransEdit.text())
        Preferences.setQt("QtToolsPrefix3", self.qt3PrefixEdit.text())
        Preferences.setQt("QtToolsPostfix3", self.qt3PostfixEdit.text())
        Preferences.setQt("QtToolsPrefix4", self.qt4PrefixEdit.text())
        Preferences.setQt("QtToolsPostfix4", self.qt4PostfixEdit.text())
        
    @pyqtSignature("")
    def on_qtButton_clicked(self):
        """
        Private slot to handle the Qt3 directory selection.
        """
        dir = KQFileDialog.getExistingDirectory(\
            self,
            self.trUtf8("Select Qt3 Directory"),
            self.qtEdit.text(),
            QFileDialog.Options(QFileDialog.ShowDirsOnly))
            
        if not dir.isNull():
            self.qtEdit.setText(Utilities.toNativeSeparators(dir))
        
    def on_qtEdit_textChanged(self, dir):
        """
        Private slot to handle a change in the entered Qt3 directory.
        
        @param dir the entered string (QString)
        """
        self.exportQtDirCheckBox.setEnabled(not dir.isEmpty())
        
    @pyqtSignature("")
    def on_qt4TransButton_clicked(self):
        """
        Private slot to handle the Qt4 translations directory selection.
        """
        dir = KQFileDialog.getExistingDirectory(\
            self,
            self.trUtf8("Select Qt4 Translations Directory"),
            self.qt4TransEdit.text(),
            QFileDialog.Options(QFileDialog.ShowDirsOnly))
            
        if not dir.isNull():
            self.qt4TransEdit.setText(Utilities.toNativeSeparators(dir))
        
    def on_qt4Edit_textChanged(self, dir):
        """
        Private slot to handle a change in the entered Qt directory.
        
        @param dir the entered string (QString)
        """
        self.exportQt4DirCheckBox.setEnabled(not dir.isEmpty())
    
    def __updateQt3Sample(self):
        """
        Private slot to update the Qt3 tools sample label.
        """
        self.qt3SampleLabel.setText(self.trUtf8("Sample: %1designer%2")\
            .arg(self.qt3PrefixEdit.text())\
            .arg(self.qt3PostfixEdit.text()))
    
    @pyqtSignature("QString")
    def on_qt3PrefixEdit_textChanged(self, txt):
        """
        Private slot to handle a change in the entered Qt directory.
        
        @param txt the entered string (QString)
        """
        self.__updateQt3Sample()
    
    @pyqtSignature("QString")
    def on_qt3PostfixEdit_textChanged(self, txt):
        """
        Private slot to handle a change in the entered Qt directory.
        
        @param txt the entered string (QString)
        """
        self.__updateQt3Sample()
    
    def __updateQt4Sample(self):
        """
        Private slot to update the Qt4 tools sample label.
        """
        self.qt4SampleLabel.setText(self.trUtf8("Sample: %1designer%2")\
            .arg(self.qt4PrefixEdit.text())\
            .arg(self.qt4PostfixEdit.text()))
    
    @pyqtSignature("QString")
    def on_qt4PrefixEdit_textChanged(self, txt):
        """
        Private slot to handle a change in the entered Qt directory.
        
        @param txt the entered string (QString)
        """
        self.__updateQt4Sample()
    
    @pyqtSignature("QString")
    def on_qt4PostfixEdit_textChanged(self, txt):
        """
        Private slot to handle a change in the entered Qt directory.
        
        @param txt the entered string (QString)
        """
        self.__updateQt4Sample()
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = QtPage()
    return page
