/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#ifndef ESYS_LSMTRIMESHBUILDPARAMSPY_H
#define ESYS_LSMTRIMESHBUILDPARAMSPY_H

/*---------------------------------------------------
 *
 * wrapper classes for TriMesh build parameters
 *
 *--------------------------------------------------*/

//--- project includes ---
#include "Model/BTriMeshIP.h"

namespace esys
{
  namespace lsm
  {
    /*!
      \class MeshTagBuildPrmsPy
      \brief wrapper for MeshTagBuildPrms
    */
    class MeshTagBuildPrmsPy : public MeshTagBuildPrms
    {
    public:
      MeshTagBuildPrmsPy(int, int);
    };

    /*!
      \class MeshGapBuildPrmsPy
      \brief wrapper for MeshGapBuildPrms
    */
    class MeshGapBuildPrmsPy : public MeshGapBuildPrms
    {
    public:
      MeshGapBuildPrmsPy(double);
    };

    void exportMeshBuildPrms();
  }; // namespace lsm
}; // namespace esys

#endif //ESYS_LSMTRIMESHBUILDPARAMSPY_H
