/*
 * libirc
 *
 * Copyright (C) 2000, Rob M. Flynn <rflynn@blueridge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <stdio.h>

/* libirc's main connection structure */

typedef struct _irc_conn
{
	int fd;
	gchar *nick;
	gchar *password;
	gchar *server;
	gint port;
	int status;
	GList *irc_users;
	GString *buff;
} irc_conn;

/* callbacks used in libirc */

extern void (*irc_im_in)( irc_conn * conn, gchar * nick, gchar * message );
extern void (*irc_chat_room_in)( irc_conn * conn, gchar * nick, gchar * channel,
		                          gchar * message );
extern void (*irc_chat_room_join)( irc_conn * conn, gchar * channel, gchar * nick, gchar * host);
extern void (*irc_chat_room_part)( irc_conn * conn, gchar * channel, gchar * nick, gchar * host);
extern void (*irc_chat_room_set_window_title)( irc_conn * conn, gchar * channel, gchar * topic, gchar * nick);
extern void (*irc_user_quit)( irc_conn * conn, gchar * nick );
extern void (*irc_change_user_nick)( irc_conn * conn, gchar * nick, gchar * newnick);
extern void (*irc_action_in)( irc_conn * conn, gchar * nick, gchar * channel,
					  gchar * message );
extern void (*irc_ctcp_version_reply_in)( irc_conn * conn, gchar * nick, gchar * message );
extern void (*irc_ctcp_version_request_in) ( irc_conn * conn, gchar * nick );
extern void (*irc_send_message) ( irc_conn * conn, gchar * target, gchar * message);
extern void (*irc_user_join_channel) ( irc_conn * conn, gchar * target );

/* functions used in libirc */
void irc_callback ( irc_conn *c );
irc_conn * irc_connect( gchar *server, gint port );
irc_conn * irc_signon( irc_conn *c, gchar *nick, gchar *passwd );
void irc_join_chat( irc_conn *c, gchar *channel );
void irc_part_channel ( irc_conn *c, gchar *channel );
void irc_signoff ( irc_conn *c, gchar *message );
void irc_send_privmsg ( irc_conn *c, gchar *target, gchar *message );
void irc_send_action ( irc_conn *c, gchar *target, gchar *message );
void irc_send_ctcp_version_request ( irc_conn *c, gchar * nick );
void irc_chat_room_set_topic ( irc_conn *c, gchar * channel, gchar * topic);
void irc_send_ctcp_version_reply( irc_conn * c, gchar * nick, gchar * name, gchar * version, gchar * environment ); 
