/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * nomodule.c
 * Empty protocol implementation
 */

#include <gtk/gtk.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#if defined( _WIN32 )
typedef unsigned long u_long;
typedef unsigned long ulong;
#endif
#include "service.h"
#include "chat_window.h"
#include "away_window.h"
#include "util.h"
#include "status.h"
#include "globals.h"
#include "dialog.h"
#include "message_parse.h"
#include "chat_room.h"
#include "value_pair.h"
#include "info_window.h"
#include "gtk_eb_html.h"
#include "input_list.h"

/* Can never be online */
/* #include "pixmaps/nomodule_online.xpm" */
#include "pixmaps/nomodule_away.xpm"

#define SERVICE_INFO nomodule_SERVICE_INFO
/* This will end up being an array, one for each protocol we know about */
struct service SERVICE_INFO = { NULL, -1, FALSE, FALSE, FALSE, FALSE, NULL };

struct eb_nomodule_account_data {
	gint status;
        gint logged_in_time;
	gint evil;
};

struct eb_nomodule_local_account_data {
        char password[255];
	int input;
	int keep_alive;
	gint status;
};

enum
{
	NOMODULE_OFFLINE=0
};



/* here is the list of locally stored buddies */


eb_account * eb_nomodule_new_account( gchar * account );
void eb_nomodule_add_user( eb_account * account );
void eb_nomodule_login( eb_local_account * account );
void eb_nomodule_logout( eb_local_account * account );


/*********
 * the following variable is a hack, it if we are changing the selection
 * don't let the corresponding set_current_state get called again
 */



/*   callbacks used by EveryBuddy    */

static gint pixmaps = 0;
static GdkPixmap * eb_nomodule_pixmap[NOMODULE_OFFLINE+1];
static GdkBitmap * eb_nomodule_bitmap[NOMODULE_OFFLINE+1];

void eb_nomodule_init_pixmaps()
{
	gint i = NOMODULE_OFFLINE;
	gchar ** xpm;

	xpm = nomodule_away_xpm;
	eb_nomodule_pixmap[i] = gdk_pixmap_create_from_xpm_d(statuswindow->window,
		&eb_nomodule_bitmap[i], NULL, xpm);
	pixmaps = 1;
}



gboolean eb_nomodule_query_connected(eb_account * account)
{		
	return FALSE;
}

void eb_nomodule_login( eb_local_account * account )
{
	return;							  
}

void eb_nomodule_logout( eb_local_account * account )
{
	return;
}

void eb_nomodule_send_im( eb_local_account * account_from,
				  eb_account * account_to,
				  gchar * message )
{
	return;
}

eb_local_account * eb_nomodule_read_local_config(GList * pairs)
{

	eb_local_account * ela = g_new0(eb_local_account, 1);
	struct eb_nomodule_local_account_data * ala = g_new0(struct eb_nomodule_local_account_data, 1);
	char *ptr=NULL;
	
	eb_debug(DBG_CORE, "eb_nomodule_read_local_config: entering\n");	
	/*you know, eventually error handling should be put in here*/
	ptr = value_pair_get_value(pairs, "SCREEN_NAME");
	if(!ptr) {
		fprintf(stderr, "Error!  Invalid account config no SCREEN_NAME defined!\n");
		exit(1);
	}
	ela->handle=strdup(ptr);
	strncpy(ela->alias, ela->handle, 255);
	ptr = value_pair_get_value(pairs, "PASSWORD");
	if(!ptr) {
		fprintf(stderr, "Warning!  No password specified for handle %s\n", ela->handle);
	}
	else {
		strncpy(ala->password, value_pair_get_value(pairs, "PASSWORD"), 255);
	}
	ela->service_id = SERVICE_INFO.protocol_id;
	ela->protocol_local_account_data = ala;
	ala->status = 0;
	eb_debug(DBG_CORE, "eb_nomodule_read_local_config: leaving\n");

	return ela;
}

GList * eb_nomodule_write_local_config( eb_local_account * account )
{
	GList * list = NULL;
	value_pair * vp;
	struct eb_nomodule_local_account_data * alad = account->protocol_local_account_data; 

	vp = g_new0(value_pair, 1);

	strcpy(vp->key, "SCREEN_NAME");
	strcpy(vp->value, account->handle );

	list = g_list_append( list, vp );

	vp = g_new0(value_pair, 1);

	strcpy(vp->key, "PASSWORD");
	strcpy(vp->value, alad->password);

	list = g_list_append(list, vp);

	return list;
}
			
eb_account * eb_nomodule_read_config( GList * config, struct contact *contact )
{
	eb_account * ea = g_new0(eb_account, 1 );
	struct eb_nomodule_account_data * aad =  g_new0(struct eb_nomodule_account_data,1);
	
	aad->status = 0;

	/*you know, eventually error handling should be put in here*/
	strncpy(ea->handle, value_pair_get_value( config, "NAME"), 255);

	ea->service_id = SERVICE_INFO.protocol_id;
	ea->protocol_account_data = aad;
	ea->account_contact = contact;
	ea->list_item = NULL;
	ea->online = 0;
	ea->status = NULL;
	ea->pix = NULL;
	ea->icon_handler = -1;
	ea->status_handler = -1;
	
    return ea;
}

GList * eb_nomodule_get_states()
{
	GList * states = NULL;
	states = g_list_append(states, "No Module or broken account");
	
	return states;
}

gint eb_nomodule_get_current_state(eb_local_account * account )
{
	return 0;
}

void eb_nomodule_set_current_state( eb_local_account * account, gint state )
{
	return;
}

void eb_nomodule_add_user( eb_account * account )
{
	return;
}

void eb_nomodule_del_user( eb_account * account )
{
	return;
}

eb_account * eb_nomodule_new_account( gchar * account )
{
	return NULL;
}

gchar * eb_nomodule_get_status_string( eb_account * account )
{
	static gchar string[255];

	g_snprintf(string, 255, "(Offline)");		

	return string;
}

void eb_nomodule_get_status_pixmap( eb_account * account, GdkPixmap ** pm, GdkBitmap ** bm )
{
	struct eb_nomodule_account_data * aad;
	
	if (!pixmaps)
		eb_nomodule_init_pixmaps();
	
	aad = account->protocol_account_data;
	
	*pm = eb_nomodule_pixmap[aad->status];
	*bm = eb_nomodule_bitmap[aad->status];
}

void eb_nomodule_set_idle( eb_local_account * ela, gint idle )
{
	return;
}

void eb_nomodule_set_away(eb_local_account * account, gchar * message)
{
	return;
}


void eb_nomodule_get_info( eb_local_account * from, eb_account * account_to )
{
	return;
}

input_list * eb_nomodule_get_prefs()
{
	return NULL;
}

void eb_nomodule_read_prefs_config(GList * values)
{
	return;
}

GList * eb_nomodule_write_prefs_config()
{
	return NULL;
}

struct service_callbacks * eb_nomodule_query_callbacks()
{
	struct service_callbacks * sc;
	
	sc = g_new0( struct service_callbacks, 1 );
	sc->query_connected = eb_nomodule_query_connected;
	sc->login = eb_nomodule_login;
	sc->logout = eb_nomodule_logout;
	sc->send_im = eb_nomodule_send_im;
	sc->read_local_account_config = eb_nomodule_read_local_config;
	sc->write_local_config = eb_nomodule_write_local_config;
	sc->read_account_config = eb_nomodule_read_config;
	sc->get_states = eb_nomodule_get_states;
	sc->get_current_state = eb_nomodule_get_current_state;
	sc->set_current_state = eb_nomodule_set_current_state;
	sc->add_user = eb_nomodule_add_user;
	sc->del_user = eb_nomodule_del_user;
	sc->new_account = eb_nomodule_new_account;
	sc->get_status_string = eb_nomodule_get_status_string;
	sc->get_status_pixmap = eb_nomodule_get_status_pixmap;
	sc->set_idle = eb_nomodule_set_idle;
	sc->set_away = eb_nomodule_set_away;
	sc->send_chat_room_message = NULL;
	sc->join_chat_room = NULL;
	sc->leave_chat_room = NULL;
	sc->make_chat_room = NULL;
	sc->send_invite = NULL;
	sc->accept_invite = NULL;
	sc->decline_invite = NULL;
	sc->get_info = eb_nomodule_get_info;

	sc->get_prefs = eb_nomodule_get_prefs;
	sc->read_prefs_config = eb_nomodule_read_prefs_config;
	sc->write_prefs_config = eb_nomodule_write_prefs_config;

	return sc;
}
