/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "gtksctext.h"
#include "browser.h"

static GData * font_cache;
static gboolean cache_init = FALSE;


/*
 * adjust font metric attempts to find a legal font size that best matches
 * the requested font
 */


int _adjust_font_metrics(int size)
{
	size = 6 + (size*3);
	if(size > 60)
	{
		size = 60;
	}
	return size;
}

char * _unescape_string(char * input)
{
	int i = 0;
	int j = 0;
	for(i = 0; input[i]; )
	{
		if(input[i] == '&')
		{
			if(!g_strncasecmp(input+i+1, "gt;", 3))
			{
				input[j++] = '>';
				i+=4;
			}
			else if(!g_strncasecmp(input+i+1, "lt;", 3))
			{
				input[j++] = '<';
				i+=4;
			}
			else if(!g_strncasecmp(input+i+1, "amp;", 4))
			{
				input[j++] = '&';
				i+=5;
			}
			else if(!g_strncasecmp(input+i+1, "#8212;", 6))
			{
				input[j++] = '-';
				input[j++] = '-';
				i+=7;
			}
			else if(!g_strncasecmp(input+i+1, "nbsp;", 5))
			{
				input[j++] = ' ';
				i+=6;
			}
			else
			{
				input[j++] = '&';
				i++;
			}
		}
		else
		{
			input[j++] = input[i++];
		}
	}
	input[j] = '\0';
	return input;
}



static GdkFont * _getfont(char * font, int bold, int italic, int size, int ptsize)
{
    gchar font_name[1024] = "-*-";
    GdkFont * my_font;

	if(!cache_init)
	{
		g_datalist_init(&font_cache);
		cache_init = TRUE;
	}

	

    if(strlen(font))
    {
        strcat( font_name, font );
    }
    else
    {
    	strcat( font_name, "*" );
    }
    strcat( font_name, "-" );

    if(bold)
    {
        strcat( font_name, "bold");
    }
    else
    {
        strcat( font_name, "medium");
    }
    strcat( font_name, "-" );

    /*
     * here is the deal, some fonts have oblique but not italics
     * other fonts have italics but not oblique
     * so we are going to try both
     */

    if( italic == 1 )
    {
        strcat( font_name, "i");
    }
    else if( italic == 2 )
    {
        strcat( font_name, "o" );
    }
    else
    {
        strcat( font_name, "r");
    }
    strcat( font_name, "-*-*-");
    {
        char buff[256];
		if(size != -1)
		{
			int size2 = 0;
			size2 = _adjust_font_metrics(size);
        		sprintf(buff, "%d-*-*-*-*-*-*-*", size2);
		}
		else
		{
        		sprintf(buff, "*-%d-*-*-*-*-*-*", ptsize*10);
		}

        strcat( font_name, buff );
    }

#ifdef DEBUG
	fprintf(stderr, "Wanting font %s\n", font_name);
#endif

    g_strdown(font_name);

    if(( my_font =
            g_datalist_id_get_data(&font_cache, g_quark_from_string(font_name)) ))
    {
        return my_font;
    }
    my_font = gdk_font_load(font_name);
    if( !my_font )
    {
        if( italic == 1 )
        {
            my_font = _getfont(font, bold, 2, size, ptsize );
        }
        else if(strcmp(font, "helvetica"))
        {
            my_font = _getfont("helvetica", bold, italic, size, ptsize );
        }
	else
	{
            my_font = _getfont("fixed", bold, italic, size, ptsize );
	}
    }
    g_datalist_id_set_data( &font_cache,
                            g_quark_from_string(font_name),
                            my_font );
    return my_font;
}

static GdkColor * _getcolor(GdkColormap * map, char * name)
{
	GdkColor * color;

	color = (GdkColor *)g_new0(GdkColor, 1);
	gdk_color_parse(name, color);
	gdk_color_alloc(map, color);
	
	return color;
}

static void _extract_parameter(char * parm, char * buffer, int buffer_size)
{
	/*
	 *if we start with a quote, we should end with a quote
	 * other wise we end with a space
	 */

	if(*parm == '\"')
	{
		int cnt = 0;
		parm += 1;

		for(cnt = 0; *parm && *parm != '\"' && cnt < buffer_size-1; 
				parm++, cnt++)
		{
			buffer[cnt] = *parm;
		}
		buffer[cnt] = '\0';
	}
	else
	{
		int cnt = 0;

		for(cnt = 0; *parm && !isspace(*parm) && *parm != '>' && cnt < buffer_size-1; 
				parm++, cnt++)
		{
			buffer[cnt] = *parm;
		}
		buffer[cnt] = '\0';
	}
}

typedef struct _font_stack
{
	GdkColor * fore;
	GdkColor * back;
	char font_name[255];
	int font_size;
	int font_ptsize;
	struct _font_stack * next;
} font_stack;

static font_stack * _font_stack_init()
{
	font_stack * fs = g_new0(font_stack, 1);

	fs->font_size = 2;
	strcpy(fs->font_name, "helvetica");

	return fs;
}

static font_stack * _font_stack_push(font_stack * fs)
{
	font_stack * fs2 = g_new0(font_stack, 1);
	memcpy(fs2, fs, sizeof(font_stack));
	fs2->next = fs;

	if(fs2->fore)
	{
		fs2->fore = g_new0(GdkColor, 1);
		memcpy(fs2->fore, fs->fore, sizeof(GdkFont));
	}

	if(fs2->back)
	{
		fs2->back = g_new0(GdkColor, 1);
		memcpy(fs2->back, fs->back, sizeof(GdkFont));
	}

	return fs2;
}

static font_stack * _font_stack_pop(font_stack * fs)
{

	font_stack * fs2 = fs->next;
	if(fs->fore)
		g_free(fs->fore);
	if(fs->back)
		g_free(fs->back);
	g_free(fs);

	return fs2;
}


static gboolean _html_compare_data( gpointer x, gpointer y )
{
	return x == y;
}

static gpointer _html_clone_data( gpointer x )
{
	if( x )
	{
		return strdup((char*) x);
	}
	return NULL;
}

static void _html_free_data(gpointer x)
{
#ifdef DEBUG
	fprintf(stderr, "freeing %p\n", x);
#endif
	if( x )
		free(x);
}

static void handle_click(GtkWidget *widget, GdkEventButton * event, gpointer userdata)
{
	if (event->type == GDK_BUTTON_PRESS && event->button == 1)
    {
        int pos = gtk_editable_get_position(GTK_EDITABLE(widget));
        char * data = gtk_sctext_get_property_data(GTK_SCTEXT(widget), pos);

        if(data && strlen(data) > 0 && strcmp(data, "\n"))
        {
            open_url_nw(widget, data);
        }
    }
}

void gtk_eb_html_init(GtkSCText * widget)
{
	gtk_sctext_set_property_data_functions( widget, _html_compare_data,
					_html_clone_data, _html_free_data );
    gtk_signal_connect_after(GTK_OBJECT(widget), "button_press_event",
            GTK_SIGNAL_FUNC(handle_click), NULL);
    gtk_sctext_set_editable(GTK_SCTEXT(widget), FALSE);
    gtk_sctext_set_line_wrap(GTK_SCTEXT(widget), TRUE);
    gtk_sctext_set_word_wrap(GTK_SCTEXT(widget), TRUE);



}





void gtk_eb_html_add(GtkSCText* widget, char * text,
		int ignore_bgcolor, int ignore_fgcolor, int ignore_font)
{
	gchar ** tokens;	
	int i = 0;
	GdkFont * font = NULL;
	/*
	 * these atributes don't go into the font stact because we should not
	 * allow nesting of these attributes, but allow then to be changed
	 * independently of the font stact
	 */

	int font_bold = 0;
	int font_italic = 0;
	char * url = NULL;
	
	int first = 0;



	/*
	 * the ignore variable is used so we can ignore any header that may 
	 * be on the html
	 */

	int ignore = 0;

	font_stack * fs = _font_stack_init();

	fs->fore =  g_new0(GdkColor, 1);
	memcpy(fs->fore, &GTK_WIDGET (widget)->style->fg[0],
			sizeof(GdkColor));

	

	/*
	 * Since the first thing in a split list may or may not be starting with a
	 * < we need to keep track of that manually
	 */
	
	if(*text != '<')
	{
		first = 1;
	}

	/*
	 * a nice heuristic to decide if we should be proper with 
	 * our html and ignore the \n
	 * or deal with our not-so-fortunate human typers
	 * that don't do proper html
	 */

	if(strstr(text, "<br>") || strstr(text, "<BR>"))
	{
		char * c = text;
		while((c = strstr(c, "\n")) != 0)
		{
			*c = ' ';
		}
		c = text;
		while((c = strstr(c, "\r")) != 0)
		{
			*c = ' ';
		}
	}

	tokens = g_strsplit(text, "<", 0);


	/*
	 * if we started with a < then the first thing in the list
	 * will be a 0 lenght string, so we want to skip that
	 */

	for( i = first?0:1; tokens[i]; i++ )
	{


#ifdef DEBUG
		fprintf(stderr, "Part %d: %s\n", i, tokens[i]);
#endif

		if(!first && strstr(tokens[i], ">"))
		{
			char * copy = strdup(tokens[i]);
			gchar ** tags = g_strsplit(tokens[i], ">", 2);
			/*
			 * Okay, we now know that tags[0] is an html tag because
			 * there was a < before it and a > after it
			 */

			/*
			 * first let's clean it up
			 */

#ifdef DEBUG
			fprintf(stderr, "\t Part a: %s\n", tags[0]);
			fprintf(stderr, "\t Part b: %s\n", tags[1]);
#endif
			g_strstrip(tags[0]);
			g_strdown(tags[0]);
	
			if(!strncmp(tags[0], "font", strlen("font")))
			{
				char * data = tags[0] + strlen("font");
				char * parm;

				fs = _font_stack_push(fs);

				if((parm = strstr(data, "face=")) != NULL)
				{
					parm += strlen("face=");
					_extract_parameter(parm, fs->font_name, 255);
				}

				if((parm = strstr(data, "ptsize=")) != NULL)
				{
					char size[25];
					parm += strlen("ptsize=");
					_extract_parameter(parm, size, 25);
					fs->font_size = -1;
					fs->font_ptsize = atoi(size);
#ifdef DEBUG
					fprintf(stderr, "got a ptsize of %d\n", fs->font_ptsize);
#endif
				}
				else if((parm = strstr(data, "size=")) != NULL)
				{
					char size[25];
					parm += strlen("size=");
					_extract_parameter(parm, size, 25);

					if(*size == '+')
					{
						fs->font_size += atoi(size+1);
					}
					else if(*size == '-')
					{
						fs->font_size -= atoi(size+1);
					}
					else
					{
						fs->font_size = atoi(size);
					}
				}
				if((parm = strstr(data, "color=")) != NULL)
				{
					char color[255];
					parm += strlen("color=");
					_extract_parameter(parm, color, 255);
					if(fs->fore)
					{
						g_free(fs->fore);
						fs->fore = NULL;
					}
					if(!ignore_fgcolor)
					{
						/*fprintf(stderr, "color: %s\n", color);*/
						if(!strcmp(color, "#ff0000") && !fs->back)
						{
							GdkColor * bg = &GTK_WIDGET(widget)->style->base[GTK_STATE_NORMAL];
							int r, g, b;
							char color2[20];

							/*fprintf(stderr, "background: #%04x%04x%04x\n",
									bg->red>>8, bg->blue>>8, bg->green>>8);*/

							r = (bg->red >> 8)&0xFF;
							if( ((bg->blue >> 8)&0xFF) < 0x80 )
							{
								b = 0xff;
							}
							else
							{
								b = 0;
							}
							if( ((bg->green >> 8)&0xFF) < 0x80 )
							{
								g = 0xff;
							}
							else
							{
								g = 0;
							}
							sprintf(color2, "#%02x%02x%02x",r,g,b);
							/*fprintf(stderr, "Result: %s\n", color2);*/
							fs->fore = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), color2);
						}
						else if(!strcmp(color, "#0000ff") && !fs->back)
						{
							GdkColor * bg = &GTK_WIDGET(widget)->style->base[GTK_STATE_NORMAL];
							int r, g, b;
							char color2[20];

							b = (bg->blue >> 8)&0xFF ;
							if( ((bg->red >> 8)&0xFF) < 0xa0 )
							{
								r = 0xff;
							}
							else
							{
								r = 0;
							}
							if( ((bg->green >> 8)&0xFF) < 0xa0 )
							{
								g = 0xff;
							}
							else
							{
								g = 0;
							}
							sprintf(color2, "#%02x%02x%02x",r,g,b);
							fs->fore = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), color2);
						}
						else
						{
							fs->fore = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), color);
						}
					}
					else
					{
						if(!fs->back && !ignore_bgcolor)
						{
							fs->fore =  g_new0(GdkColor, 1);
							memcpy(fs->fore, &GTK_WIDGET (widget)->style->fg[0],
									sizeof(GdkColor));
						}
						else
						{
							fs->fore = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), "black");
						}
					}
						
				}

				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
			}
			else if(!strncmp(tags[0], "a ", strlen("a ")))
			{
				char * data = tags[0] + strlen("a ");
				char * parm;

				fs = _font_stack_push(fs);

				if((parm = strstr(copy, "href=")) != NULL
					||(parm = strstr(copy, "HREF=")) != NULL
)
				{
					char tmp_url[1024];
					parm += strlen("href=");

					_extract_parameter(parm, 
							tmp_url, 1024);
					url = strdup(tmp_url);

					if(fs->fore)
					{
						g_free(fs->fore);
					}

					fs->fore = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), "blue");

				}
			}
			else if(!strcmp(tags[0], "/a"))
			{
				fs = _font_stack_pop(fs);
				url = NULL;

				if(!fs)
				{
					fs = _font_stack_init();
					fs->fore =  g_new0(GdkColor, 1);
					memcpy(fs->fore, &GTK_WIDGET (widget)->style->fg[0],
							sizeof(GdkColor));
				}
				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
			}
			else if(!strcmp(tags[0], "b"))
			{
				font_bold = 1;
				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
				
			}
			else if(!strcmp(tags[0], "u"))
			{
#ifdef DEBUG
				fprintf(stderr, "Underline tag found\n");
#endif
				if(!url)
				{
					url = strdup("");
				}
				else
				{
#ifdef DEBUG
					fprintf(stderr, "Underline tag ignored\n");
#endif
				}
			}
			else if(!strcmp(tags[0], "/u"))
			{
				/*
				 * the widget should free the url, so we don't
				 */
				if(url)
				{
					url = NULL;
				}
			}
			else if(!strcmp(tags[0], "/b"))
			{
				font_bold = 0;
				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
			}
			else if(!strcmp(tags[0], "i"))
			{
				font_italic = 1;
				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
			}
			else if(!strcmp(tags[0], "/i"))
			{
				font_italic = 0;
				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
			}
			else if(!strcmp(tags[0], "br"))
			{
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back, 
						url, "\n", strlen("\n"));
			}
			else if(!strcmp(tags[0], "html") 
					| !strcmp(tags[0], "/html")
					| !strcmp(tags[0], "/p")
					| !strcmp(tags[0], "p")
					| !strcmp(tags[0], "title")
					| !strcmp(tags[0], "/title")
					| !strcmp(tags[0], "pre")
					| !strcmp(tags[0], "/pre")
					| !strncmp(tags[0], "img", strlen("img")))
			{
			}
			else if(!strcmp(tags[0], "hr") 
					|| !strncmp(tags[0], "hr ", strlen("hr ")))
			{
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back, 
						NULL, "\n", strlen("\n"));
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back, 
						strdup("\n"), " \n", strlen(" \n"));


			}
			else if(!strcmp(tags[0], "/font")
					|| !strcmp(tags[0], "/body"))
			{
				fs = _font_stack_pop(fs);
				
			
	/*
	 * we don't want to pop off the very first element in the stack
	 * because that is the defaults, if we are in a positon of trying
	 * that means the user tried doing one too many </font>'s
	 * heh
	 */
				
				if(!fs)
				{
					fs = _font_stack_init();
					fs->fore =  g_new0(GdkColor, 1);
					memcpy(fs->fore, &GTK_WIDGET (widget)->style->fg[0],
							sizeof(GdkColor));
				}
				if(!ignore_font)
				{
					font = _getfont(fs->font_name, font_bold, font_italic, 
						fs->font_size, fs->font_ptsize);
				}
				else
				{
					font = NULL;
				}
			}
			else if(!strncmp(tags[0], "head", strlen("head")))
			{
				/*
				 * we want to ignore the header of an html doc
				 */ 

				ignore = 1;
			}
			else if(!strncmp(tags[0], "body", strlen("body")))
			{
				char * data = tags[0] + strlen("body");
				char * parm;

				ignore = 0;


				fs = _font_stack_push(fs);

				if((parm = strstr(data, "bgcolor=")) != NULL)
				{
					char color[255];
					parm += strlen("bgcolor=");
					_extract_parameter(parm, color, 255);
					if(fs->back)
					{
						g_free(fs->back);
					}
					if(!ignore_bgcolor)
					{
						fs->back = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), color);
						fs->fore = _getcolor(gdk_window_get_colormap(GTK_WIDGET(widget)->window), "black");
					}
					else
					{
						fs->back = NULL;
					}
				}
			}
			else
			{
				_unescape_string(copy);
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back,
								url, "<", 1);
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back,
								url, copy, strlen(copy));
				//gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back,
				//				url, ">", 1);
				g_strfreev(tags);
				free(copy);
				first = 0;
				continue;

			}

			if(tags[1] && !ignore)
			{
				_unescape_string(tags[1]);
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back,
								url, tags[1], strlen(tags[1]));

				if(url)
				{
#ifdef DEBUG
					fprintf(stderr, "Underlined text inserted\n");
#endif
				}
			}
			g_strfreev(tags);
			free(copy);
		}
		else
		{
			/*
			 * Otherwise then it is all just text
			 */

			/*
			 * first we were not supposed to have gotten rid of that < ;P
			 */

			if(!ignore)
			{
				if(!first)
				{
					gtk_sctext_insert_with_data( widget, font, fs->fore, 
								fs->back, url, "<", strlen("<") );
				}

				_unescape_string(tokens[i]);
				gtk_sctext_insert_with_data(widget, font, fs->fore, fs->back,
									url, tokens[i], strlen(tokens[i]));
			}

		}
		first = 0;
	}
	/*
	 * we got this quirk of loosing the < if it ends
	 * with the <
	 * this is the fix
	 */

	if(text[strlen(text)-1] == '<')
	{
		gtk_sctext_insert_with_data( widget, font, fs->fore, 
			fs->back, url, "<", strlen("<") );
	}
		
	g_strfreev(tokens);

	while(fs)
	{
		fs = _font_stack_pop(fs);
	}
}
