/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * prefs.c
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dialog.h"
#include "service.h"
#include "util.h"
#include "libproxy/libproxy.h"
#include "pixmaps/ok.xpm"
#include "pixmaps/cancel.xpm"
#include "sound.h"
#include "config.h"
#include "input_list.h"
#include "value_pair.h"
#include "globals.h"
#include "gtkspell.h"

static gint is_prefs_open = 0;


/*
 * Preferences Dialog
 */

void build_general_prefs(GtkWidget *); /* Sat Apr 28 2001 S. K. Mandal*/
void build_sound_tab(GtkWidget *);
void build_connections_tab(GtkWidget *);
void build_sound_prefs(GtkWidget *);
void build_logs_prefs(GtkWidget *);
void build_proxy_prefs(GtkWidget *);
void build_connections_prefs(GtkWidget *);
void build_chat_prefs(GtkWidget *);
void build_encoding_prefs(GtkWidget *);
static void cancel_callback(GtkWidget * widget, gpointer data);
static void destroy(GtkWidget * widget, gpointer data);

void build_prefs()
{
     if(!is_prefs_open)
     {
	  GtkWidget *hbox;
	  GtkWidget *label;
	  GtkWidget *button;
	  GtkWidget *hbox2;
	  GtkWidget *prefs_vbox;
	  GtkWidget *iconwid;
	  GdkPixmap *icon;
	  GdkBitmap *mask;
	  GtkWidget *prefs_window;

	  prefs_vbox = gtk_vbox_new(FALSE, 5);
	  prefs_window = gtk_window_new(GTK_WINDOW_DIALOG);
	  gtk_widget_realize(prefs_window);
	  gtk_window_set_title(GTK_WINDOW(prefs_window), "EveryBuddy Preferences");
	  eb_icon(prefs_window->window);
	  gtk_signal_connect(GTK_OBJECT(prefs_window), "destroy",
			      GTK_SIGNAL_FUNC(destroy), NULL);

	  /*
       ************************************************************
	   Below the different tabs are defined for the preferences
	   window.  In which the user can make everybuddy work more
	   the way he/she wants it too.
	   ************************************************************
       */

	  {
	       GtkWidget *prefs_note = gtk_notebook_new();
	       build_general_prefs(prefs_note);
	       build_logs_prefs(prefs_note);
	       build_sound_prefs(prefs_note);
	       build_chat_prefs(prefs_note);
	       build_connections_prefs(prefs_note);
	       gtk_box_pack_start(GTK_BOX(prefs_vbox), prefs_note, FALSE, FALSE, 0);
	       build_proxy_prefs(prefs_note);
#ifdef HAVE_ICONV_H
	       build_encoding_prefs(prefs_note);
#endif
	  }
   
	  /*Okay Button*/
	  hbox = gtk_hbox_new(FALSE, 5);
	  hbox2 = gtk_hbox_new(TRUE, 5);
	  gtk_widget_set_usize(hbox2, 200,25);
   
	  icon = gdk_pixmap_create_from_xpm_d(prefs_window->window, &mask, NULL, ok_xpm);
	  iconwid = gtk_pixmap_new(icon, mask);
	  label = gtk_label_new("Ok");
   
	  gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
	  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
   
	  gtk_widget_show(iconwid);
	  gtk_widget_show(label);
   
	  button = gtk_button_new();
   
	  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				     GTK_SIGNAL_FUNC (gtk_widget_destroy),
				     GTK_OBJECT (prefs_window));
	  gtk_widget_show(hbox);
   
	  gtk_container_add (GTK_CONTAINER (button), hbox);
   
	  gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 5);
	  gtk_widget_show(button);
   
	  /*Cancel Button*/
	  hbox = gtk_hbox_new(FALSE, 5);
	  icon = gdk_pixmap_create_from_xpm_d(prefs_window->window, &mask, NULL, cancel_xpm);
	  iconwid = gtk_pixmap_new(icon, mask);
	  label = gtk_label_new("Cancel");
   
	  gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
	  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
      
	  gtk_widget_show(iconwid);
	  gtk_widget_show(label);
   
	  button = gtk_button_new();
   
	  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			     cancel_callback, prefs_window);
	  gtk_widget_show(hbox);
   
	  gtk_container_add (GTK_CONTAINER (button), hbox);
   
	  gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 5);
	  gtk_widget_show(button);
   
	  /*End Buttons*/
	  hbox = gtk_hbox_new(FALSE, 5);
	
	  gtk_box_pack_end(GTK_BOX(hbox), hbox2, FALSE, FALSE, 5);
	  gtk_widget_show(hbox2);
   
	  gtk_box_pack_start(GTK_BOX(prefs_vbox), hbox, FALSE, FALSE, 5);
	  gtk_widget_show(hbox);
	  gtk_widget_show(prefs_vbox);
	  gtk_container_add(GTK_CONTAINER(prefs_window), prefs_vbox);

	  gtk_widget_show(prefs_window);
	  is_prefs_open = 1;
     }
}

/*
 * General Preferences Dialog
 * Sat Apr 28 2001 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
 *
 */

gint do_login_on_startup = 0 ;
gint do_login_on_startup_old = 0 ;

#ifdef HAVE_ISPELL
gint do_spell_checking = 1;
gint do_spell_checking_old = 1;
#endif

gint use_alternate_browser = 0;
gint use_alternate_browser_old = 0;
gchar alternate_browser[255] = "";
static GtkWidget * alternate_browser_entry;

void set_use_alternate_browser(GtkWidget * w, int * data);

void build_general_prefs(GtkWidget *prefs_note) {
    GtkWidget *vbox = gtk_vbox_new(FALSE, 5) ;
    GtkWidget *brbutton;
    GtkWidget *label;
    GtkWidget *hbox;

    do_login_on_startup_old = do_login_on_startup ;
    eb_button("Log in on startup", &do_login_on_startup, vbox);

#ifdef HAVE_ISPELL
    do_spell_checking_old = do_spell_checking;
    eb_button("Use spell checking", &do_spell_checking, vbox);
#endif

    use_alternate_browser_old = use_alternate_browser;
    alternate_browser_entry = gtk_entry_new();

    if (alternate_browser) {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), alternate_browser);
    } else {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), "");
    }

    brbutton = eb_button("Use alternate browser", &use_alternate_browser, vbox);
    gtk_signal_connect(GTK_OBJECT(brbutton), "clicked",
	    GTK_SIGNAL_FUNC(set_use_alternate_browser), (gpointer)brbutton);

    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new("Full path to alternate browser:");
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show(label);

    gtk_box_pack_start(GTK_BOX(hbox), alternate_browser_entry, TRUE, TRUE, 10);
    gtk_widget_show(alternate_browser_entry);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
    gtk_widget_show(hbox);

    gtk_widget_show(vbox);

    if(use_alternate_browser == 0)
    {
	gtk_widget_set_sensitive(alternate_browser_entry, FALSE);
    }

    gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox,
	    gtk_label_new("General"));
}

void cancel_general_prefs() {
    do_login_on_startup = do_login_on_startup_old ;
#ifdef HAVE_ISPELL
    do_spell_checking = do_spell_checking_old ;
#endif
    use_alternate_browser = use_alternate_browser_old;
    if (alternate_browser) {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), alternate_browser);
    } else {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), "");
    }
}

void write_general_prefs(FILE *fp) {
    fprintf(fp,"do_login_on_startup=%d\n", do_login_on_startup) ;
#ifdef HAVE_ISPELL
    fprintf(fp,"do_spell_checking=%d\n", do_spell_checking) ;
#endif
    fprintf(fp,"use_alternate_browser=%d\n", use_alternate_browser);
    if (strlen(alternate_browser) > 0) {
	fprintf(fp,"alternate_browser=%s\n", alternate_browser);
    }
}

void set_use_alternate_browser(GtkWidget * w, int * data)
{
     if(use_alternate_browser == 0)
     {
	  gtk_widget_set_sensitive(alternate_browser_entry, FALSE);
     }
     else
     {
	  gtk_widget_set_sensitive(alternate_browser_entry, TRUE);
     }
}

void destroy_general_prefs()
{
    strncpy(alternate_browser, 
	    gtk_entry_get_text(GTK_ENTRY(alternate_browser_entry)), 254);
    alternate_browser[254] = '\0';
}


/*
 * Logs Preferences Dialog
 */

gint do_logging = 1;
gint do_logging_old = 1;
gint do_strip_html = 1;
gint do_strip_html_old = 1;
gint do_restore_last_conv = 0;
gint do_restore_last_conv_old = 0;

void build_logs_prefs(GtkWidget *prefs_note)
{
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);

     do_logging_old = do_logging;
     do_strip_html_old = do_strip_html;
     do_restore_last_conv_old = do_restore_last_conv;

     eb_button("Log all conversations", &do_logging, vbox);
     eb_button("Restore last Conversation", &do_restore_last_conv, vbox);
     eb_button("Strip HTML tags", &do_strip_html, vbox);
     gtk_widget_show(vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Logs"));
}

void cancel_logs_prefs() 
{
     /* Values */
     do_logging = do_logging_old;
     do_strip_html = do_strip_html_old;
     do_restore_last_conv = do_restore_last_conv_old;
}

void write_logs_prefs(FILE *fp)
{
     fprintf(fp,"do_logging=%d\n", do_logging);
     fprintf(fp,"do_strip_html=%d\n", do_strip_html);
     fprintf(fp,"do_restore_last_conv=%d\n", do_restore_last_conv);
}


/*
 * Chat Preferences Dialog
 */

gint do_convo_timestamp = 1;
gint do_convo_timestamp_old = 1;
gint do_enter_send = 1;
gint do_enter_send_old = 1;
gint do_ignore_unknown = 0;
gint do_ignore_unknown_old = 0;
gint do_multi_line = 1;
gint do_multi_line_old = 1;
gint do_raise_window = 1;
gint do_raise_window_old = 1;
gint do_send_idle_time = 1;
gint do_send_idle_time_old = 1;
gint do_timestamp = 1;
gint do_timestamp_old = 1;
gint do_tabbed_chat = 0;
gint do_tabbed_chat_old = 0;
/* Orientation:  1 => top, 0 => bottom */
gint do_tabbed_chat_orient = 0;
gint do_tabbed_chat_orient_old = 0;
gint do_ignore_fore = 0;
gint do_ignore_fore_old = 0;
gint do_ignore_back = 0;
gint do_ignore_back_old = 0;
gint do_ignore_font = 0;
gint do_ignore_font_old = 0;

gint accel_prev_tab[2] =     { GDK_Left, GDK_CONTROL_MASK };
gint accel_prev_tab_old[2] = { GDK_Left, GDK_CONTROL_MASK };
gint accel_next_tab[2] =     { GDK_Right, GDK_CONTROL_MASK };
gint accel_next_tab_old[2] = { GDK_Right, GDK_CONTROL_MASK };
guint accel_change_handler_id = 0;

/* apparently all signal handlers are supposed to be boolean... */
static gboolean newkey_callback (GtkWidget *keybutton, GdkEventKey *event, gint *userdata) {
	GtkWidget *label = GTK_BIN(keybutton)->child;
	/* remove stupid things like.. numlock scrolllock and capslock
	 * mod1 = alt, mod2 = numlock, mod3 = modeshift/altgr, mod4 = meta, mod5 = scrolllock */
	
	gint state = event->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK | GDK_MOD1_MASK | GDK_MOD4_MASK);
	if (state != 0) {
			/* this unfortunately was the only way I could do this without using
			 * a key release event
			 */
		switch(event->keyval) {
				case GDK_Shift_L:
				case GDK_Shift_R:
				case GDK_Control_L:
				case GDK_Control_R:
				case GDK_Caps_Lock:
				case GDK_Shift_Lock:
				case GDK_Meta_L:
				case GDK_Meta_R:
				case GDK_Alt_L:
				case GDK_Alt_R:
				case GDK_Super_L:
				case GDK_Super_R:
				case GDK_Hyper_L:
				case GDK_Hyper_R:
						/* don't let the user set a modifier as a hotkey */
						break;
				default:
					userdata[0] = event->keyval;
					userdata[1] = state;
					gtk_label_set_text(GTK_LABEL(label), gtk_accelerator_name(userdata[0], userdata[1]));
					gtk_signal_disconnect(GTK_OBJECT(keybutton), accel_change_handler_id);
					gtk_grab_remove(keybutton);
					accel_change_handler_id = 0;
		}
	}
	/* eat the event and make focus keys (arrows) not change the focus */
	return gtk_true();
}

static void getnewkey (GtkWidget * keybutton, gpointer userdata) {
	GtkWidget *label = GTK_BIN(keybutton)->child;

	if(accel_change_handler_id == 0) {
		gtk_label_set_text(GTK_LABEL(label), "Please press new key and modifier now.");
	
		gtk_object_set_data(GTK_OBJECT(keybutton), "accel", userdata);
		
		/* it's sad how this works: It grabs the events in the event mask
		 * of the widget the mouse is over, NOT the grabbed widget.
		 * Oh, and persistantly clicking makes the grab go away...
		 */
		gtk_grab_add(keybutton);
		
		accel_change_handler_id = gtk_signal_connect_after (GTK_OBJECT(keybutton),
					"key_press_event",
					GTK_SIGNAL_FUNC (newkey_callback),
					userdata);
	}
}

static void add_key_set(gchar *labelString,
					gint *userdata,
					GtkWidget *vbox)
{
     GtkWidget *hbox;
     GtkWidget *label;
     GtkWidget *button;
     hbox = gtk_hbox_new(FALSE, 2);
     gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

     label = gtk_label_new (labelString);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);
     gtk_widget_set_usize(label, 255, 10);
	 gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
     gtk_widget_show (label);

	 /* do I need to free whats returned from gtk_accelerator? */
     button = gtk_button_new_with_label(gtk_accelerator_name(userdata[0], userdata[1]));
	 
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(getnewkey), 
			(gpointer)userdata);
     gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
     gtk_widget_show (button);

     gtk_widget_show(hbox);
}

void build_chat_prefs(GtkWidget *prefs_note) 
{
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);

     /* Values */
     do_ignore_unknown_old = do_ignore_unknown;
     do_send_idle_time_old = do_send_idle_time;
     do_raise_window_old = do_raise_window;
     do_timestamp_old = do_timestamp;
     do_multi_line_old = do_multi_line;
     do_enter_send_old = do_enter_send;
     do_convo_timestamp_old = do_convo_timestamp;
     do_tabbed_chat_old = do_tabbed_chat;
     do_tabbed_chat_orient_old = do_tabbed_chat_orient_old;

	 do_ignore_fore_old = do_ignore_fore;
	 do_ignore_back_old = do_ignore_back;
	 do_ignore_font_old = do_ignore_font;

	 accel_next_tab_old[0] = accel_next_tab[0];
	 accel_next_tab_old[1] = accel_next_tab[1];
	 accel_prev_tab_old[0] = accel_prev_tab[0];
	 accel_prev_tab_old[1] = accel_prev_tab[1];
	 accel_change_handler_id = 0;

     eb_button("Send idle/away status to servers", &do_send_idle_time, vbox);
     eb_button("Raise window on incoming message", &do_raise_window, vbox);
     eb_button("Timestamp when a user logs on/off", &do_timestamp, vbox);
     eb_button("Ignore unknown users", &do_ignore_unknown, vbox);
     eb_button("Enable multi-line chat", &do_multi_line, vbox);
     eb_button("Press enter to send", &do_enter_send, vbox);
     eb_button("Timestamps on Messages", &do_convo_timestamp, vbox);
     eb_button("Use tabbed chat windows", &do_tabbed_chat, vbox);
     eb_button("Tabbed Chat Tabs at Top (True is Top, False is Bottom)",
		&do_tabbed_chat_orient, vbox);
     eb_button("Ignore Foreground Colors", &do_ignore_fore, vbox);
     eb_button("Ignore Background Colors", &do_ignore_back, vbox);
     eb_button("Ignore Fonts", &do_ignore_font, vbox);

	 add_key_set("Previous Tab Hotkey (requires a modifier)", accel_prev_tab, vbox);
	 add_key_set("Next Tab Hotkey (requires a modifier)", accel_next_tab, vbox);

     gtk_widget_show(vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Chat"));
}

void cancel_chat_prefs()
{
     do_ignore_unknown = do_ignore_unknown_old;
     do_send_idle_time = do_send_idle_time_old;
     do_raise_window = do_raise_window_old;
     do_timestamp = do_timestamp_old;
     do_multi_line = do_multi_line_old;
     do_enter_send = do_enter_send_old;
     do_convo_timestamp = do_convo_timestamp_old;
     do_tabbed_chat = do_tabbed_chat_old;
     do_tabbed_chat_orient = do_tabbed_chat_orient_old;
	 do_ignore_fore = do_ignore_fore_old;
	 do_ignore_back = do_ignore_back_old;
	 do_ignore_font = do_ignore_font_old;	 
	 
	 accel_next_tab[0] = accel_next_tab_old[0];
	 accel_next_tab[1] = accel_next_tab_old[1];
	 accel_prev_tab[0] = accel_prev_tab_old[0];
	 accel_prev_tab[1] = accel_prev_tab_old[1];
}

void write_chat_prefs(FILE *fp)
{
     fprintf(fp,"do_ignore_unknown=%d\n", do_ignore_unknown);
     fprintf(fp,"do_send_idle_time=%d\n", do_send_idle_time);
     fprintf(fp,"do_raise_window=%d\n", do_raise_window);
     fprintf(fp,"do_timestamp=%d\n", do_timestamp);
     fprintf(fp,"do_multi_line=%d\n", do_multi_line);
     fprintf(fp,"do_enter_send=%d\n", do_enter_send);
     fprintf(fp,"do_convo_timestamp=%d\n", do_convo_timestamp);
     fprintf(fp,"do_tabbed_chat=%d\n", do_tabbed_chat);
     fprintf(fp,"do_tabbed_chat_orient=%d\n", do_tabbed_chat_orient);
	 fprintf(fp,"do_ignore_fore=%d\n", do_ignore_fore);
	 fprintf(fp,"do_ignore_back=%d\n", do_ignore_back);
	 fprintf(fp,"do_ignore_font=%d\n", do_ignore_font);
	 fprintf(fp,"accel_next_tab=%s\n", gtk_accelerator_name(accel_next_tab[0], accel_next_tab[1]));
	 fprintf(fp,"accel_prev_tab=%s\n", gtk_accelerator_name(accel_prev_tab[0], accel_prev_tab[1]));
}

/*
 * Proxies Preferences Dialog
 */
static GtkWidget * proxy_server_entry;
static GtkWidget * proxy_port_entry;
static gint new_proxy_type;

static void set_proxy_type(GtkWidget *w, int *data);

void build_proxy_prefs(GtkWidget *prefs_note)
{
     GtkWidget *label;
     GtkWidget *button;
     GtkWidget *hbox;
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
     char buff[10];   

     proxy_server_entry = gtk_entry_new();
     proxy_port_entry = gtk_entry_new();

     label = gtk_label_new("Warning: Not all services are available through\nproxy, please see the README for details.");
     gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);
     button = gtk_radio_button_new_with_label(NULL, "Direct Connection");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_NONE);
	
     if(proxy_type == PROXY_NONE)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

     button = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
					       "Use HTTP Proxy");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_HTTP);

     if(proxy_type == PROXY_HTTP)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

	
     button = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
					       "Use SOCKS4 Proxy");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_SOCKS4);

     if(proxy_type == PROXY_SOCKS4)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

     button = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
					       "Use SOCKS5 Proxy");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_SOCKS5);

     if(proxy_type == PROXY_SOCKS5)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Proxy Server:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     if(proxy_host)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), proxy_host);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), "");
     }

     gtk_box_pack_start(GTK_BOX(hbox), proxy_server_entry, TRUE, TRUE, 10);
     gtk_widget_show(proxy_server_entry);

     label = gtk_label_new("Proxy Port:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     g_snprintf(buff, 10, "%d", proxy_port);
     gtk_entry_set_text(GTK_ENTRY(proxy_port_entry), buff);
     gtk_box_pack_start(GTK_BOX(hbox), proxy_port_entry, FALSE, FALSE, 0);
     gtk_widget_show(proxy_port_entry);

     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 3);
     gtk_widget_show(hbox);

     if(proxy_type == PROXY_NONE)
     {
	  gtk_widget_set_sensitive(proxy_server_entry, FALSE);
	  gtk_widget_set_sensitive(proxy_port_entry, FALSE);
     }

     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Proxy"));
     gtk_widget_show(vbox);
}

void cancel_proxy_prefs()
{
     char buff[10];

     new_proxy_type = proxy_type;
	
     if(proxy_host)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), proxy_host);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), "");
     }

     g_snprintf(buff, 10, "%d", proxy_port);
     gtk_entry_set_text(GTK_ENTRY(proxy_port_entry), buff);
}

void destroy_proxy()
{
     proxy_set_proxy(new_proxy_type,
		     gtk_entry_get_text(GTK_ENTRY(proxy_server_entry)),
		     atol(gtk_entry_get_text(GTK_ENTRY(proxy_port_entry))));
}

void write_proxy_prefs(FILE *fp)
{
     fprintf(fp,"proxy_type=%d\n", proxy_type);
     if(proxy_host)
     {
	  fprintf(fp,"proxy_host=%s\n", proxy_host);
     }
     fprintf(fp,"proxy_port=%d\n", proxy_port);
}


static void set_proxy_type(GtkWidget * w, int * data)
{
     new_proxy_type = (int)data;
     if(new_proxy_type == PROXY_NONE)
     {
	  gtk_widget_set_sensitive(proxy_server_entry, FALSE);
	  gtk_widget_set_sensitive(proxy_port_entry, FALSE);
     }
     else
     {
	  gtk_widget_set_sensitive(proxy_server_entry, TRUE);
	  gtk_widget_set_sensitive(proxy_port_entry, TRUE);
     }
}


/*
 * Encoding Preferences Dialog
 */

#ifdef HAVE_ICONV_H
#define ENCODE_LEN 64
gint use_recoding = 0;
gchar local_encoding[ENCODE_LEN] = "";
gchar remote_encoding[ENCODE_LEN] = "";

static GtkWidget * local_encoding_entry;
static GtkWidget * remote_encoding_entry;

void set_use_of_recoding(GtkWidget * w, int * data);

/* Encoding conversion Configuration tabs */
void build_encoding_prefs(GtkWidget * prefs_note)
{
     GtkWidget * hbox;
     GtkWidget * label;
     GtkWidget * button;
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);

     local_encoding_entry = gtk_entry_new();
     remote_encoding_entry = gtk_entry_new();

     label = gtk_label_new("Warning: conversion is made using "
			   "iconv() wich is UNIX98 standard and we hope you have it :-)\n"
			   "For list of possible encodings run 'iconv --list'.");
     gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     button = eb_button("Use recoding in conversations", &use_recoding, vbox);

     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_use_of_recoding), (gpointer)button);

     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Local encoding:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     gtk_entry_set_text(GTK_ENTRY(local_encoding_entry), local_encoding);
     gtk_box_pack_start(GTK_BOX(hbox), local_encoding_entry, TRUE, TRUE, 10);
     gtk_widget_show(local_encoding_entry);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
     gtk_widget_show(hbox);


     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Remote encoding:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     gtk_entry_set_text(GTK_ENTRY(remote_encoding_entry), remote_encoding);
     gtk_box_pack_start(GTK_BOX(hbox), remote_encoding_entry, TRUE, TRUE, 10);
     gtk_widget_show(remote_encoding_entry);
     gtk_widget_show(hbox);

     gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Recoding"));
     gtk_widget_show(vbox);

     if(use_recoding == 0)
     {
	  gtk_widget_set_sensitive(local_encoding_entry, FALSE);
	  gtk_widget_set_sensitive(remote_encoding_entry, FALSE);
     }

}

void destroy_encodings() 
{
     strncpy(local_encoding, gtk_entry_get_text(GTK_ENTRY(local_encoding_entry)), ENCODE_LEN - 1);
     local_encoding[ENCODE_LEN-1] = '\0';
     strncpy(remote_encoding, gtk_entry_get_text(GTK_ENTRY(remote_encoding_entry)), ENCODE_LEN - 1);
     remote_encoding[ENCODE_LEN-1] = '\0';
}

void set_use_of_recoding(GtkWidget * w, int * data)
{
     //new_proxy_type = (int)data;
     if(use_recoding == 0)
     {
	  gtk_widget_set_sensitive(local_encoding_entry, FALSE);
	  gtk_widget_set_sensitive(remote_encoding_entry, FALSE);
     }
     else
     {
	  gtk_widget_set_sensitive(local_encoding_entry, TRUE);
	  gtk_widget_set_sensitive(remote_encoding_entry, TRUE);
     }
}

void write_encoding_prefs(FILE *fp)
{
     fprintf(fp,"use_recoding=%d\n", use_recoding);
     if(strlen(local_encoding) > 0)
	  fprintf(fp,"local_encoding=%s\n", local_encoding);
     if(strlen(remote_encoding) > 0)
	  fprintf(fp,"remote_encoding=%s\n", remote_encoding);
}

#endif


/*
 * Connections Preferences Dialog
 */

void build_connections_prefs(GtkWidget *prefs_note)
{
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
     build_connections_tab(vbox);
     gtk_widget_show(vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Connections"));

     gtk_widget_show(prefs_note);
}

void cancel_connections_prefs()
{
     int i;
     for(i = 0; i < NUM_SERVICES; i++)
     {
	  if(eb_services[i].sc->get_prefs)
	  {
		  eb_input_cancel(eb_services[i].sc->get_prefs());
	  }
     }
}

void destroy_connections()
{
     int i;
     for(i = 0; i < NUM_SERVICES; i++)
     {
	  if(eb_services[i].sc->get_prefs)
	  {
		  eb_input_accept(eb_services[i].sc->get_prefs());
	  }
     }
}

void write_connections_prefs(FILE *fp)
{
     int i;
     fprintf(fp,"connections\n");
     for(i = 0; i < NUM_SERVICES; i++)
     {
	  GList * service_prefs;
	  fprintf(fp, "\t%s\n", eb_services[i].name);
	  if(eb_services[i].sc->write_prefs_config)
	  {
		  service_prefs = eb_services[i].sc->write_prefs_config();
		  value_pair_print_values(service_prefs, fp, 2);
		  value_pair_free(service_prefs);
	  }
	  fprintf(fp, "\tend\n");
     }
}


/*
 * Connections Preferences sub-dialogs
 */

void build_connections_tab(GtkWidget * parent_window)
{
     GtkWidget * service_vbox;
     GtkWidget * con_note;
     gint i;

     con_note = gtk_notebook_new();

     for(i = 0; i < NUM_SERVICES; i++)
     {
	  service_vbox = gtk_vbox_new(FALSE, 5);
	  gtk_widget_show(service_vbox);
			

	  if(eb_services[i].sc->get_prefs)
	  {
		  eb_input_render(eb_services[i].sc->get_prefs(),
				  service_vbox);
	  }

	  gtk_notebook_append_page(GTK_NOTEBOOK(con_note), service_vbox, gtk_label_new(eb_services[i].name));
     }

     gtk_widget_show(con_note);
     gtk_container_add(GTK_CONTAINER(parent_window), con_note);
	

}

/*
 * Sound Preferences Dialog
 */

//gchar *sounddevice_old = "/dev/audio"; //defaults at "/dev/audio"
//gint use_sounddevice_old = 0;
//gint use_typical_sound_method_old = 0;
gint do_away_sound = 1;
gint do_away_sound_old = 1;
gint do_no_sound_when_away = 0;
gint do_no_sound_when_away_old = 0;
gint do_online_sound = 1;
gint do_online_sound_old = 1;
gint do_play_send = 1;
gint do_play_send_old = 1;
gint do_play_first = 1;
gint do_play_first_old = 1;
gint do_play_receive = 1;
gint do_play_receive_old = 1;

// todo: allocate these 14KB of buffers dynamically
//gchar *sounddevice = "/dev/audio"; //defaults at "/dev/audio"
//gint use_sounddevice = 0;
//gint use_typical_sound_method = 0;
gchar BuddyArriveFilename[1024] = BuddyArriveDefault;
gchar BuddyArriveFilename_old[1024] = BuddyArriveDefault;
gchar BuddyAwayFilename[1024] = BuddyLeaveDefault;
gchar BuddyAwayFilename_old[1024] = BuddyLeaveDefault;
gchar BuddyLeaveFilename[1024] = BuddyLeaveDefault;
gchar BuddyLeaveFilename_old[1024] = BuddyLeaveDefault;
gchar FirstMsgFilename[1024] = RecieveDefault;
gchar FirstMsgFilename_old[1024] = RecieveDefault;
gchar RecieveFilename[1024] = RecieveDefault;
gchar RecieveFilename_old[1024] = RecieveDefault;
gchar SendFilename[1024] = SendDefault;
gchar SendFilename_old[1024] = SendDefault;

gfloat volume_sound = 0;
gfloat volume_sound_old = 0;

static GtkWidget *arrivesoundentry;
static GtkWidget *awaysoundentry;
static GtkWidget *leavesoundentry;
static GtkWidget *sendsoundentry;
static GtkWidget *recievesoundentry;
static GtkWidget *firstmsgsoundentry;
static GtkWidget *volumesoundentry;

GtkWidget *add_sound_file_selection_box(gchar *, GtkWidget *, gchar *, int);
GtkWidget *add_sound_volume_selection_box(gchar *, GtkWidget *, GtkAdjustment *);
/* Main Sound Preferences Funtion, hooks in the rest */

void build_sound_prefs(GtkWidget *prefs_note) 
{
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
     build_sound_tab(vbox);
     gtk_widget_show (vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Sound"));

     gtk_widget_show(prefs_note);

}

     /* This is the sound sub-tabs code */

void build_sound_tab(GtkWidget * parent_window)
{

     GtkWidget * sound_vbox;
     GtkWidget * sound_note;

     sound_note = gtk_notebook_new();

     /* Values */
     do_no_sound_when_away_old = do_no_sound_when_away;
     do_online_sound_old = do_online_sound;
     do_play_send_old = do_play_send;
     do_play_first_old = do_play_first;
     do_play_receive_old = do_play_receive;
//	use_typical_sound_method_old = use_typical_sound_method;
//	use_sounddevice_old = use_sounddevice;
//	sounddevice_old = sounddevice;
     strcpy(BuddyArriveFilename_old, BuddyArriveFilename);
     strcpy(BuddyAwayFilename_old, BuddyAwayFilename);
     strcpy(BuddyLeaveFilename_old, BuddyLeaveFilename);
     strcpy(SendFilename_old, SendFilename);
     strcpy(RecieveFilename_old, RecieveFilename);
     strcpy(FirstMsgFilename_old, FirstMsgFilename);
     volume_sound_old = volume_sound;

     /* General Tab */
 
    sound_vbox = gtk_vbox_new(FALSE, 5);
     gtk_widget_show(sound_vbox);

     eb_button("Disable sounds when away", &do_no_sound_when_away, sound_vbox);
     eb_button("Enable sounds when sending to a person that is away",&do_away_sound, sound_vbox);
     eb_button("Play sounds when signing on or off", &do_online_sound, sound_vbox);
     eb_button("Play a sound when sending a message", &do_play_send, sound_vbox);
     eb_button("Play a sound when receiving a message", &do_play_receive, sound_vbox);
     eb_button("Play a sound when receiving first message", &do_play_first, sound_vbox);

    gtk_notebook_append_page(GTK_NOTEBOOK(sound_note), sound_vbox, gtk_label_new("General"));

     gtk_widget_show(sound_note);
     gtk_container_add(GTK_CONTAINER(parent_window), sound_note);

     /* Files Tab */

     sound_vbox = gtk_vbox_new(FALSE, 5);
     gtk_widget_show(sound_vbox);

     arrivesoundentry = 
	  add_sound_file_selection_box("Buddy Arrive Sound: ",
				       sound_vbox,
				       BuddyArriveFilename,
				       BUDDY_ARRIVE);
     awaysoundentry = 
	  add_sound_file_selection_box("Buddy Away Sound: ",
				       sound_vbox,
				       BuddyAwayFilename,
				       BUDDY_AWAY);
     leavesoundentry = 
	  add_sound_file_selection_box("Buddy Leave Sound: ",
				       sound_vbox,
				       BuddyLeaveFilename,
				       BUDDY_LEAVE);

     sendsoundentry = 
	  add_sound_file_selection_box("Send Sound: ",
				       sound_vbox,
				       SendFilename,
				       SEND);

     firstmsgsoundentry = 
	  add_sound_file_selection_box("1st Message Receive: ",
				       sound_vbox,
				       FirstMsgFilename,
				       FIRSTMSG);

     recievesoundentry = 
	  add_sound_file_selection_box("Receive Sound: ",
				       sound_vbox,
				       RecieveFilename,
				       RECEIVE);
     volumesoundentry =
       add_sound_volume_selection_box("Relative Volume (dB)",
				      sound_vbox,
				      gtk_adjustment_new(volume_sound,
							 -40,0,1,5,0));

     gtk_widget_show(sound_vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(sound_note), sound_vbox, 
			      gtk_label_new("Files"));

     gtk_container_add(GTK_CONTAINER(parent_window), sound_note);

}

void cancel_sound_prefs()
{
     /* Values */
//	use_typical_sound_method = use_typical_sound_method_old;
//	use_sounddevice = use_sounddevice_old;
//	sounddevice = sounddevice_old;
     do_play_send = do_play_send_old;
     do_play_first = do_play_first_old;
     do_play_receive = do_play_receive_old;
     do_online_sound = do_online_sound_old;
     do_no_sound_when_away = do_no_sound_when_away_old;
     do_away_sound = do_away_sound_old;
     strcpy(BuddyArriveFilename,  BuddyArriveFilename_old);
     strcpy(BuddyAwayFilename, BuddyAwayFilename_old);
     strcpy(BuddyLeaveFilename, BuddyLeaveFilename_old);
     strcpy(SendFilename, SendFilename_old);
     strcpy(RecieveFilename, RecieveFilename_old);
     strcpy(FirstMsgFilename, FirstMsgFilename_old);
     volume_sound = volume_sound_old;

     /* Widgets */
     gtk_entry_set_text (GTK_ENTRY (arrivesoundentry), BuddyArriveFilename);
     gtk_entry_set_text (GTK_ENTRY (awaysoundentry), BuddyAwayFilename);
     gtk_entry_set_text (GTK_ENTRY (leavesoundentry), BuddyLeaveFilename);
     gtk_entry_set_text (GTK_ENTRY (sendsoundentry), SendFilename);
     gtk_entry_set_text (GTK_ENTRY (recievesoundentry), RecieveFilename);
     gtk_entry_set_text (GTK_ENTRY (firstmsgsoundentry), FirstMsgFilename);
}

static void setsoundfilename(GtkWidget * fileselector, int userdata);
static void getsoundfile (GtkWidget * sendf_button, gpointer userdata);
static void soundfile_entry_changed(GtkEntry * entry, int userdata);
static void testsoundfile (GtkWidget * sendf_button, int userdata);
static void soundvolume_changed(GtkAdjustment * adjust, int userdata);

GtkWidget *add_sound_file_selection_box(gchar *labelString,
					GtkWidget *vbox,
					gchar *initialFilename,
					int userdata) 
{
     GtkWidget *hbox;
     GtkWidget *widget;
     GtkWidget *label;
     GtkWidget *button;
     hbox = gtk_hbox_new(FALSE, 3);
     gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

     label = gtk_label_new (labelString);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);
     gtk_widget_set_usize(label, 125, 10);
     gtk_widget_show (label);

     widget = gtk_entry_new ();
     gtk_entry_set_text (GTK_ENTRY (widget), initialFilename);
     gtk_widget_ref (widget);
     gtk_signal_connect(GTK_OBJECT(widget), "changed", 
			GTK_SIGNAL_FUNC(soundfile_entry_changed), 
			(gpointer) userdata);
     gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
     gtk_widget_show (widget);

     button = gtk_button_new_with_label ("Browse");
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(getsoundfile), 
			(gpointer)userdata);
     gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
     gtk_widget_show (button);

     button = gtk_button_new_with_label ("Preview");
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(testsoundfile), 
			(gpointer)userdata);
     gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
     gtk_widget_show (button);
     gtk_widget_show(hbox);
     return widget;
}

GtkWidget *add_sound_volume_selection_box(gchar *labelString,
					  GtkWidget *vbox,
					  GtkAdjustment *adjust)
{
     GtkWidget *hbox;
     GtkWidget *widget;
     GtkWidget *label;
     int dummy=0;
     hbox = gtk_hbox_new(FALSE, 3);
     gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

     label = gtk_label_new (labelString);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);
     gtk_widget_set_usize(label, 125, 10);
     gtk_widget_show (label);

     widget=gtk_hscale_new(adjust);
     /*     widget = gtk_entry_new ();
	    gtk_entry_set_text (GTK_ENTRY (widget), initialFilename); */
     gtk_widget_ref (widget);
     gtk_signal_connect(GTK_OBJECT(adjust), "value_changed", 
			GTK_SIGNAL_FUNC(soundvolume_changed), 
			(gpointer) dummy);
     gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
     gtk_widget_show (widget);

     gtk_widget_show(hbox);
     return widget;
}

GtkWidget *soundfileselector;

static void getsoundfile (GtkWidget * sendf_button, gpointer userdata)
{
//	GtkWidget *file_selector;
     printf("Just entered getsoundfile\n");
     soundfileselector = gtk_file_selection_new("Please select a file to use.");
   
     gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION(soundfileselector)->ok_button),
			"clicked", GTK_SIGNAL_FUNC (setsoundfilename), userdata);
   
     gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(soundfileselector)->ok_button),
			       "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			       (gpointer) soundfileselector);

     gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(soundfileselector)->cancel_button),
			       "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			       (gpointer) soundfileselector);
                                            
     gtk_widget_show (soundfileselector);	
}

static void soundfile_entry_changed(GtkEntry * entry, int userdata)
{
     switch(userdata) 
     {
     case BUDDY_ARRIVE: 	
	  strcpy(BuddyArriveFilename, 
		 gtk_entry_get_text(GTK_ENTRY (arrivesoundentry)));
	  break;
     case BUDDY_LEAVE:	
	  strcpy(BuddyLeaveFilename, 
		 gtk_entry_get_text(GTK_ENTRY (leavesoundentry)));
	  break;
     case SEND:		
	  strcpy(SendFilename, 
		 gtk_entry_get_text(GTK_ENTRY (sendsoundentry)));
	  break;
     case RECEIVE:		
	  strcpy(RecieveFilename, 
		 gtk_entry_get_text(GTK_ENTRY (recievesoundentry)));
	  break;
     case BUDDY_AWAY: 	
	  strcpy(BuddyAwayFilename,  
		 gtk_entry_get_text(GTK_ENTRY (awaysoundentry)));
	  break;
     case FIRSTMSG:		
	  strcpy(FirstMsgFilename, 
		 gtk_entry_get_text(GTK_ENTRY (firstmsgsoundentry)));
	  break;
     }
}

static void setsoundfilename(GtkWidget * fileselector, int userdata)
{
     gchar *selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(soundfileselector));

     printf("Just entered setsoundfilename and the selected file is %s\n", selected_filename);
     switch(userdata) 
     {
     case BUDDY_ARRIVE: 	
	  strcpy(BuddyArriveFilename, selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (arrivesoundentry), 
			      selected_filename);
	  break;
     case BUDDY_LEAVE:	
	  strcpy(BuddyLeaveFilename, selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (leavesoundentry), 
			      selected_filename);
	  break;
     case SEND:		
	  strcpy(SendFilename, selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (sendsoundentry), selected_filename);
	  break;
     case RECEIVE:		
	  strcpy(RecieveFilename, selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (recievesoundentry), 
			      selected_filename);
	  break;
     case BUDDY_AWAY: 	
	  strcpy(BuddyAwayFilename, selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (awaysoundentry), selected_filename);
	  break;
     case FIRSTMSG:		
	  strcpy(FirstMsgFilename, selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (firstmsgsoundentry), 
			      selected_filename);
	  break;

     }
}

static void testsoundfile (GtkWidget * sendf_button, int userdata)
{
     switch(userdata) 
     {
     case BUDDY_ARRIVE:
	  playsoundfile(BuddyArriveFilename);
	  break;
		
     case BUDDY_LEAVE:
	  playsoundfile(BuddyLeaveFilename);
	  break;
	
     case SEND:
	  playsoundfile(SendFilename);
	  break;
	
     case RECEIVE:
	  playsoundfile(RecieveFilename);
	  break;
	
     case BUDDY_AWAY:
	  playsoundfile(BuddyAwayFilename);
	  break;
	
     case FIRSTMSG:
	  playsoundfile(FirstMsgFilename);
	  break;

     }
}

static void soundvolume_changed(GtkAdjustment * adjust, int userdata)
{
  volume_sound = adjust->value ;
}

void write_sound_prefs(FILE *fp)
{
     fprintf(fp,"do_play_send=%d\n", do_play_send);
     fprintf(fp,"do_play_first=%d\n", do_play_first);
     fprintf(fp,"do_play_receive=%d\n", do_play_receive);
     fprintf(fp,"do_online_sound=%d\n", do_online_sound);
//	fprintf(fp,"use_typical_sound_method=%d\n", use_typical_sound_method);
//	fprintf(fp,"use_sounddevice=%d\n", use_sounddevice);
     fprintf(fp,"do_away_sound=%d\n", do_away_sound);
     fprintf(fp,"do_no_sound_when_away=%d\n", do_no_sound_when_away);
     fprintf(fp,"BuddyArriveFilename=%s\n", BuddyArriveFilename);
     fprintf(fp,"BuddyAwayFilename=%s\n", BuddyAwayFilename);
     fprintf(fp,"BuddyLeaveFilename=%s\n", BuddyLeaveFilename);
     fprintf(fp,"SendFilename=%s\n", SendFilename);
     fprintf(fp,"RecieveFilename=%s\n", RecieveFilename);
     fprintf(fp,"FirstMsgFilename=%s\n", FirstMsgFilename);
     fprintf(fp,"SoundVolume=%f\n",volume_sound);
}

/*
 * Reading/Writing Prefs
 */
void write_prefs()
{
     gchar buff[1024];
     FILE * fp;
     // todo: write to temp file and rename at end to prevent damaged files
     g_snprintf(buff, 1024, "%sprefs",config_dir);
     fp = fopen(buff, "w");
     write_general_prefs(fp);
     write_logs_prefs(fp);
     write_sound_prefs(fp);
     write_chat_prefs(fp);
#ifdef HAVE_ICONV_H
     write_encoding_prefs(fp);
#endif
     write_proxy_prefs(fp);
     write_connections_prefs(fp);
     fprintf(fp, "end\n");
     fclose(fp);
}

// todo: re-organize to separate pref reading into modules
void eb_read_prefs()
{
     gchar buff[1024];
     gint new_proxy_type = PROXY_NONE;
     char new_proxy_host[255] = "";
     gint new_proxy_port = 0;
     FILE * fp;
	  gchar *param=buff;
	  gchar *val=buff;

     g_snprintf(buff, 1024, "%sprefs",config_dir);
     fp = fopen(buff, "r");
     if(!fp)
     {
	    write_prefs();
	    return;
     }
     while(!feof(fp))
     {
	    fgets(buff, 1024, fp);
			 param=buff;
			 if(feof(fp))
	         break;
	    g_strstrip(param);
	    if(!strcasecmp(buff, "connections"))
	    {
	         for(;;)
	         {
	  	      int id;
	  	      GList * session_prefs = NULL;
	  	      fgets(buff, 1024, fp);
						  param=buff;
	  	      g_strstrip(param);
	  	      if(!strcasecmp(param, "end"))
	  	      {
	  	  	   break;
	  	      }
	  	      id = get_service_id(param);
	  	      for(;;)
	  	      {
	  	  	   fgets(buff, 1024, fp);
								 param=buff;
	  	  	   g_strstrip(param);
	  	  	   if(!strcasecmp(param, "end"))
	  	  	   {
	  	  	        if(eb_services[id].sc->read_prefs_config)
	  	  	        {
	  	  	  	    eb_services[id].sc->read_prefs_config(session_prefs);
	  	  	        }
	  	  	        value_pair_free(session_prefs);

	  	  	        break;
	  	  	   }
	  	  	   else
	  	  	   {
											val=param;
											
											while(*val != 0 && *val !='=')
												 val++;
											if(*val=='=')
											{
												 *val='\0';
												 val++;
											}

	  	  	  	   /*
	  	  	  	    * if quoted strip off the quotes
	  	  	  	    */

	  	  	  	   if(*val == '"')
	  	  	  	   {
	  	  	  	  	   val++;
	  	  	  	  	   val[strlen(val)-1] = '\0';
	  	  	  	   }
	  	  	  	   session_prefs = value_pair_add(session_prefs,
	  	  	  	  	  	  	   param, val);
	  	  	   }
	  	      }
	         }
	         continue;
	    }
			 val=param;

			 while(*val != 0 && *val !='=')
				  val++;
			 if(*val=='=')
			 {
				  *val='\0';
				  val++;
			 }

	    /*
	     * wow, this should be changed to something more elegant like flex/bison parser, or
	     * switch/case, or atleast partial sorting of use_/do_/proxy_/other... 
	     */

	    if(!g_strncasecmp(param, "proxy_type", strlen("proxy_type")+1))
	    {
	         new_proxy_type = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "proxy_host", strlen("proxy_host")+1))
	    {
	         strcpy(new_proxy_host, val);
	    }
	    else if(!g_strncasecmp(param, "proxy_port", strlen("proxy_port")+1))
	    {
	         new_proxy_port = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_login_on_startup", strlen("do_login_on_startup")+1))
	    {
	         do_login_on_startup = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_logging", strlen("do_logging")+1))
	    {
	         do_logging = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_strip_html", strlen("do_strip_html")+1))
	    {
	         do_strip_html = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_play_send", strlen("do_play_send")+1))
	    {
	         do_play_send = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_play_first", strlen("do_play_first")+1))
	    {
	         do_play_first = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_play_receive", strlen("do_play_receive")+1))
	    {
	         do_play_receive = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_ignore_unknown", strlen("do_ignore_unknown")+1))
	    {
	         do_ignore_unknown = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_send_idle_time", strlen("do_send_idle_time")+1)) 
	    {
	         do_send_idle_time = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_raise_window", strlen("do_raise_window")+1)) 
	    {
	         do_raise_window = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_timestamp", strlen("do_timestamp")+1)) 
	    {
	         do_timestamp = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_online_sound", strlen("do_online_sound")+1)) 
	    {
	         do_online_sound = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_multi_line", strlen("do_multi_line")+1)) 
	    {
	         do_multi_line = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_ignore_fore", strlen("do_ignore_fore")+1)) 
	    {
	         do_ignore_fore = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_ignore_back", strlen("do_ignore_back")+1)) 
	    {
	         do_ignore_back = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_ignore_font", strlen("do_ignore_font")+1)) 
	    {
	         do_ignore_font = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_convo_timestamp", strlen("do_convo_timestamp")+1))
	    {
	         do_convo_timestamp = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_enter_send", strlen("do_enter_send")+1)) 
	    {
	         do_enter_send = atoi(val);
	    }
#ifdef HAVE_ICONV_H
	    else if(!g_strncasecmp(param, "use_recoding", strlen("use_recoding")+1)) 
	    {
	         use_recoding = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "local_encoding", strlen("local_encoding")+1)) 
	    {
	         strcpy(local_encoding, val);
	    }
	    else if(!g_strncasecmp(param, "remote_encoding", strlen("remote_encoding")+1)) 
	    {
	         strcpy(remote_encoding, val);
	    }
#endif
	    else if(!g_strncasecmp(param, "do_restore_last_conv", strlen("do_restore_last_conv")+1)) 
	    {
	         do_restore_last_conv = atoi(val);
	    }
/*	  	  else if(!g_strncasecmp(param, "use_typical_sound_method", strlen("use_typical_sound_method")+1)) 
	  	  {
	  	  use_typical_sound_method = atoi(val);
	  	  }
	  	  else if(!g_strncasecmp(param, "use_sounddevice", strlen("use_sounddevice")+1)) 
	  	  {
	  	  use_sounddevice = atoi(val);
	  	  }
*/
	    else if(!g_strncasecmp(param, "do_away_sound", strlen("do_away_sound")+1)) 
	    {
	         do_away_sound = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "do_no_sound_when_away", strlen("do_no_sound_when_away")+1)) 
	    {
	         do_no_sound_when_away = atoi(val);
	    }
 	  else if(!g_strncasecmp(param, "do_tabbed_chat", strlen("do_tabbed_chat")+1)) 
 	  {
 	       do_tabbed_chat = atoi(val);
	  }
          else if(!g_strncasecmp(param, "do_tabbed_chat_orient", strlen("do_tabbed_chat_orient")+1))
          {
            do_tabbed_chat_orient = atoi(val);
          }
	    else if(!g_strncasecmp(param, "BuddyArriveFilename", strlen("BuddyArriveFilename")+1)) 
	    {
	         strcpy(BuddyArriveFilename, val);
	    }
	    else if(!g_strncasecmp(param, "BuddyAwayFilename", strlen("BuddyAwayFilename")+1)) 
	    {
	         strcpy(BuddyAwayFilename, val);
	    }
	    else if(!g_strncasecmp(param, "BuddyLeaveFilename", strlen("BuddyLeaveFilename")+1)) 
	    {
	         strcpy(BuddyLeaveFilename, val);
	    }
	    else if(!g_strncasecmp(param, "SendFilename", strlen("SendFilename")+1)) 
	    {
	         strcpy(SendFilename, val);
	    }
	    else if(!g_strncasecmp(param, "RecieveFilename", strlen("RecieveFilename")+1)) 
	    {
	         strcpy(RecieveFilename, val);
	    }
	    else if(!g_strncasecmp(param, "FirstMsgFilename", strlen("FirstMsgFilename")+1)) 
	    {
	         strcpy(FirstMsgFilename, val);
	    }
	    else if(!g_strncasecmp(param, "SoundVolume", strlen("SoundVolume")+1)) 
	    {
        	 volume_sound = atof(val);
	    }
#ifdef HAVE_ISPELL
	    else if(!g_strncasecmp(param, "do_spell_checking", strlen("do_spell_checking")+1))
	    {
	         do_spell_checking = atoi(val);
	    }
#endif
	    else if(!g_strncasecmp(param, "use_alternate_browser", strlen("use_alternate_browser")+1)) 
	    {
	         use_alternate_browser = atoi(val);
	    }
	    else if(!g_strncasecmp(param, "alternate_browser", strlen("alternate_browser")+1)) 
	    {
	         strcpy(alternate_browser, val);
	    }
	    else if(!g_strncasecmp(param, "accel_next_tab", strlen("accel_next_tab")+1)) 
	    {
			 gtk_accelerator_parse(val, &accel_next_tab[0], (GdkModifierType *)&accel_next_tab[1]);
	    }
	    else if(!g_strncasecmp(param, "accel_prev_tab", strlen("accel_prev_tab")+1)) 
	    {
			 gtk_accelerator_parse(val, &accel_prev_tab[0], (GdkModifierType *)&accel_prev_tab[1]);
	    }
     }

     proxy_set_proxy(new_proxy_type, new_proxy_host, new_proxy_port);
     fclose(fp);
}

/*
 * Cancel button
 */
static void cancel_callback(GtkWidget * widget, gpointer data)
{
     GtkWidget * w = data;
     cancel_general_prefs();
     cancel_logs_prefs();
     cancel_chat_prefs();
     cancel_sound_prefs();
     cancel_connections_prefs();
     cancel_proxy_prefs();

     gtk_widget_destroy(w);
}

/*
 * Destroy prefs window
 */
static void destroy(GtkWidget * widget, gpointer data)
{
     destroy_connections();
     is_prefs_open = 0;
     destroy_proxy();
     destroy_general_prefs();
#ifdef HAVE_ICONV_H
     destroy_encodings();
#endif
	
     /* it'd be nice to check validity of recoding here 
	and cancel change if not supported */

#ifdef HAVE_ISPELL
     if ((!do_spell_checking) && (gtkspell_running()))
	     gtkspell_stop();
#endif

     write_prefs();
}
