/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_snapshots.h
 */ 

#ifndef _LVM_SNAPSHOTS_H_
#define _LVM_SNAPSHOTS_H_ 1

// Functions exported from lvm_snapshots.c
extern int lvm_create_snapshot_volume(	lvm_logical_volume_t	* snap_volume,
					lvm_logical_volume_t	* org_volume );
extern int lvm_delete_snapshot_volume( lvm_logical_volume_t * snap_volume );
extern int lvm_count_snapshot_volumes( lvm_volume_group_t * group );
extern int lvm_update_snapshot_stats( lvm_logical_volume_t * volume );
extern int lvm_link_snapshot_volumes( lvm_volume_group_t * group );

#endif

