/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_io.h
 */ 

#ifndef _MD_IO_H_
#define _MD_IO_H_ 1

// Functions exported from md_io.c
int md_region_rw(storage_object_t *region,
		 lsn_t lsn,
		 sector_count_t count,
		 void *buffer,
		 int rw);

int md_ioctl_flush_buffer_cache(storage_object_t *obj);
int md_ioctl_start_array(storage_object_t *region, int dev_major, int dev_minor);
int md_ioctl_stop_array(storage_object_t *region);
int md_ioctl_run_array(storage_object_t *region);
int md_ioctl_get_disk_info(storage_object_t *region, mdu_disk_info_t* disk_info);
int md_ioctl_get_array_info(storage_object_t *region, mdu_array_info_t* info);
int md_ioctl_set_array_info(storage_object_t *region, mdu_array_info_t* info);
int md_ioctl_add_new_disk(storage_object_t *region, mdu_disk_info_t* disk_info);
int md_ioctl_get_blk_size(storage_object_t *region, u_int64_t *size);
int md_ioctl_hot_add_disk(storage_object_t *region, int kdev);
int md_ioctl_hot_remove_disk(storage_object_t *region, int kdev);
int md_ioctl_set_disk_faulty(storage_object_t *region, int kdev);

#endif

