/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM2 Plugin
 * File: evms2/engine/plugins/lvm2/objects.h
 */

/**
 * Routines exported from objects.c
 **/
extern pv_data_t *find_pv_by_index(storage_container_t *container,
				   u_int32_t pv_index);
extern storage_object_t *find_pv_by_name(storage_container_t *container,
					 char *name);
extern void adjust_pv_indexes(storage_container_t *container);
extern int allocate_pe_map(pv_data_t *pv_data);
extern int allocate_pv_data(storage_object_t *object,
			    list_anchor_t metadata_locations,
			    key_value_t *vgda_tree, char *uuid,
			    u_int64_t label_sector, u_int32_t pv_index,
			    u_int64_t pe_start, u_int64_t pe_count,
			    unsigned long flags);
extern void deallocate_pv_data(storage_object_t *object);
extern int discover_pv_objects(list_anchor_t input_objects,
			       list_anchor_t pv_list);
extern int commit_new_pvs(storage_container_t *container, boolean backup);
extern int commit_resized_pvs(storage_container_t *container);
extern int create_new_pv(storage_object_t *object,
			 storage_container_t *container);
extern boolean extent_is_available(physical_extent_t *pe);
extern u_int64_t count_available_extents_in_pv(storage_object_t *object);
extern u_int64_t count_available_extents_in_pvs(list_anchor_t objects);
extern u_int32_t count_available_pvs(list_anchor_t objects);
extern list_anchor_t pv_names_to_list(value_list_t *pv_names,
				      storage_container_t *container);
extern int create_missing_pvs(storage_container_t *container);
extern int get_available_objects(storage_container_t *container,
				 list_anchor_t *objects);
extern u_int64_t max_consecutive_extents_on_object(storage_object_t *object);
extern u_int64_t consecutive_extents_at_pe(pv_data_t *pv_data,
					   u_int64_t pe_index);

