/************************************************************* 
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 *
*************************************************************/

/*************************************************************
*
*  File:  proto.h
*
*  Purpose: ANSI function prototypes.
*/


#ifndef drand48
 extern double drand48(void); /* may not be in header file */
#endif
void break_check(void);
int lagrange_facet_normal (vertex_id,facet_id,REAL**);
void test_axial_points( facet_id );
int compare_edge_attr(edge_id, edge_id);
void set_body_volume(body_id,REAL);
void set_body(element_id,element_id);
int kb_yylex(void);
char *my_fgets(char *,int,FILE *stream);
int method_check(void);
void renumber_all(void);
void reorder_storage(void);
int identtype(char*);
REAL kb_drand(void);
void  kb_initr(int); 
void dump_macros(void);
void move_to_free_front(int,int);
void calc_all_grads(int);
void check_pinning(void);
void convert_forms_to_vectors(int);
void clear_v_conmap(element_id );
void list_attributes(void);
void reset_rot_order(void);
void start_logfile(char*);
void stop_logfile(void);
void one_sided_adjust(int);
void calc_leftside(void);
void load_library(char *);
void unload_libraries(void);
dll_func_type search_libraries(char*);
REAL get_internal_variable(int );
void check_element_type ( int, int );
int read_pick(void);
int count_fixed_vol(void);
int oid(element_id);
void flip_toggle(int*,int,char*);
int gram_schmidt(REAL**,int,int);
int new_vertex_average(vertex_id,int);
void keyword_help(char *);
void error_help(char *);
void write_to_console(char *);
void read_line_from_console(char *);
int do_edgeswap(edge_id);
void apply_h_inverse_metric(void);
void list_proc(int,int);
void list_procedures(void);
void linear_to_lagrange(int);
void quad_to_lagrange(int);
void lagrange_to_linear(void);
void lagrange_to_quad(void);
void sparse_permute(struct linsys *);
void do_tree_factor(struct linsys *);
void do_tree_solve(struct linsys *,REAL *,REAL*);
int find_method_instance(char*);
int find_quantity(char*);
void reconvert_bodies_to_quantities(void);
int string_rebody(void);
void  lagrange_to_lagrange(int);
void  simplex_lagrange_to_lagrange(int);
void metis_partition(int,int);
void metis_partition_dual(int,int);
void metis_order(struct linsys *);
void metis_vertex_order(int);
int lagrange_index(int,int,int*);
int increment_lagrange_index(int,int*);
void gauss_lagrange_setup(int,int,int);
void det_hess(REAL **,REAL ****,int );
int simplex_delete_facet(facet_id);
int simplex_delete_edge(vertex_id,vertex_id);
void write_hessian(struct linsys *);
REAL gravity_all ARGS((struct qinfo *,int));
void  LQ_decomp ARGS((REAL**,int,int,REAL**,REAL**,struct linsys *));
void q_info_free(struct qinfo *);
void q_info_init(struct qinfo *,int);
void make_el_list(int);
int Ord(element_id);
void toggle_save(char*);
void toggle_save_off(char*);
int get_meth_offset(int);
int get_v_constraint_status(element_id,int);
int v_hit_constraint_count(vertex_id);
void hess_hash_expand(void);
void hess_hash_init(void);
REAL square_grad(void);
void cg_ritz(struct linsys *,int,REAL**,REAL*);
void hess_hash_sort(int,int*,struct hess_entry **);
int check_pick(void);
void read_extra(element_id);
int simplex_quadrature(int,int,int,REAL**,REAL*);
int eartest(vertex_id,vertex_id);
void convert_string(char*,char*);
void hess_hash_end(void);
void hessian_legal(void);
void reset_quant_bits(void);
void check_one_sided_constraints(void);
void set_v_global(vertex_id);
void set_v_conmap(vertex_id,conmap_t*);
void set_e_conmap(edge_id,conmap_t*);
void set_f_conmap(facet_id,conmap_t*);
void set_v_constraint_map(vertex_id,int);
void unset_v_constraint_map(vertex_id,int);
void set_v_constraint_status(vertex_id,int);
void unset_v_constraint_status(vertex_id,int);
void clear_v_constraint_status(vertex_id);
void set_e_constraint_map(edge_id,int);
void unset_e_constraint_map(edge_id,int);
void set_f_constraint_map(facet_id,int);
void unset_f_constraint_map(facet_id,int);
int v_on_constraint(vertex_id,int);
int e_on_constraint(edge_id,int);
int f_on_constraint(facet_id,int);
void get_v_common_conmap(vertex_id,vertex_id,conmap_t *);

int simplex_tiny_edges(REAL);
int simplex_delete_edge(vertex_id,vertex_id);
int get_tag(facet_id);
void set_tag(facet_id,int);
void ritz_command(REAL,int);
void do_ritz(struct linsys *,REAL,int,REAL **);
void print_hessian_menu(void);
void expand_attribute(int,int,int);
int edgeswap( edge_id);
REAL sparse_metric_dot(REAL*,REAL*,struct linsys *);
void gauss_jacobi(int, REAL , REAL *, REAL *);
void jacobi_eigenpairs( REAL **, int, REAL *, REAL **);
void star_metric_setup( int, struct linsys *);
void linear_metric_setup(  int, struct linsys *);
void linear_metric_setup_quadratic( int, struct linsys *);
void linear_metric_setup_lagrange( int, struct linsys *);
REAL get_vertex_length_star(vertex_id);
REAL get_vertex_area_star(vertex_id);
void convert_to_quantities(void);
void convert_body_to_quantity(body_id);
void long_jiggle(void);
void free_system(struct linsys *);
int simplex_long_edges(REAL);
void lanczos_command(REAL,int);
void eigenprobe_command(REAL,int);
void myfree(char *);
void option_facet(struct graphdata*,facet_id); 
void geomview_command(char*);
void surfen_hess(void);
void newton_ysmp(struct hess_index *,REAL *,int,int,int,struct hess_index *);
void ysmp_numeric_factor(void);
void newton_ysmp_solve(struct hess_index *,REAL *,REAL *,int,int,int,
        struct hess_index *, REAL *,int);
void newton_ysmp_factor(struct hess_index *,REAL *,int,int,int,
        struct hess_index *);
void AIJ_setup(struct hess_index *,REAL *,int,int,int,
        struct hess_index *);
void hessian_exit(REAL *);
void hessian_cleanup(void);
void hessian_solve(void); 
void hessian_downhill(void); 
void hessian_move(REAL,int,REAL *);
int  lanczos(struct linsys*,int,REAL*,int);
int  selective_lanczos(struct linsys*,int,REAL*,int);
void tridiag_QL(REAL*,REAL*,int);
void intersect_detect(void);
void bk_mul(struct linsys *, REAL*,REAL*);
void bk_AIJ_setup(struct hess_index*,int,struct linsys*);
void bk_eigenprobe(struct linsys *);
void bk_inverse_it(struct linsys *, REAL *);
void sp_hessian_solve(struct linsys *,REAL *, REAL *,int);
void sp_hessian_solve_multi(struct linsys *,REAL **, REAL **,int);
void sp_Hessian_solver(struct linsys *, REAL *, REAL *);
void bk_constraint_setup(struct hess_index *,int, struct linsys *);
void BK_hess_project_setup(struct linsys *);
void xmd_factor(struct linsys *);
void xmd_solve(struct linsys *,REAL *,REAL *);
void xmd_solve_multi(struct linsys *,REAL **,REAL **,int);
void tree_factor(struct linsys *);
void tree_solve(struct linsys *,REAL *,REAL *);
void tree_solve_multi(struct linsys *,REAL **,REAL **,int);
void ysmp_factor(struct linsys *);
void ysmp_solve(struct linsys *,REAL *,REAL *);
void ysmp_solve_multi(struct linsys *,REAL **,REAL **,int);
void find_ordering(struct hess_verlist *,int,int *);
void hessian_saddle(REAL);
REAL lowest_eigenpair(struct linsys *,REAL *);
REAL cg_lowest_eigenpair(struct linsys *,REAL *);
REAL old_cg_lowest_eigenpair(struct linsys *,REAL *);
REAL new_cg_lowest_eigenpair(struct linsys *,REAL *);
element_id get_ordinal_id(int,int);
int project_all(int,int);
void CC_setup(int,struct hess_index *);
void CC_end(void);
void chebychev_hess(struct linsys *);
void chebychev_ev(struct linsys *);
void fill_self_entry(vertex_id,REAL**);
void fill_grad(struct hess_verlist *,REAL*,REAL *);
int add_attribute(int,char*,int,int,int,struct expnode *);
int find_attribute(int,char*);
char *get_extra(element_id,int);
int find_extra(char *, int *);
int matrix_index(REAL**,int);
void exec_commands(void);
void push_fd(FILE *,char *);
void pop_fd(void);
facet_id get_vertex_facet(vertex_id);
void macro_init(void);
REAL ** mat2d_setup(REAL**,REAL*,int,int);
REAL *** mat3d_setup(REAL***,REAL*,int,int,int);
REAL **** mat4d_setup(REAL****,REAL*,int,int,int,int);
void zerohess(struct qinfo *);
void get_facet_normal(facet_id,REAL*);
int get_toggle_value(int);
REAL user_attribute(element_id);
void force_normalization(void);
void insert_vertex_edge(vertex_id,edge_id);
void remove_vertex_edge(vertex_id,edge_id);
void catfulltext(char*);
int identcase(void);
int eliminate_facet(facet_id);
REAL quantity_attribute( element_id, int );
REAL instance_attribute( element_id, int );
int kb_checksum(char *,int);
void apply_quantity(element_id,int);
void unapply_quantity(element_id,int);
void read_instance_attr( int );
void read_named_quantity(void);
DY_OFFSET dy_calloc(int,int);
DY_OFFSET dy_realloc(DY_OFFSET,int,int);
void dy_free(DY_OFFSET);
void dump_method_specs( int );
void read_method_attr( int );
void calc_periods(int);
void read_method_instance(void);
void add_standard_quantity(char *,REAL);
int new_method_instance(char*,char*);
int attach_method( int, char *);
void apply_method( element_id , char *);
void apply_method_num( element_id , int);
void unapply_method( element_id , int);
int rebody(void);
int get_body_valence(body_id );
int get_vertex_evalence(vertex_id );
int get_vertex_fvalence(vertex_id );
void make_vfacet_lists(void);
void make_bfacet_lists(void);
void make_vedge_lists(void);
REAL dirichlet(int);
REAL sobolev(int);
int unstar(facetedge_id);
void reduce_string(char *); 
REAL vertex_angle(vertex_id);
void fix_ctm(REAL,REAL);
void my_exit(int);
int dissolve_vertex(vertex_id);
int dissolve_edge(edge_id);
int dissolve_facet(facet_id);
int dissolve_body(body_id);
REAL vertex_sq_mean_curvature(vertex_id);
void burchard(int);
void do_gfile(int,char*);
int mat_simplify(REAL***,int);
void transform_gen_expr(char *);
void generate_transforms(int);
void read_transform_generators(int);
int const_expr(char *,REAL *);
REAL wedge_angle(vertex_id);
void begin_normal_motion(void);
void end_normal_motion(void);
REAL gray_level(float *);
void  metric_form_to_vector(REAL*,REAL*);
void end_geomview_object(void);
void calc_quant_grads(int);
int simplex_element_id_edges(REAL);
void quantity_init(void); 
int new_quantity(char *,int);
void add_quantity(element_id,char*,char*);
REAL calc_quants(int); 
void graph_edge_transforms( struct graphdata *, edge_id );
void graph_facet_transforms( struct graphdata *, facet_id );
REAL * other_stuff(struct treenode *,REAL *,int*,int*,element_id,REAL*);
REAL * more_other_stuff(struct treenode *,REAL *,int*,int*,element_id);
void ask_wrap_display(void);
void print_attr( struct treenode *, char *);
void print_set_attr( struct treenode *, char *);
void set_print(struct treenode *, char *, char *,int);
void binary_print( struct treenode *, int, int, char *, int);
int lookup_global(char*);
void klein_area_grad(REAL **,REAL**);
REAL klein_area(REAL**);
void klein_length_grad(REAL*,REAL*,REAL*,REAL*);
REAL klein_length(REAL*,REAL*);
void  geomview_start(void);
void  geomview_facet(struct graphdata *, facet_id);
void  geomview_edge(struct graphdata *, edge_id);
void  geomview_end(void);
void tree_copy( struct expnode *, struct treenode *);
void conf_edge_curv_energy(void);
void conf_edge_curv_force(void);
REAL dihedral(edge_id);
void clear_symtable(void);
void clear_globals(void);
int add_global(char *);
char *keywordname(int);
void subtree_swap(int*,int*);
int begin_scope(void);
void end_scope(void);
void set_scope(int);
struct sym * symbol_add(char*,int);
struct sym *symbol_lookup(char*);
vertex_id void_test(vertex_id *,int);
char *tokname(int);
void update_aggr(int ,REAL *,REAL );
void hessian_init(REAL **,REAL **);
void hessian_fill(REAL *);
void hess_hash_search(int,int,REAL);
void find_hess_entry( struct hess_verlist*,
                 struct hess_entry *[MAXCOORD][MAXCOORD]);
void fill_hess_entry( vertex_id,REAL**);
int find_mixed_entry( struct hess_verlist* ,struct hess_verlist* , 
                 struct hess_entry *[MAXCOORD][MAXCOORD]);
void fill_mixed_entry( vertex_id,vertex_id, REAL **); 
int find_hess_entries( struct hess_verlist*,struct hess_verlist*, 
        struct hess_entry *[MAXCOORD][MAXCOORD],
        struct hess_entry *[MAXCOORD][MAXCOORD],
        struct hess_entry *[MAXCOORD][MAXCOORD]);

void area_hessian(REAL *);
void calc_quant_hess(int,int,REAL *);
void m_calc_quant_hess(int,int,REAL *);
void m_fix_hess(void);
void difference_hessian(struct hess_verlist*,REAL *);
void edge_energy_hessian(REAL *);
void simplex_hessian(REAL *);
void simplex_facet_hessian(REAL *);
void simplex_edge_hessian(edge_id,REAL**,REAL****);
void edge_constr_hessian(edge_id,REAL**,REAL****);
int body_hessian(REAL*);
void tree_exec( struct treenode *);
void letter_command(int);
void pop_commandfd(void);
void push_commandfd(FILE*,char*);
void pop_datafd(void);
void push_datafd(FILE*,char*);
void exec_file(FILE*,char*);
void unput_tok(void);
void unput_string(char*);
void set_f_phase_density(facet_id);
void set_e_phase_density(edge_id);
int bdry_basis(vertex_id,REAL**);
int constr_basis(vertex_id,REAL**);
void  sp_order(int,int*,int*,int*,int*);
int  sp_fill_setup(int,int*,int*,int*,int*,int*);
void  sp_factor(int,int*,int*,int*,int*,int*,REAL*,REAL*);
void  sp_backsub(int,int*,int*,int*,REAL*,REAL*,REAL*);
void stability_test(void);
void mobility_cleanup(void);
void mobility_mult(REAL*);
void mobility_setup(void);
void approx_curv_calc(int);
void approx_curvature(void);
int new_popverst(vertex_id,int);
void phase_initialize(char *);
void check_vertex_fe(vertex_id);
void information(void);
void show_volumes(void);
int set_parameters(void);
int minus_type(int);
void string_fixup(void);
void runge_kutta(void);
void autopop_pop(void);
void autochop_chop(void);
void autopop_detect(REAL);
vertex_id find_other_vertex(vertex_id *,int,vertex_id);
void simplex_delaunay_test(void);
void push_face(vertex_id *);
int pop_face(vertex_id *);
void end_face_stack(void);
void init_face_stack(int);
int simplex_equiangulate(void);
void calc_simplex_edge_force(edge_id);
int kernel_basis(REAL**,REAL**,int,int);
int kernel_basis_rows(REAL**,REAL**,int,int);
void tr_mat_mul(REAL**,REAL**,REAL**,int,int,int);
void mat_mul_tr(REAL**,REAL**,REAL**,int,int,int);
void  mat_tsquare(REAL**,REAL**,int,int);
void calc_simplex_edge_energy(edge_id);
void exterior_product(REAL **,REAL *,int,int);
int binom_coeff(int,int);
void hi_dim_graph(void);
void recalc(void);
void reset_conj_grad(void);
void kusner_energy(void);
void kusner_force(void);
void sqgauss_energy(void);
void sqgauss_force(void);
int prompt(char*,char*,int);
void NeXT_display(void);
void update_display(void);
void set_spinr(REAL);
void set_spinl(REAL);
void set_tipup(REAL);
void set_tipdown(REAL);
void set_clockwise(REAL);
void set_counterclockwise(REAL);
void set_zoom(REAL);
void skinny_histogram(void);
int skinny(REAL);
int get_edge_valence(edge_id);
int get_facet_valence(edge_id);
void alice(void);
void sqcurve_force_string(vertex_id);
void sqcurve_force_string_end(void);
void sqcurve_energy_string(vertex_id);
void sqcurve_energy_string_init(void);
void bad_function(void);
void sqcurve_force_init(void);
void sqcurve_energy_init(void);
void sqcurve_energy(vertex_id*, REAL (*)[MAXCOORD]); 
void sqcurve_force(vertex_id*,edge_id*,REAL(*)[MAXCOORD]); 
void sqcurve_energy_end(void);
void sqcurve_force_end(void);
void top_dump(FILE *);
void bottom_dump(FILE *);
void vertex_dump(vertex_id,FILE *);
void edge_dump(edge_id,FILE *);
void facet_dump(facet_id,FILE *);
void facetedge_dump(facetedge_id,FILE *);
void body_dump(body_id,FILE *);
WRAPTYPE torus_inverse(WRAPTYPE);
WRAPTYPE torus_compose(WRAPTYPE,WRAPTYPE);
void torus_wrap(REAL *,REAL *,WRAPTYPE);
void torus_form_pullback(REAL *,REAL *,REAL *,WRAPTYPE);
WRAPTYPE group_inverse(WRAPTYPE);
WRAPTYPE group_compose(WRAPTYPE,WRAPTYPE);
void group_wrap(REAL *,REAL *,WRAPTYPE);
void group_form_pullback(REAL *,REAL *,REAL *,WRAPTYPE);
void print_matrix( REAL **, int , int );
REAL simplex_energy_metric(vertex_id*,REAL * *);
void simplex_force_metric(vertex_id *,REAL**, REAL,REAL **);
void gauss_setup(void);
void simplex_grad_l(void);
void end_hash_table(void);
void rehash(void);
void init_hash_table(void);
void check_orientation(struct simplex *,int);
void refine_simplex_init(void);
void refine_simplex(int,int *,struct divedge *,struct simplex *);
void refine_all_simplices(void);
vertex_id simplex_edge_divide(vertex_id,vertex_id);
int poponest(vertex_id,int);
void free_discards(void);
int find_vertex_to_pop(void);
void puff(void);
REAL splinepoly(int,REAL);
REAL splinederiv(int,REAL);
void spline_partial(int *,REAL,int,REAL *);
void spline_partial_t(int *,REAL,REAL *);
void dump_buff(char*,int);
int  command(char *);
void newcommand(char *);
void new_history(char *);
void old_history(char *);
int  qqparse(void);
#ifdef MEMSTRINGS
char *kb_calloc(int,int,char*,int);
char *KB_realloc(char*,int,int,char*,int);
#else
char *kb_calloc(int,int);
char *KB_realloc(char*,int,int);
#endif
char *temp_calloc(int,int);
char * temp_realloc(char*,int,int);
void temp_free(char *);
void temp_free_all(void);
void cg_direction(void);
void cg_calc_gamma(void);
void simplex_facet_average(facet_id,int);
void facet_average(facet_id,int);
void edge_average(edge_id,int);
void recalc_verts(void);
void grule(int , REAL *, REAL *);
void read_facet_edges(void);
void read_faces(void);
void read_edges(void);
void read_vertices(void);
void read_bodies(void);
void read_quantity(void);
int read_const(REAL *);
void lowbound(void);
void ridge_histogram(void);
int collapse_check(void);
#ifndef TCPP
int vvvvcomp(struct vvvv *,struct vvvv *);
#endif
void End_OOGL(void );
void End_geomview(void );
void UpdateOOGL(void );
void Begin_OOGL(void );
void Begin_geomview(char*);
void softimage(void );
void constraint_init(struct constraint *);
void constraint_free(struct constraint *);

REAL find_flux(facet_id);
int is_constant(int);
void free_expr(struct expnode *);
void startup(char *);
void reset_view(void);
void read_parameter(void);
void read_transforms(int);
void zoom_vertex(vertex_id,REAL);
REAL distance(vertex_id,vertex_id);
void merge_collapsed_facets(void);
void constr_vol_grad_q(edge_id);
void homothety(void);
void ex_fold(struct treenode *);
void fold_recur(struct treenode *, int *);
int yybegin(void);
void yylex_init(void);
int yyerror(char *);
int yyparse(void);
int  yylook(void);
int  yywrap(void);
int yylex(void);
int yyreject(void);
int gettok(int);
int  kb_input(void);
void rawunput(int);
int  macro(void);
void record_macro(void);
void fe_reorder(element_id);
void pix_start(void);
void pix_facet(struct graphdata *,facet_id);
void pix_end(void);
void constr_edge_force_q(edge_id);
void restore_vertex(vertex_id,struct oldcoord *);
REAL normal_change_check(void);
FILE *path_open(char *);
void fil_finish(void);
void fil_facet(struct tsort *);
void fil_edge(struct tsort *);
void fil_init(void);
void ps_finish(void);
void ps_facet(struct tsort *);
void ps_edge(struct tsort *);
void ps_init(void);
void display_file(int);
void graph_help(void);
void main_help(void);
REAL edge_grav_density(edge_id);
int facet_body_check(void);
int facetedge_check(int);
int list_check(void);
int run_checks(void);
int pop_vertex(vertex_id,int);
int popfilm(void);
void face_triangulate(facet_id,int);
void file_wulff(REAL *,REAL *);
void lens_wulff(REAL *,REAL *);
void hemi_wulff(REAL *,REAL *);
int curtest_facet(facet_id);
int curtest_edge(edge_id,facetedge_id,facetedge_id);
void curtest(void);
void fix_volconst(void);
element_id upgrade(element_id);
facet_id dup_facet(facet_id);
body_id dup_body(body_id);
REAL estimate_decrease(void);
void constr_edge_content_q(edge_id);
void constr_edge_energy_q(edge_id);
void tordup(int);
void add_outside(void);
REAL calc_content(int);
int equal_constr(element_id ,element_id) ;
void bdry_spring_energy(edge_id);
void constr_spring_energy(edge_id);
int boundary_pull_film(void);
void torus_cells(void);
void torus_edge_clip(struct graphdata *,int );                          
void null_function(void);
void diffuse(void);
int cone_analyze(struct verfacet *,int);
vertex_id dup_vertex(vertex_id);
edge_id dup_edge(edge_id);
void versplit(facetedge_id ,facetedge_id) ;
int try_prop(facetedge_id *, facetedge_id);
int edgepop_film(void);
char * print_express(struct expnode *,int);
void exprint_recur(struct treenode *,int);
char *kb_strstr(char *,char *);
int kb_stricmp(char *,char *);
int kb_strnicmp(char *,char *, int);
void kb_memmove(char *,char *,int);
int pixdump(void);
void constr_springs(edge_id);
void save_coords(struct oldcoord *);
void restore_coords(struct oldcoord *);
void unsave_coords(struct oldcoord *);
void enforce_constraints(void);
void kb_strupr(char *);
void b_proj(struct boundary *,REAL *,REAL * *,int, vertex_id );
void b_extrapolate(struct boundary *,REAL *,REAL *,REAL *,REAL *,REAL *,vertex_id);
void bdry_force(element_id );
void calc_bdry_force_v(element_id );
void calc_bdry_force_e(element_id );
void calc_bdry_energy_v(element_id );
void calc_bdry_energy_e(element_id );
void calc_bdry_content_v(element_id );
void calc_bdry_content_e(element_id );
void calc_force(void );
void calc_energy(void);
void calc_pressure(void );
void display(void );
int constr_proj(int ,int ,struct constraint * *,REAL *,REAL *,REAL *,int *,int,vertex_id);
int project_v_constr(element_id,int );
void calc_constr_force_v(element_id );
void calc_constr_force_e(element_id );
void calc_constr_energy_v(element_id );
void calc_constr_energy_e(element_id );
void calc_constr_content_v(element_id );
void calc_constr_content_e(element_id );
void dump(void );
void do_dump(char *);
REAL eval(struct expnode *,REAL *,element_id);
void eval_all(struct expnode *,REAL *,int,REAL *,REAL *,element_id);
void eval_second(struct expnode *,REAL *,int,REAL *,REAL *,REAL**,element_id);
REAL tree_eval(struct treenode *,REAL *);
REAL eval_deriv(struct expnode *,REAL *,int );
REAL tree_eval_deriv(struct treenode *,REAL *,int );
int exparse(int ,struct expnode *,int);
void calc_simplex_forces(facet_id);
void calc_simplex_energy(facet_id);
void calc_simplex_volume(facet_id);
void facet_force_l(element_id );
void facet_energy_l(element_id);
void facet_force_l_hi_d(element_id );
void facet_energy_l_hi_d(element_id);
void facet_volume_l(element_id );
void film_grad_l(void );
void film_bdry_grad(void );
void film_constr_grad(void );
void facet_force_q(element_id );
void facet_energy_q(element_id );
void facet_volume_q(element_id );
void film_grad_q(void );
REAL tq7_integral(REAL (*)(REAL,REAL));
REAL intpoly6(int ,REAL ,REAL );
REAL intpoly6part(int ,int ,REAL ,REAL );
REAL vintzf(REAL ,REAL );
void vcoeff_init(void );
void calc_volgrads(int);
void pressure_forces(void);
void calc_lagrange(void);
void lagrange_adjust(void);
void volume_restore(REAL,int);
int graphgen(void );
void plain_facets(void );
void plain_edges(void );
void bare_edges(void );
void triple_edges(void );
void torus_clip(struct graphdata *,int, facet_id );
int bfcomp(struct bodyface *,struct bodyface *);
void torus_bodies(void );
void reset_web(void );
void initialize(void);
void read_periods(void );
void wulff_initialize(char *);
void read_boundary(void);
void read_constraint(void);
void read_surface_energy(void);
void iterate(void );
void fix_vertices(void );
int move_vertices(int,REAL );
void jiggle(void );
void element_id_jiggle(void );
REAL gaussian(void );
void nrerror(char *);
void matcopy(REAL * *,REAL * *,int ,int );
#ifdef MEMSTRINGS
REAL * *kb_dmatrix(int ,int ,int ,int,char*,int );
REAL * * * kb_dmatrix3(int ,int ,int,char*,int );
REAL * * * * kb_dmatrix4(int ,int ,int, int,char*,int );
#else
REAL * *kb_dmatrix(int ,int ,int ,int );
REAL * * * kb_dmatrix3(int ,int ,int );
REAL * * * * kb_dmatrix4(int ,int ,int, int );
#endif
int *ivector(int ,int );
REAL *vector(int ,int );
void free_ivector(int *,int ,int );
void free_vector(REAL *,int ,int );
void free_matrix(REAL * *);
void free_matrix3(REAL * * *);
void free_matrix4(REAL * * * *);
void vector_add(REAL*,REAL*,int);
void vector_add_smul(REAL*,REAL*,REAL,int);
void vector_sub(REAL*,REAL*,int);
void vnormal(REAL *,REAL *,REAL *,REAL *);
void cross_prod(REAL *,REAL *,REAL *);
REAL triple_prod(REAL *,REAL *,REAL *);
REAL dot(REAL *,REAL *,int );
REAL dotf(float *,float *,int );
REAL dotdf(REAL *,float *,int );
void matvec_mul(REAL * *,REAL *,REAL *,int ,int );
void vec_mat_mul(REAL *,REAL ** ,REAL *,int ,int );
void mat_mult(REAL * *,REAL * *,REAL * *,int ,int ,int );
REAL quadratic_form(REAL *,REAL **,REAL *,int);
int  mat_inv(REAL * *,int );
REAL  determinant(REAL * *,int );
REAL  det_adjoint(REAL * *,int );
void change_model(void );
void linear_to_quad(void );
void quad_to_linear(void );
void edge_divide(element_id );
void cross_cut(element_id ,element_id );
void display(void);
void painter_start(void );
void painter_facet(struct graphdata *,element_id );
void painter_end(void );
int in_back(struct tsort *,struct tsort *);
int separating_plane(struct tsort *,struct tsort *,int);
int separating_line(struct tsort *,struct tsort *);
void painter_edge(struct graphdata *,edge_id);
int verpop_film(void );
void do_save(void );
void do_restore(void );
void set_fe_edge(element_id ,element_id );
void set_fe_facet(element_id ,element_id );
element_id get_fe_facet(element_id );
element_id get_prev_facet(element_id );
element_id get_next_facet(element_id );
void set_prev_edge(element_id ,element_id );
void set_next_edge(element_id ,element_id );
void set_prev_facet(element_id ,element_id );
void set_next_facet(element_id ,element_id );
void set_edge_wrap(element_id ,WRAPTYPE  );
WRAPTYPE get_edge_wrap(element_id );
void set_edge_fe(element_id ,element_id );
element_id get_edge_fe(element_id );
void set_edge_tailv(element_id ,element_id );
void set_edge_headv(element_id ,element_id );
void set_edge_midv(element_id ,element_id );
element_id get_facet_body(element_id );
void set_facet_body(element_id ,element_id );
element_id get_facet_fe(element_id );
void set_facet_fe(element_id ,element_id );
element_id new_vertex(REAL *,element_id);
element_id new_edge(element_id ,element_id,element_id );
element_id new_facet(void );
element_id new_body(void );
element_id new_facetedge(element_id ,element_id );
REAL get_edge_length(element_id );
REAL get_facet_pressure(element_id );
void generate_facet_fe_init(void );
int generate_facet_fe(element_id ,element_id *);
void generate_edge_fe_init(void );
int generate_edge_fe(element_id ,element_id *);
#ifndef elptr
struct element *elptr(element_id );
#endif
void extend(int );
void expand(int,int );
void unfree_element(element_id);
int generate_all(int ,element_id *);
void memory_report(void );
void reset_skeleton(void );
void vgrad_init(int );
void vgrad_end(void );
struct volgrad *get_vertex_vgrad(vertex_id);
struct volgrad *get_next_vgrad(struct volgrad *);
struct volgrad *new_vgrad(void );
struct volgrad *get_bv_vgrad(int ,element_id );
struct volgrad *get_bv_new_vgrad(int ,element_id );
element_id new_element(int,element_id );
void free_element(element_id );
int generate_all(int ,element_id *);
void memory_report(void );
void reset_skeleton(void );
void edge_force_l(element_id );
void edge_energy_l(element_id );
void edge_area_l(element_id );
void edge_force_l_metric(element_id );
void edge_energy_l_metric(element_id );
void edge_force_q_metric(element_id );
void edge_energy_q_metric(element_id );
void string_grad_l(void );
void string_bdry_grad(void );
void string_constr_grad(void );
REAL interpoly(int ,REAL );
REAL interpolyderiv(int ,REAL );
void scoeff_init(void );
void edge_force_q(element_id );
void edge_energy_q(element_id );
void edge_area_q(element_id );
void string_grad_q(void );
void do_show(void );
int  view_transform(char *);
void init_view(void );
void resize(void );
void old_menu(char * );
void extrapolate(void );
void save(void );
void restore(char *);
void torvol(void);
void torvol_project(int  );
void refine(void );
int areaweed(REAL );
void area_histogram(void );
int edgeweed(REAL );
void edge_histogram(void );
int eliminate_edge(element_id );
void change_vertex(element_id ,element_id ,element_id ,WRAPTYPE);
int articulate(REAL );
int edge_refine(element_id );
int equiangulate(void );
int ridge_notcher(REAL );
void outstring(char *);
void erroutstring(char *);
void getstring(char *,int);
void kb_error(int, char *,int );
void catcher(int );
void calc_edge(element_id );
void get_edge_side(element_id ,REAL *);
void get_adjust(element_id ,REAL *);
void get_edge_adjust(element_id ,REAL *);
REAL calc_vertex_normal(element_id,element_id ,REAL *);
void calc_vertex_smooth_normal(element_id,element_id ,REAL *);
int new_calc_vertex_normal(element_id,REAL **);
int simplex_vertex_normal(element_id,REAL **);
void get_edge_verts(element_id ,REAL * *,WRAPTYPE*);
void get_facet_verts(element_id ,REAL * *,WRAPTYPE*);
void get_facet_verts_special(element_id ,REAL * *,WRAPTYPE*);
void get_facet_verts_q(element_id ,REAL * *,WRAPTYPE*);
int verpop_str(void );
void dump_force(void);
void vertex_average(int);
void hessian_menu(void);
void hessian_auto(void);
REAL hessian_seek(REAL);
REAL hessian_line_seek(REAL,REAL*);

#ifdef NeXT0
void set_attr(element_id ,int );
void unset_attr(element_id ,int );
int makenode(int,int,int);
#else
void set_attr(element_id ,ATTR );
void unset_attr(element_id ,ATTR );
int makenode(NTYPE,NTYPE,NTYPE);
#endif

#ifdef PVM
void my_pvm_exit(void);
#endif

facet_id xget_next_vertex_facet(vertex_id,facet_id);
facet_id get_next_vertex_facet(vertex_id,facet_id);
void set_body_fixvol(body_id,REAL);
facet_id get_next_body_facet(facet_id);
void set_next_vertex_facet(vertex_id,facet_id,facet_id);
void set_next_body_facet(facet_id,facet_id);

#ifdef PARALLEL_MACHINE
/* some functions replaced by macros in serial version */
edge_id get_fe_edge(facetedge_id);
facetedge_id get_prev_edge(element_id );
facetedge_id get_next_edge(element_id );
vertex_id get_edge_tailv(element_id );
vertex_id get_edge_headv(element_id );
edge_id get_next_tail_edge(edge_id);
edge_id get_next_head_edge(edge_id);
void set_next_tail_edge(edge_id,edge_id);
facetedge_id get_body_fe(body_id);
void set_body_fe(body_id,facetedge_id);
REAL get_body_density(body_id);
REAL get_body_volume(body_id);
REAL get_body_fixvol(body_id);
REAL  get_body_pressure(body_id);
REAL get_body_volconst(body_id);
void set_body_volconst(body_id,REAL);
void set_body_density(body_id,REAL);
void set_body_pressure(body_id,REAL);
facetedge_id get_vertex_fe(vertex_id);
  
#endif

