#!/bin/sh
#set -vx
PATH="`dirname $0`/../src:$PATH"
[ $# -lt 1 ] && echo "usage: $0 <dev> [max size]" && exit 1
DEV=$1
if [ -b $DEV ]; then
	BASE=`basename $DEV`
	MAJ=`ls -l $DEV | tr "," " " | awk '{ print $5 }'`
	MIN=`ls -l $DEV | awk '{ print $6 }'`
	MAX=`awk "/$MAJ  *$MIN / { print \\$3 }" /proc/partitions`
elif [ -f $DEV ]; then
	MAX=`ls -s $BASE | awk '{ print $1 }'`
elif [ "$2" ]; then
	MAX=$2
else
	echo "Can't find size of $DEV.  You must specify max size"
	exit 1
fi
MIN=4096
SIZE=`dumpe2fs -h $DEV | awk '/^Block count/ { print $3 }'`
[ -z "$SIZE" ] && echo "No ext2 filesystem on $DEV.  Do 'mke2fs $DEV'" && exit 1
BLKSZ=`dumpe2fs -h $DEV | awk '/^Block size/ { print $3 }'`
BLKSZ=`expr $BLKSZ / 1024`
MAX=`expr $MAX / $BLKSZ`
RC=0
if [ "`mount | grep $DEV`" ]; then
	RESIZE=ext2online
	SUB=0
else
	RESIZE=ext2resize
	SUB=8192
fi
ELOG=e2fsck.log
DLOG=dumpe2fs.log
FLOG=testresize.log

echo "TEST: $RESIZE on $DEV [ min $MIN, current $SIZE, max $MAX ]"
echo "TEST: press <enter> to continue"
read JUNK

e2fsck -n -f $DEV > $ELOG 2>&1
RC=$?
[ $RC -ne 0 ] && cat $ELOG && echo "TEST: e2fsck exit with $RC"

while [ $RC -eq 0 ]; do
	NEWSIZE=`expr $SIZE + $RANDOM - $SUB`
	[ $NEWSIZE -le $MIN ] && NEWSIZE=$MIN && SUB=8192
	if [ $NEWSIZE -ge $MAX ]; then
		if [ "$RESIZE" = "ext2online" ]; then
			echo "TEST: maximum size reached for online resizing"
			exit 0
		fi
		NEWSIZE=$MAX && SUB=40960
	fi
	echo "TEST: resize from $SIZE to $NEWSIZE"
	$RESIZE -v -d $DEV $NEWSIZE 2>&1
	RC=$?
	if [ $RC -ne 0 ]; then
		echo "TEST: $RESIZE exited with $RC"
	else
		e2fsck -n -f $DEV > $ELOG 2>&1
		RC=$?
		[ $RC -ne 0 ] && cat $ELOG && echo "TEST: e2fsck exit with $RC"
	fi
	SIZE=$NEWSIZE
done | tee $FLOG

dumpe2fs $DEV > $DLOG
