/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

#include "IcePathDialog.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qpushbutton.h>

/////////////////////////////////////////////////////////////////////
// constructor & destructor
/////////////////////////////////////////////////////////////////////

IcePathDialog::IcePathDialog(QWidget * parent=0, const char * name=0, bool modal=false, WFlags f=0)
  : QDialog (parent, name, modal, f)
{
  QLabel* libLabel = new QLabel("Library Path",this);
  libEdit = new QLineEdit(customLibPath,this);
  QLabel* libText = new QLabel(" (Location of the IceWM Configuration Files)",this);
  QLabel* iconLabel = new QLabel("Icon Path",this);
  iconEdit = new QLineEdit(customIconPath,this);
  QLabel* iconText = new QLabel(" (Additional Path for Menu Icons. Overriding\n"
				" Settings in IceWM Preferences File)",this);

  QPushButton* ok = new QPushButton("Ok",this);
  ok->setMinimumWidth(85);
  QPushButton* cancel = new QPushButton("Cancel",this);
  cancel->setMinimumWidth(85);

  QVBoxLayout* mainLayout = new QVBoxLayout(this,2);
  QGridLayout* upperLayout = new QGridLayout(7,4,10); // 7 rows 4 coloumns 10pix spacing
  QGridLayout* lowerLayout = new QGridLayout(2,4,1);  // 2      4           2

  lowerLayout->addColSpacing(1,200);
  lowerLayout->addWidget(ok,1,2);
  lowerLayout->addWidget(cancel,1,3);
  lowerLayout->addColSpacing(4,7);
  lowerLayout->addRowSpacing(2,10);
  upperLayout->addRowSpacing(1,10);
  upperLayout->addWidget(libLabel,2,2);
  upperLayout->addWidget(libEdit,2,3);
  upperLayout->addWidget(libText,3,3);
  upperLayout->addRowSpacing(4,10);
  upperLayout->addWidget(iconLabel,5,2);
  upperLayout->addWidget(iconEdit,5,3);
  upperLayout->addWidget(iconText,6,3);
  upperLayout->addRowSpacing(7,15);
  upperLayout->addColSpacing(1,10);
  upperLayout->addColSpacing(4,10);
  mainLayout->addLayout(upperLayout,1);
  mainLayout->addLayout(lowerLayout,0);

  connect(ok,SIGNAL(clicked()),this,SLOT(accept()));
  connect(cancel,SIGNAL(clicked()),this,SLOT(reject())); 
}

IcePathDialog::~IcePathDialog()
{
  // Qt does the job
}

/////////////////////////////////////////////////////////////////////
// private static data
/////////////////////////////////////////////////////////////////////

QString IcePathDialog::customLibPath = 0; // static!
QString IcePathDialog::customIconPath = 0; // static!

/////////////////////////////////////////////////////////////////////
// public methods
/////////////////////////////////////////////////////////////////////

QString IcePathDialog::getCustomLibPath()
{
  return customLibPath;
}

QString IcePathDialog::getCustomIconPath()
{
  return customIconPath;
}

void IcePathDialog::clearCustomPaths() // static!
{
  customLibPath = "";
  customIconPath = "";
}

/////////////////////////////////////////////////////////////////////
// protected slots
/////////////////////////////////////////////////////////////////////

void IcePathDialog::accept() // virtual
{
  customLibPath = libEdit->text();
  customIconPath = iconEdit->text();
  QDialog::accept();
}
