package CParse::Op::Assign;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;
use CParse::Op::Assign::Multiply;
use CParse::Op::Assign::Divide;
use CParse::Op::Assign::Modulus;
use CParse::Op::Assign::Add;
use CParse::Op::Assign::Subtract;
use CParse::Op::Assign::ShiftLeft;
use CParse::Op::Assign::ShiftRight;
use CParse::Op::Assign::BitAnd;
use CParse::Op::Assign::BitXor;
use CParse::Op::Assign::BitOr;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $left = shift;
    my $right = shift;
    my $op = shift;

    return CParse::Op::Assign::Multiply->new($left, $right) if $op eq '*=';
    return CParse::Op::Assign::Divide->new($left, $right) if $op eq '/=';
    return CParse::Op::Assign::Modulus->new($left, $right) if $op eq '%=';
    return CParse::Op::Assign::Add->new($left, $right) if $op eq '+=';
    return CParse::Op::Assign::Subtract->new($left, $right) if $op eq '-=';
    return CParse::Op::Assign::ShiftLeft->new($left, $right) if $op eq '<<=';
    return CParse::Op::Assign::ShiftRight->new($left, $right) if $op eq '>>=';
    return CParse::Op::Assign::BitAnd->new($left, $right) if $op eq '&=';
    return CParse::Op::Assign::BitXor->new($left, $right) if $op eq '^=';
    return CParse::Op::Assign::BitOr->new($left, $right) if $op eq '|=';
    die unless $op eq '=';

    my $self = {left => $left,
                right => $right,
               };
    bless $self, $class;
    return $self;
  }

sub args
  {
    my $self = shift;
    return ($self->{left}, $self->{right});
  }

sub dump_c
  {
    my $self = shift;
    my $left = $self->{left}->dump_c;
    my $right = $self->{right}->dump_c;

    return "($left = $right)";
  }

1;
