/*
 * UserInfoDialog
 * Copyright (C) 2001 Barnaby Gray <barnaby@beedesign.co.uk>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef USERINFODIALOG_H
#define USERINFODIALOG_H

#include <gtk--/main.h>
#include <gtk--/dialog.h>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/label.h>
#include <gtk--/entry.h>
#include <gtk--/table.h>
#include <gtk--/notebook.h>
#include <gtk--/text.h>
#include <gtk--/combo.h>
#include <gtk--/spinbutton.h>

#include <sigc++/signal_system.h>

#include <libicq2000/Contact.h>
#include <libicq2000/events.h>

class UserInfoDialog : public Gtk::Dialog {
 private:
  Gtk::Button okay, cancel, fetchb, uploadb;
  Gtk::Entry uin_entry, alias_entry, firstname_entry, lastname_entry,
    email_entry1, email_entry2, email_entry3, ip_entry, status_entry, timezone_entry,
    addr_entry, phone_entry, state_entry, fax_entry, city_entry, cellular_entry,
    zip_entry, country_entry, age_entry, sex_entry, homepage_entry, birthday_entry,
    lang_entry1, lang_entry2, lang_entry3;

  Gtk::SpinButton birth_year_spin, birth_month_spin, birth_day_spin, age_spin;
  Gtk::Combo country_combo, lang_combo1, lang_combo2, lang_combo3, sex_combo;
  Gtk::Combo timezone_combo;
  Gtk::Text about_text;
  Gtk::Notebook notebook;

  Gtk::Entry stats_signon_time, stats_last_online, stats_last_status_change;
  Gtk::Entry stats_last_message, stats_last_away_msg_check;

  ICQ2000::ContactRef m_contact;
  bool m_changed;
  bool m_self;

  bool update_contact();
  void update_from_userinfo();

  static std::string format_time(time_t t);

 public:
  UserInfoDialog(Gtk::Window * parent, const ICQ2000::ContactRef& c, bool self = false);
  ~UserInfoDialog();

  // -- gui callbacks --
  void okay_cb();
  void upload_cb();

  // -- library callbacks --
  void status_change_cb(ICQ2000::StatusChangeEvent *ev);
  void userinfo_change_cb(ICQ2000::UserInfoChangeEvent *ev);

  void spin_changed_cb(Gtk::SpinButton* spin);

  void raise() const;

  bool isChanged() const;

  SigC::Signal0<void> fetch;
  SigC::Signal0<void> upload;
};

#endif
