/* icotool.h
 * 
 * Copyright (C) 1998-2001  Oskar Liljeblad
 *
 * This file is part of icoutils.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file "LICENSE" for
 * details.
 */

#include <config.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#include "support.h"
#include "../common/win32.h"

/*
 *
 * Global macros
 *
 */

/* PROGRAM:
 * The name of the primary executable file compiled from 
 * these source files.
 */
#define PROGRAM "icotool"

/* LINE_SIZE:
 * Return the number of bytes each line of an image with specified width
 * would use. The number of bytes is an multiple of four.
 */
#define LINE_SIZE(bits) ((((bits) + 31) >> 5) << 2)

/*
 *
 * Global type definitions: Structures and enumerations
 *
 */

typedef enum {
    FORMAT_INVALID = -1,
    FORMAT_XPM = 0,
    FORMAT_PPM = 1
} ImageFormat;

typedef enum {
    COMMAND_LIST,
    COMMAND_EXTRACT,
    COMMAND_CREATE
} IcoToolCommand;

typedef enum {
    RESOURCE_UNSPECIFIED = -1,
    RESOURCE_ICON = 0,
    RESOURCE_CURSOR = 1
} ResourceType;

typedef enum {
    IMAGEMODE_MASK,
    IMAGEMODE_IMAGE,
    IMAGEMODE_BOTH
} ImageMode;

typedef struct {
    char *name;
    uint8_t *contents;
    size_t size;
    ResourceType resource_type;
    Win32CursorIconFileDir *ci_dir;
} IconFile;

typedef struct {
    Win32CursorIconFileDirEntry *entry;
    Win32BitmapInfoHeader *bitmap;
    Win32RGBQuad *rgb_data;
    uint8_t *image_data;
    uint8_t *mask_data;
    int color_count;
    int image_line_width;
    int mask_line_width;
    bool flipped;
} IconImage;

/*
 *
 * Global variables
 *
 */

/* main.c */
extern int image_width;
extern int image_height;
extern int image_color_count;
extern ResourceType resource_type;
extern int resource_index;
extern int cursor_hotspot_x;
extern int cursor_hotspot_y;
extern ImageMode image_mode;

/*
 *
 * Global function declarations
 *
 */

/* readico.c */
bool initialize_icotool_file(IconFile *file);
bool initialize_icotool_icon(IconFile *file, int index, IconImage *icon);
int get_bitmap_image_pixel(IconImage *icon, int x, int y);
int get_bitmap_mask_pixel(IconImage *icon, int x, int y);
void print_icotool_icon(IconFile *file, int c, IconImage *icon);

/* main.c */
char *get_destination_name(IconFile *fi, int width, int height,
    	int color_count);
void put_message(int min_verbosity_level, char *format, ...);

/* writeico.c */
void make_xpm_image (IconFile *fi, IconImage *icon);
