/* debug.h - Debugging facilities.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __DEBUG_H__
#define __DEBUG_H__

#include <stdarg.h>
#include <stdio.h>		/* for fprintf, vfprintf below */

#if defined DEBUG && DEBUG
#define DEBUG_ENABLED 1
#else
#define DEBUG_ENABLED 0
#endif

extern inline void debug(const char *msg, ...);

/**
 * @note This function is also defined in error.c
 */
extern inline void
debug(const char *msg, ...)
{
	if (DEBUG_ENABLED) {
		va_list ap;

		va_start(ap, msg);
		vfprintf(stderr, msg, ap);
		fprintf(stderr, "\n");
		va_end(ap);
	}
}

#endif
