/* tmap.h - A red-black tree map implementation.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __TMAP_H__
#define __TMAP_H__

#include <sys/types.h>
#include "common.h"
#include "collections.h"
#include "iterator.h"

typedef struct _TMap TMap;

TMap *tmap_new(void);
TMap *tmap_new_specific(CompareFunc compare_keys);
uint32_t map_size(TMap *map);
bool tmap_contains_key(TMap *map, void *key);
bool tmap_contains_value(TMap *map, void *value);
void *tmap_first_key(TMap *map);
void *tmap_last_key(TMap *map);
void *tmap_get(TMap *map, void *key);
void *tmap_put(TMap *map, void *key, void *value);
void *tmap_remove(TMap *map, void *key);
void tmap_iterate_values(TMap *map, IteratorFunc iterator_func);
TMap *tmap_clone(TMap *map);

#endif
