/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XPngImage.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "XPngImage.h"
#include "XIconWithShadow.h"

XPngImage::XPngImage(AbstractContainer * c, AbstractIcon * iParent,
                         AbstractConfig * con, AbstractIconConfig * iConfig)
                            : XIdeskImage(c, iParent, con, iConfig)
{   
}

XPngImage::~XPngImage()
{
}

void XPngImage::configure()
{
    XIdeskImage::configure();
}

void XPngImage::createPicture()
{
    string filename = iconConfig->getPictureFilename();
    
    ImlibImage *image;

    if( loadPng( filename ) == true )
    {
        image = Imlib_load_image( imlibData, (char*)filename.c_str() );

        if(!image)
        {
            cout << "Couldn't find image " << filename << " bailing\n";
            _exit(1);
        }
        else
        {
            width = image->rgb_width;
            height = image->rgb_height;
        }
        Imlib_kill_image(imlibData, image);
    }
    else
    {
        cout << "Can't load: " << filename << " bailing -- "
             << iconConfig->getCaption() << endl
             << "Check to see if the image and path to image is valid\n";
    }
}

bool XPngImage::loadPng(const string &filename)
{
    
    unsigned char *ptr, *aptr, *aptr2, **lines, *line, r, g, b, a;
    png_structp   pngdata;
    png_infop     pnginfo;
    png_uint_32   w, h;
    FILE          *file;
    int           color, depth, interlace;

    if ( !(file = fopen( (char*)filename.c_str(), "r" )) )
        return false;

    pngdata = png_create_read_struct( PNG_LIBPNG_VER_STRING, NULL, NULL, NULL );

    if (!pngdata)
        return false;
    
    pnginfo = png_create_info_struct( pngdata );
    
    if (!pnginfo)
    {
        png_destroy_read_struct( &pngdata, NULL, NULL );
        return false;
    }

    if (setjmp(pngdata->jmpbuf))
    {
        png_destroy_read_struct( &pngdata, NULL, NULL );
        return false;
    }
    
    if(color == PNG_COLOR_TYPE_RGB_ALPHA)
    {
        png_destroy_read_struct( &pngdata, NULL, NULL );
        return false;
    }

    png_init_io(pngdata, file);
    png_read_info(pngdata, pnginfo);
    png_get_IHDR(pngdata, pnginfo, &w, &h, &depth, &color, &interlace,
                 NULL, NULL);

    width = w;
    height = h;

    if (color == PNG_COLOR_TYPE_PALETTE)
        png_set_expand(pngdata);

    png_set_strip_16(pngdata);
    png_set_packing(pngdata);

    if(png_get_valid(pngdata,pnginfo,PNG_INFO_tRNS))
        png_set_expand( pngdata );
    
    png_set_filler( pngdata, 0xff, PNG_FILLER_AFTER );

    rgb = new unsigned char[width * height * 3];
    alpha = new unsigned char[width * height];
    alpha2 = new unsigned char[width * height];
    if (!rgb || !alpha || !alpha2)
    {
        png_destroy_read_struct( &pngdata, NULL, NULL );
        return false;
    }
    
    lines = new unsigned char*[height];

    if (!lines)
    {
        delete [] rgb;
        delete [] alpha;
        delete [] alpha2;
        png_destroy_read_struct( &pngdata, NULL, NULL );
        return false;
    }
    
    for(int i=0; i< height; i++)
    {
        lines[i] = new unsigned char[width * 4];
        
        if (!lines[i] )
        {
            delete [] rgb;
            delete [] alpha;
            delete [] alpha2;
            png_destroy_read_struct( &pngdata, NULL, NULL );
            return false;
        }
    }

    hasAlpha = true;

    png_read_image(pngdata, lines);
    png_destroy_read_struct(&pngdata, &pnginfo, NULL);
    ptr = rgb;
    aptr = alpha;
    aptr2 = alpha2;

    //DesktopIconConfig * dIconConfig = 
    //  dynamic_cast<DesktopIconConfig *>(iconConfig);
    
    for(int y = 0; y < height; y++)
    {
        line = lines[y];
        for (int x = 0; x < width; x++)
        {
            if (color == PNG_COLOR_TYPE_GRAY_ALPHA)
            {
                r = g = b = *line++;
                a = *line++;
            }
            else if (color == PNG_COLOR_TYPE_GRAY)
            {
                r = g = b = *line++;
                a = 255;
            }
            else
            {
                r = *line++;
                g = *line++;
                b = *line++;
                a = *line++;
            }
            
            *ptr++ = r;
            *ptr++ = g;
            *ptr++ = b;
        
            // Transparency matrix.
            if( ( a - transparency ) < 0 )
            {
                *aptr++ = 0;
                *aptr2++ = a;
            }
            else 
            {
                *aptr++ = a - transparency;
                *aptr2++ = a;
            }
        }
    }
      

    for(int i = 0; i < height; i++)
        delete [] lines[i];
    
    delete [] lines;
    
    return true;
}

/****************************************************************************\
 * XPngImageShadow -- class implementation                                  *
\****************************************************************************/
XPngImageShadow::XPngImageShadow(AbstractContainer * c,
                                 AbstractIcon * iParent,
                                 AbstractConfig * con,
                                 AbstractIconConfig * iConfig)
                                    : XIdeskImage(c, iParent, con, iConfig),
                                      XPngImage(c, iParent, con, iConfig),
                                      XShadowImage(c, iParent, con, iConfig)
{
}

void XPngImageShadow::configure()
{
    XPngImage::configure();
    XShadowImage::configure();
}

void XPngImageShadow::refreshIcon()
{
    XShadowImage::refreshIcon();
    //XPngImage::refreshIcon(); calls repaint, but resets the new x, y values
    repaint();
}
