/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  DataSubject for reading basic particle files
//
#ifndef IBASICPARTICLESDATASUBJECT_H
#define IBASICPARTICLESDATASUBJECT_H


#include "igenericparticlesdatasubject.h"


class vtkCellArray;
class vtkFloatArray;
class vtkPoints;
class vtkPolyData;


class iBasicParticlesDataSubject : public iGenericParticlesDataSubject
{

	friend class iDataReader;

public:

	IOBJECT_DECLARE_SELF(iBasicParticlesDataSubject,iGenericParticlesDataSubject);

	static const iObjectType& Type();

	void SetOrderInFileIsAttribute(bool s);
	inline bool GetOrderInFileIsAttribute() const { return mOrderInFileIsAttribute; }

	//
	//  Inherited members
	//
	IDATASUBJECT_DECLARE_INHERITED_KEYS;
	IDATASUBJECT_DECLARE_INHERITED_MEMBERS;

protected:

	iBasicParticlesDataSubject(iDataReader *r);
	virtual ~iBasicParticlesDataSubject();

	virtual bool ReadBinFileHeader(iFile &F, long &ntot0, float *ll, float *ur, bool &paf, int &natt);
	virtual bool ReadTxtFileHeader(iFile &F, long &ntot0, float *ll, float *ur, bool &paf, int &natt, iString &buffer);
	virtual bool ReadBinFileContents(iFile &F, bool paf, int iattOff, int natt, vtkIdType ntot, long ntot0, vtkPoints *pts, vtkFloatArray *atts, float *scaleF, float *offsetF, double *scaleD, double *offsetD);
	virtual bool ReadTxtFileContents(iFile &F, bool paf, int iattOff, int natt, vtkIdType ntot, long ntot0, vtkPoints *pts, vtkFloatArray *atts, float *scaleF, float *offsetF, double *scaleD, double *offsetD, iString buffer);

	bool mOrderInFileIsAttribute;
	vtkPolyData *mData;
};

#endif

