/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_CL)


#include "iclcommandinterpreter.h"


#include "icontrolmodule.h"
#include "ishell.h"
#include "istring.h"

#include <vtkIOStream.h>


using namespace iParameter;


iclCommandInterpreter::iclCommandInterpreter(iShell *s) : iCommandInterpreter(s)
{
}


iclCommandInterpreter::~iclCommandInterpreter()
{
}


void iclCommandInterpreter::Initialize()
{
	this->DislayLineOfText("To execute entered commands, put a semi-colon at the end of the last one.",_CommandInterpreterTextTypeResult);
	this->DislayLineOfText("Type '.' to activate mouse interaction in the visualization window.",_CommandInterpreterTextTypeResult);
}


void iclCommandInterpreter::Finalize()
{
}


void iclCommandInterpreter::DisplayPrompt() const
{
	cout << endl;
	cerr << ": ";
}


void iclCommandInterpreter::ReadLineOfText(iString &line) const
{
	char c[2];
	c[1] = 0;

	while(((c[0]=getchar()) != EOF) && (c[0] != '\n'))
	{
		line += c;
	}
}


void iclCommandInterpreter::DislayLineOfText(const iString &text, int) const
{
	cout << text.ToCharPointer() << endl;
}


void iclCommandInterpreter::AnalyseSpecialCommands(const iString &line)
{
	if(line.IsEmpty())
	{
		//
		//  If the line is empty, render the visualization windows
		//
		this->GetShell()->GetControlModule()->Render(_RenderOptionAll);
		return;
	}

	//
	//  Are we done?
	//
	if(line=="exit" || line=="quit")
	{
		this->Break(1);
		return;
	}

	//
	//  Are we out for interaction?
	//
	if(line=="." || line=="window")
	{
		cout << "Use mouse to interact with the visualization window." << endl;
		cout << "Press 'q' in the visualization window to return to prompt." << endl;
		this->Break(0);
		return;
	}
}


void iclCommandInterpreter::CheckBreak()
{
	//
	//  Do nothing here, we check for break in AnalyseSpecialCommands
	//
}

#endif
