/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "guiIMPre.h"
#include "XimpIm.h"

/* ChangePreedit Methods */
static void
create(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)ic->gui_icpart->preedit;

  if (!preedit) {
    SetupPreeditExt(ic);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
  }

  if (preedit->parent != 0 && preedit->preedit_areas) {
    /* preedit window is already created  */
    return;
  }

  if (!(ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN)) return;

  SetupPreeditWindow(ic, ic->core.client_window);
  return;
}

static void
set_window(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)(ic->gui_icpart->preedit);
  PreeditArea preedit_area;
  CacheRec *preedit_cache;
  PreeditChars preedit_chars;
  unsigned int width, height;

  if (!preedit) {
    create(ic, NULL);
    preedit = (PreeditWin)(ic->gui_icpart->preedit);
    if (!preedit) return;
  }
  preedit_area = (PreeditArea)(preedit->preedit_areas);

  if (!preedit->fontset) {
    SetPreeditFont(ic, NULL);
  }

  preedit_chars = (PreeditChars)&(preedit->preedit_chars);
  if (preedit_area) {
    preedit_area[0].x = 0;
    preedit_area[0].char_offset = 0;
    preedit_area[0].char_len = preedit_chars->wchar_len;
  }

  if (preedit_chars->wchar_len == 0) return;

  if (preedit->fontset) {
    XFontSetExtents *fse;
    fse = XExtentsOfFontSet(preedit->fontset);
    width = XwcTextEscapement(preedit->fontset,
			      preedit_chars->wchar,
			      preedit_chars->wchar_len);
    height = fse->max_logical_extent.height;
    if (preedit_area) {
      preedit_area[0].y = fse->max_ink_extent.height;
    }
  } else {
    width = ic->core.preedit_attr.area.width;
    height = ic->core.preedit_attr.area.height;
    if (preedit_area) {
      preedit_area[0].y = ic->core.preedit_attr.area.height;
    }
  }

  preedit_cache = (CacheRec*)&(preedit->preedit_cache);
  if (preedit_cache->win_x == ic->core.preedit_attr.area.x &&
      preedit_cache->win_y == ic->core.preedit_attr.area.y &&
      preedit_cache->win_width == width &&
      preedit_cache->win_height == height &&
      preedit_cache->font_set == preedit->fontset) {
    return;
  }
  if (preedit->active_areas == 1 && preedit_area &&
      preedit_area[0].window) {
    XMoveResizeWindow(ic->core.im->core.display,
		      preedit_area[0].window,
		      ic->core.preedit_attr.area.x,
		      ic->core.preedit_attr.area.y,
		      width, height);
  }
  /* data cache */
  preedit_cache->win_x = ic->core.preedit_attr.area.x;
  preedit_cache->win_y = ic->core.preedit_attr.area.y;
  preedit_cache->win_width = width;
  preedit_cache->win_height = height;
  preedit_cache->font_set = preedit->fontset;

  return;
}

static void
move(XicCommon ic, XPointer call_data) {
  /* nothing to do */
  return;
}

static PreeditCB preedit_area_methods[] = {
  create,			/* PREEDIT_CREATE */
  set_window,			/* PREEDIT_WIN */
  SetPreeditForeground,		/* PREEDIT_FG */
  SetPreeditBackground,		/* PREEDIT_BG */
  SetPreeditFont,		/* PREEDIT_FONT */
  move,				/* PREEDIT_MOVE */
  PreeditStart,			/* PREEDIT_START */
  PreeditDrawText,		/* PREEDIT_DRAW */
  PreeditCaret,			/* PREEDIT_CARET */
  PreeditDone,			/* PREEDIT_DONE */
  DestroyPreedit		/* PREEDIT_DESTROY */
};

void
ChangePreeditArea(XIC xic, PreeditAttr reason, XPointer call_data) {
  XicCommon ic = (XicCommon)xic;
  if (reason > PREEDIT_DESTROY) return;
  preedit_area_methods[reason](ic, call_data);
  return;
}
