/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#pragma ident	"$Id$"

#include	<stdlib.h>
#include	<limits.h>
#include	<X11/Xlib.h>
#include	"xaux_common.h"
#include	"xaux_atommng.h"

#include	<stdio.h>

xaux_atommng_data_t *
xaux_atommng_alloc_data(
	const char		*classname,
	Bool			is_xs,
	Display			*display
)
{
	xaux_atommng_data_t	*data;
	int			i;
	char			buf[PATH_MAX];

	data = (xaux_atommng_data_t *)malloc(sizeof (xaux_atommng_data_t));

	if (data == NULL) {
		return (NULL);
	}

	data->classname = classname;
	data->display = display;

	snprintf(buf, PATH_MAX, "%s%s", data->classname,
		XAUX_ATOMMNG_SX_SUFFIX);
	data->atom_sx = XInternAtom(data->display, buf, False);
	data->atom_sx_inuse = False;

	snprintf(buf, PATH_MAX, "%s%s", data->classname,
		XAUX_ATOMMNG_XS_SUFFIX);
	data->atom_xs = XInternAtom(data->display, buf, False);
	data->atom_xs_inuse = False;

	data->idx = -1;
	data->is_xs = is_xs;

	return (data);
}

Bool
xaux_atommng_check_atom(
	xaux_atommng_data_t	*data,
	Bool			is_xs,
	Atom			atom
)
{
	if (((is_xs == True) && (atom == data->atom_xs))
			|| ((is_xs == False) && (atom == data->atom_sx))) {
		return (True);
	}

	return (False);
}

Atom
xaux_atommng_get_atom(
	xaux_atommng_data_t	*data,
	Window			win
)
{
	if (data->is_xs == True) {
		if (data->atom_xs_inuse == True) {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_xs=%d is busy\n", data->atom_xs);
#endif /* defined(DEBUG_XAUX) */
			return ((Atom)None);
		} else {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_xs=%d is available\n", data->atom_xs);
#endif /* defined(DEBUG_XAUX) */
			data->atom_xs_inuse = True;
			return (data->atom_xs);
		}
	} else {
		if (data->atom_sx_inuse == True) {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_sx=%d is busy\n", data->atom_sx);
#endif /* defined(DEBUG_XAUX) */
			return ((Atom)None);
		} else {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_sx=%d is available\n", data->atom_sx);
#endif /* defined(DEBUG_XAUX) */
			data->atom_sx_inuse = True;
			return (data->atom_sx);
		}
	}
}

void
xaux_atommng_free_data(
	xaux_atommng_data_t	*data
)
{
	if (data == NULL) {
		return;
	}

	free(data);

	return;
}

Bool
xaux_atommng_release_atom(
	xaux_atommng_data_t	*data)
{
	if (data->is_xs == True) {
		data->atom_xs_inuse = False;
	} else {
		data->atom_sx_inuse = False;
	}
	return (True);
}

Bool
xaux_atommng_process_delete(
	xaux_atommng_data_t	*data,
	XPropertyEvent		*pev)
{
		if ((data->is_xs == True) && (pev->atom == data->atom_xs)) {
			data->atom_xs_inuse = False;
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_xs=%d is released\n", data->atom_xs);
#endif /* defined(DEBUG_XAUX) */
			return (True);
		} else if ((data->is_xs == False) &&
				(pev->atom == data->atom_sx)) {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_sx=%d is released\n", data->atom_sx);
#endif /* defined(DEBUG_XAUX) */
			data->atom_sx_inuse = False;
			return (True);
		} else {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: unknown PropertyDelete to atom=%d\n", pev->atom);
#endif /* defined(DEBUG_XAUX) */
			return (False);
		}
}

Bool
xaux_atommng_process_selclr(
	xaux_atommng_data_t	*data,
	XSelectionClearEvent	*scev)
{
		if ((data->is_xs == True)
				&& (scev->selection == data->atom_xs)) {
			data->atom_xs_inuse = False;
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_xs=%d is released\n", data->atom_xs);
#endif /* defined(DEBUG_XAUX) */
			return (True);
		} else if ((data->is_xs == False) &&
				(scev->selection == data->atom_sx)) {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: atom_sx=%d is released\n", data->atom_sx);
#endif /* defined(DEBUG_XAUX) */
			data->atom_sx_inuse = False;
			return (True);
		} else {
#if defined(DEBUG_XAUX)
fprintf(stderr, "atommng: unknown SelectionClear to atom=%d\n", scev->selection);
#endif /* defined(DEBUG_XAUX) */
			return (False);
		}
}

Atom
xaux_atommng_know_atom(
	xaux_atommng_data_t	*data,
	Bool			is_xs)
{
	if (is_xs == True) {
		return (data->atom_xs);
	} else {
		return (data->atom_sx);
	}
}

xaux_propq_t *
xaux_propq_alloc(size_t	maxtotalsz)
{
	xaux_propq_t	*p;

	if ((p = (xaux_propq_t *)malloc(sizeof (xaux_propq_t)))
			== NULL) {
		return (NULL);
	}
	p->count = 0;
	p->totalsz = 0U;
	p->maxtotalsz = maxtotalsz;
	p->list = NULL;

	return (p);
}

int
xaux_propq_add(
	xaux_propq_t		*data,
	unsigned char		*buf,
	int			len)
{
	xaux_propq_prop_t	*add;
	xaux_propq_prop_t	*last;

	if ((data->maxtotalsz > 0) &&
			((data->totalsz + len) > data->maxtotalsz)) {
#if defined(DEBUG_XAUX)
fprintf(stderr, "propq: add() failed because of size limit\n");
#endif /* defined(DEBUG_XAUX) */
		return (-2);
	}

	if ((add = (xaux_propq_prop_t *)malloc(sizeof (xaux_propq_prop_t)))
			== NULL) {
		return (-1);
	}

	add->buf = buf;
	add->len = len;

	if (data->list == NULL) {
		add->prev = NULL;
		add->next = NULL;
		data->list = add;
	} else {
		for (last = data->list; ; last = last->next) {
			if (last->next == NULL) {
				break;
			}
		}
		add->prev = last;
		add->next = NULL;
		last->next = add;
	}

	data->count++;
	data->totalsz += len;

#if defined(DEBUG_XAUX)
fprintf(stderr, "propq: add(%d:0x%x)\n", data->count, data->totalsz);
#endif /* defined(DEBUG_XAUX) */
	return (data->count);
}

int
xaux_propq_check(
	xaux_propq_t	*data)
{
#if defined(DEBUG_XAUX_DETAIL)
fprintf(stderr, "propq: check(%d)\n", data->count);
#endif /* defined(DEBUG_XAUX_DETAIL) */
	return (data->count);
}

int
xaux_propq_get(
	xaux_propq_t	*data,
	unsigned char		**pbuf,
	int			*plen)
{
	xaux_propq_prop_t	*prev;

	if (data->list == NULL) {
		return (-1);
	}

	(*pbuf) = data->list->buf;
	(*plen) = data->list->len;

	prev = data->list;
	data->list = data->list->next;
	if (data->list != NULL) {
		data->list->prev = NULL;
	}
	free(prev);

	data->count--;
	data->totalsz -= *plen;

#if defined(DEBUG_XAUX)
fprintf(stderr, "propq: get(%d:0x%x)\n", data->count, data->totalsz);
#endif /* defined(DEBUG_XAUX) */
	return (data->count);
}

void
xaux_propq_clean(
	xaux_propq_t	*data)
{
	xaux_propq_prop_t	*cur = data->list;
	xaux_propq_prop_t	*prev;

	while (cur != NULL) {
		prev = cur;
		cur = cur->next;
		free(prev->buf);
		free(prev);
	}

	data->count = 0;
	data->totalsz = 0U;
	data->list = NULL;

	return;
}

void
xaux_propq_free(
	xaux_propq_t	*data)
{
	xaux_propq_prop_t	*cur = data->list;
	xaux_propq_prop_t	*prev;

	xaux_propq_clean(data);

	free(data);

	return;
}
