#!/usr/bin/env python
# Time-stamp: <2004-01-16 14:06:17 crabbkw>

# Code and design by Casey Crabb (crabbkw@nafai.dyndns.org)
# This code is licensed under the BSD license.
# See the LICENSE file for details
#
# Copyright Casey Crabb (crabbkw@nafai.dyndns.org) July 2001
#



try:
    from xml.parsers import expat
except:
    from xml.parsers import pyexpat
    expat = pyexpat
import os
import string
import sys
import getpass
import socket
import codecs
from JabberHandler import JabberContentHandler

def fix(str):
    str = string.replace( str, "&", "&amp;" );
    str = string.replace( str, '"', "&quot;");
    str = string.replace( str, "'", "&apos;");
    str = string.replace( str, "<", "&lt;");
    str = string.replace( str, ">", "&gt;");
    return str;

class AccountCreator:
    def __init__(self, server, useSSL, port, user, password, resource, encoding, writeconfig=1, callback=None):
        self.server=server
        self.useSSL = useSSL
        self.port=port
        self.user=user
        self.password=password
        self.resource=resource
        self.encoding=encoding
        self.debug = 0
        self.oncethrough = 0
        self.writeconfig = writeconfig
        self.callback = callback

    def handleStream(self, stream):
        id = stream.id
        tosend = "<iq type='get'><query"\
                 " xmlns='jabber:iq:register'/></iq>"
        self.sendPacket(tosend)

    def handleIQ(self, iq):
        type = iq.type
        if(type == "error"):
            print "Error! Try a different username..."
            sys.exit(-1)
        if(self.oncethrough and type == "result"):
            if(self.writeconfig):
                self.writeConfig()
            self.disconnect()
            return
        key = None
        try:
            key = iq.query.key.text
        except:
            pass
        if(key):
            tosend = "<iq type='set'><query"\
                     " xmlns='jabber:iq:register'>"\
                     "<key>"+key+"</key>"\
                     "<username>"+self.user+"</username>"\
                     "<password>"+fix(self.password)+"</password>"\
                     "</query></iq>"
        else:
            tosend = "<iq type='set'><query"\
                     " xmlns='jabber:iq:register'>"\
                     "<username>"+self.user+"</username>"\
                     "<password>"+fix(self.password)+"</password>"\
                     "</query></iq>"
        self.oncethrough = 1
        self.sendPacket(tosend)

    def connect(self):
        self.tempsocket = socket.socket(socket.AF_INET,
                                        socket.SOCK_STREAM)
        self.tempsocket.connect((self.server,self.port))
        if(self.useSSL != 0):
          self.mainSocket = socket.ssl(self.tempsocket, None, None)
        else:
          self.mainSocket = self.tempsocket
        self.jch = JabberContentHandler(self, self.useSSL)
        self.jch.debug = 0
        self.sendPacket("<stream:stream to='"+self.server+
                        "' xmlns='jabber:client' "+
                        "xmlns:stream='http://etherx.jabber.org/streams'>")
        # self.jch.setDaemon(1)
        self.jch.start()

    def writeConfig(self):
        towrite = '<?xml version="1.0" encoding="UTF-8"?>\n'
        towrite += "<imcom default='"+self.server+"'>\n"\
                   "    <profile name='"+self.server+"' debug='false' "\
                   "statusshow='true' colors='true' ringbell='true' "\
                   "confringbell='false'"
        if self.useSSL != 0:
          towrite += " ssl='true' "
        else:
          towrite += " ssl='false' "
        towrite += ">\n"\
                   "        <server>"+self.server+"</server>\n"\
                   "        <port>"+str(self.port)+"</port>\n"\
                   "        <user>"+self.user+"</user>\n"\
                   "        <password>"+fix(self.password)+"</password>\n"\
                   "        <resource>"+fix(self.resource)+"</resource>\n"\
                   "        <encoding>"+fix(self.encoding)+"</encoding>\n"\
                   "    </profile>\n"\
                   "</imcom>"
        confirm = raw_input("Ready to write ~/.imcom/imcomrc proceed? "\
                            "(yes/no)> ")
        if(confirm and string.lower(confirm) == "yes"):
            try:
                os.mkdir(os.environ['HOME']+"/.imcom",0700)
            except:
                pass
            try:
                f = codecs.open(os.path.join(os.path.expanduser("~"),".imcom","imcomrc"),"w", "utf8")
                os.chmod(os.path.join(os.path.expanduser("~"),".imcom","imcomrc"),0600)
                f.write(towrite)
                f.flush()
                f.close()
                print
                print "You can now run python CLI.py and log on with your account!"
            except:
                print "There was an error: "
                print str(sys.exc_info()[0])
                print str(sys.exc_info()[1])
                print "In the likely case that you're out of diskspace I'll "\
                      "display the config file so you can copy paste it."
                print towrite
        else:
            print "The account was created, however, your "\
                  "configuration was not written to file at your "\
                  "request. You can create the config on your own "\
                  "and it will work."

    def disconnect(self):
        #print "disconnecting"
        self.closeSocket()
        if(self.callback != None):
            self.callback(None)
        #self.sendPacket("</stream:stream>")

    def handleDisconnected(self):
        return

    def closeSocket(self):
        self.jch.running = 0
        if self.useSSL != 0:
          self.tempsocket.close()
        else:
          self.mainSocket.close()
        self.mainSocket = None

    def sendPacket(self, text):
      #print "isinstance(text, unicode): ", isinstance(text,unicode)
      text = text.encode("utf-8")
      if(self.debug):
        print "sending :> " + text.decode("utf-8").encode(self.encoding)

      if self.useSSL != 0:
        self.mainSocket.write(text)
      else:
        self.mainSocket.send(text)


def successCallback(garbage):
  print "Account created successfully"

def main():
  if len(sys.argv) == 7:
    # now create the account
    server = sys.argv[1]
    port   = int(sys.argv[2])
    user   = sys.argv[3]
    password = sys.argv[4]
    resource = sys.argv[5]
    encoding = sys.argv[6]
    print server, port, user, password, resource, encoding
    # change the 0 to a 1 in the next line to have it write preference files.
    AC = AccountCreator(server,0,port,user,password,resource,encoding,0,successCallback)
    AC.connect()
    return


  print("This utility will create an account for you on a jabber server.")
  print("It will also create an initial ~/.imcom/imcomrc file for you.")
  print("Warning: This program will overwrite ~/.imcom/imcomrc.")

  print
  print("If you're not sure what jabber server you want to use,"\
          " use jabber.org")
  server = raw_input("Enter a server name: ")

  useSSL = None
  while(useSSL == None):
    print
    print("Would you like to use SSL? Defaults to yes")
    useSSL = raw_input("Enter yes or no[yes]: ")
    if(useSSL == None or useSSL == "" or useSSL == "yes" or useSSL == "y"):
      useSSL = 1
    else:
      useSSL = 0


  port = None
  while(port == None):
    try:
      print
      if useSSL:
        print("Enter the port number. Defaults to 5223")
        port = raw_input("Enter a port[5223]: ")
      else:
        print("Enter the port number. Defaults to 5222")
        port = raw_input("Enter a port[5222]: ")
      if(port == None or port == ""):
        if useSSL:
          port = 5223
        else:
          port = 5222
      else:
        port = int(port)
    except:
      print("That wasn't a number, try again.")
      port = None


  print
  print("Enter your desired username below. ")
  user   = raw_input("Enter your username: ")

  print
  print("Enter your password below.")
  password = getpass.getpass()

  print
  print("Enter the resource below. The resource is typically where"\
        "you are using jabber from (home, work, etc) it can be any"\
        "string. It cannot be NULL.")
  resource = raw_input("Enter a resource: ")
  if(resource == None or resource == ""):
    resource = "IMCom"

  print
  print("Enter the encoding you wish you use. This defaults to iso-8859-1")
  encoding = raw_input("Enter an encoding: ")
  if(encoding == None or encoding == ""):
    encoding = "iso-8859-1"
  server = server.decode(encoding)
  user = user.decode(encoding)
  password = password.decode(encoding)
  resource = resource.decode(encoding)
  #name = raw_input("Enter your name: ")
  #email = raw_input("Enter your email: ")

  # now create the account
  AC = AccountCreator(server,useSSL,port,user,password,resource,encoding)
  AC.connect()


if(__name__ == "__main__"):
  main()
