#ifndef _UI_H_
#define _UI_H_

#include "gstamp.h"

#define GSTMP_BROWSE_SAVEAS 1
#define GSTMP_BROWSE_INFILE 2
#define GSTMP_BROWSE_OUTFILE 3
#define GSTMP_BROWSE_UPPERFONT 4
#define GSTMP_BROWSE_LOWERFONT 5
#define GSTMP_BROWSE_PREVIEW 6
#define GSTMP_BROWSE_LOAD 7


typedef struct {
  GtkWidget *window;
  GtkWidget *label;
} Yes_No_Dialog;

typedef struct { 
  GtkWidget *window;
  GtkWidget *label;
  GtkWidget *button;
} Message_Dialog;
  

typedef struct {
  GtkWidget *window;
  GtkWidget *gtk_image;
  GdkImage *gdk_image;
  GtkStyle *style;
  GdkColorContext *gcc;
  GtkWidget *vbox;
  
} Gstmp_Preview ;



/* The UI Structure.  This is a big structure which represents key
   elements in the UI.  Something is in here if and only if I need it
   somewhere in the program.
*/
typedef struct {

  gchar *RCFile;  /* filename for the rcfile */
  char *Titlebase; /* the base for the window title */

  GtkWidget *Vbox;
  GtkWidget *tooltips;
  GtkWidget *notebook;
  GtkWidget *Status; /* label for statusbar */

  GtkWidget *Previewfile ; /* Entry */
  GtkWidget *Infile ; /* Entry */
  GtkWidget *Outfile ; /* Entry */
  GtkWidget *UpperString ; /* Entry */
  GtkWidget *LowerString ; /* Entry */
  GtkWidget *UpperFont; /* Entry */
  GtkWidget *LowerFont; /* Entry */
  GtkWidget *UStringExec ; /* checkbutton */
  GtkWidget *LStringExec ;  /* checkbutton */
  GtkWidget *Use3D ; /* checkbutton */
  GtkWidget *Rotate ; /* checkbutton */

  /* FTP Related */
  GtkWidget *Host ; /* entry */
  GtkWidget *Path ; /* entry */
  GtkWidget *Upload ; /* entry */
  GtkWidget *Login ; /* entry */
  GtkWidget *Passwd ; /* entry */

  /* colour stuff */
  GtkWidget *ColorButton1; /* button */
  GtkWidget *ColorButton2; /* button */
  GtkWidget *UseColors ; /* checkbutton */
  GtkWidget *ShadeRate ; /* h_scale */
  GtkWidget *Quality ; /* h_scale */
  
  /* helper dialogs */
  GtkWidget *ColorSel;     /* color selection dialog */
  GtkWidget *filew;        /* file selection dialog */
  Yes_No_Dialog *yesno;    /* my yes/no dialog  */
  Gstmp_Preview *preview;
  Message_Dialog *message;
  GtkWidget *window;       /* the main application window (is this ever used? ) */
  
  /* main window icon info */
  GdkPixmap *no_stamp;
  GdkBitmap *no_stamp_mask;
  GdkPixmap *yes_stamp;
  GdkBitmap *yes_stamp_mask;
  GdkPixmap *no_transfer;
  GdkBitmap *no_transfer_mask;
  GdkPixmap *yes_transfer;
  GdkBitmap *yes_transfer_mask;
  
  GtkWidget *stamp_pix;   
  GtkWidget *transfer_pix; 
  
  struct ArgStruct *args; /* stamp Argument structure */

  int GSTMP_FILE_VISIBLE;  /* Whether or not the File dialog is visible */
  int GSTMP_FILE_BUTTON;   /* Which button the file dialog is working on */

  int GSTMP_COLOR_VISIBLE; /* Whether or not the Color dialog is visible */
  int GSTMP_CURRENT_COLOR_BUTTON; /* Which button the Color dialog is working on */
  int GSTMP_STAMPING;
  

} UI_Struct;

UI_Struct *make_ui (struct ArgStruct *arg);

#endif































