/***************************************************************************
                          ac3dfile.cpp  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Purpose: A first shot at a crystal space 3D sprite exporter.
 * 
 * Limitations:
 *  - only doing one frame.
 *  - only triangles.
 *  - no skeleton/bone/limb info.
 * 
 * NOTES:
 * 
 * CS sprites can only have triangles.  We will probably automatically
 *  triangulate, or ask the user(or both).
 * 
 * The CS sprite format uses uv coordinates tied to verticies.
 * This is not good because most(all?) uv texture mappers work on with
 *  faces.  Ie they have a different uv coordinate at each vertex of a face.
 *
 * The problem with doing this is that for 3D cards
 * 
 * 
 * Assumptions about I3D:
 *  - +z is forward, -z is backward.
 *  - +y is up, -y is down.
 *  - polygons are anti-clockwise.
 * 
 * 
 * TODO:
 * 
 * 
 *  like to add some options to the exporter.
 *   - do per face uv mapping.
 *   - do per vertex uv mapping.
 *   - base directory for images in CS's VFS.
 *   - export sprite into a world.
 *   - export sprite template.
 *   - 
 *  Save the name for the sprite and sprite template into the I3D file.
 * 
 *  Add animation support.  Not sure how far along I3D is in this area yet.
 *   Would like to be able to save crystal space ACTIONS in I3D some how.
 * 
 *  Add import capability.  Would like to reuse some crystal space code for
 *   this.
 */




#include "cssprfile.h"
#include <vector>
#include <iostream.h>

extern "C" {
FilePlugin * i3d_createInstance(){
	return new CSSPRFile();
}
}


CSSPRFile::CSSPRFile() : FilePlugin("CSSPR", "ac")
{
	setImportable(false);
	setExportable(true);
	
}
CSSPRFile::~CSSPRFile(){
}

void CSSPRFile::importData(ifstream &in)
{
  // not implemented!!!

}



void CSSPRFile::exportData(ofstream &out)
{

	vector<Selectable *> *list;
	list = getMeshes();

	int size = (int)list->size();

	for(int i=0; i<size; i++)
    {
      writeSprite((Object *)(*list)[i], out);
	}
}


void CSSPRFile::writeSprite(Object *o, ofstream &out)
{

//  out << "OBJECT poly"<<endl;
  out <<"  WORLD (" << endl;
  out <<"  TEXTURES (" << endl;
  out <<"    MAX_TEXTURES (10)" << endl;
  out <<"    TEXTURE 'abstract_a032.gif' ()" << endl;
  out <<"    TEXTURE 'andrew_wood.gif' ()" << endl;
  out <<"    TEXTURE 'sydney.gif' ()" << endl;
  out <<"    TEXTURE 'bla.png' ()" << endl;
  out <<"    TEXTURE 'bla2.gif' ()" << endl;
  out <<"  )" << endl;

  
  // Don't know how to get the name.
  out << "SPRITE 'sydney'(" << endl;
  
  
  // Add the texture.
  // We also need to add the texture to the top of the world file.
  TextureMaterial *tm = o->getTextureMaterial();
  if(tm != 0 && tm->texture != 0)
  {
	// Need to get the file name that the image will be in CS's VFS.
//    out << "TEXNR('"<<tm->texture->getFilename()->ascii()\
//      << "')" <<endl;
    out<<"TEXNR('bla2.gif')" <<endl;

  }
  
  // Write the frames.  err... "frame".  We done needs verts, and 
  //  uv coordinates.
  
  // We are going to waste some vertices here.
  // 
  // We are going to add an extra set of vertices
  // 
  // for each face:
  //   add to the new vertex list, the vertices in the face.
  //   add to the new uv coords list, the uvs for the face.
  // 
  // The triangle list will be made by consecutively using three vertices
  //  from the list of vertices.
  
  
  VertexList *vlist = o->getVerts();
  UVList *uvlist = o->getUVs();
  vector<Vector4> new_vert_list;
  vector<Vector4> new_uv_list;

  
  
  int num_verts = (int)vlist->size();
  int num_uvs = (int)uvlist->size();
  
//DEBUG
//  out << "num_verts is:" << num_verts << " num_uvs is:" << num_uvs <<endl;
  

  int num_faces = (int)o->numFaces();

  int tris = -1;
  

  for(int i=0; i < num_faces; i++)
  {
    Face *face = o->getFace(i);
	vector<int> *face_vlist = face->getVerts();
	vector<int> *face_uvlist = face->getUVs();

	
	int v_size = (int)face_vlist->size();
	int uv_size = (int)face_uvlist->size();
	
    for(int ii=0; ii<uv_size; ii++)
	{
      new_uv_list.push_back(face->getParentObject()->getUVCoord(
				           (*face_uvlist)[ii])->getPosition());
	}
	
    for(int ii=0; ii<v_size; ii++)
	{
      new_vert_list.push_back(face->getParentObject()->getVertex(
				           (*face_vlist)[ii])->getPosition());
	}
  }


  // write out the frames... er just one frame for now.
  
// DEBUG
//  out << "new_vert_list size:" << new_vert_list.size() << endl;
//  out << "new_uv_list size:" << new_uv_list.size() << endl;
  
  // Just place the name of the frame for now.
  out << "FRAME 'stand1' (";
  
  for(uint i = 0; i <  new_vert_list.size(); i++)
  {
    out << "V(" << new_vert_list[i].x << "," << new_vert_list[i].y << ",";

	// The z axis are oposite for I3D and CS.
	out << new_vert_list[i].z * -1 << ":";
	// Have to convert systems, as cs uses x = 0, y = 0 at top left.
	//  Inovation 3d uses bottom left.
	out <<  new_uv_list[i].x << "," << (1.0 - new_uv_list[i].y) << ")";
	out << endl;
  }
  out << ")" << endl;

  // write out the list of triangles.
  for(int i = 0; i < new_vert_list.size(); i += 3)
  {
	out << "TRIANGLE(" << i+2 <<","<< i +1 <<","<< i <<")" << endl;
  }

  // Write some actions down.

  out << "ACTION 'stand'(F (stand1, 30)F (stand1, 100))" << endl;

  // Close the sprite template.
  out << ")" << endl;

  
  out<<"    ROOM 'room' (" << endl;
  out<<"    FLOOR_CEIL ((-10,10) (10,10) (10,-10) (-10,-10))" << endl;
  out<<"    FLOOR_HEIGHT (-1)" << endl;
  out<<"    HEIGHT (4)" << endl;
  out<<"    TEXTURE ('abstract_a032.gif')" << endl;
  out<<"    TEX 'down' (TEXTURE ('andrew_wood.gif'))" << endl;
  out<<"    TEX 'up' (TEXTURE ('andrew_wood.gif'))" << endl;
  out<<"    TEXTURE_SCALE (3)" << endl;
  out<<"    LIGHT (0,0,9:20,1,1,1,0)" << endl;
  out<<"    LIGHT (0,0,-9:7,1,0,0,0)" << endl;
  out<<"    LIGHT (-9,0,0:7,0,1,0,0)" << endl;
  out<<"    LIGHT (9,0,0:7,0,0,1,0)" << endl;
  out<<"    SPRITE 'Quake2Sydney' (" << endl;
  out<<"        TEMPLATE ('sydney', 'stand')" << endl;
  out<<"        MOVE (V (-3,0,3))" << endl;
  out<<"    )" << endl;
  out<<"  )" << endl;
  out<<")" << endl;


/*
  for(int i=0; i<size; i++)
  {
    pos_of_vert = (*vlist)[i]->getPosition();
	out << pos_of_vert.x << " " <<pos_of_vert.y<<" "<<pos_of_vert.z<<endl;
  }


  
*/  
  
/*
 	writeObjectTexture(o, out);
	writeObjectTextureRep(o, out);
	writeObjectRotation(o, out);
	writeObjectLocation(o, out);
	writeObjectURL(o, out);
    writeObjectVerts(o, out);
	writeObjectSurfaces(o, out);
	writeObjectKids(o, out);
*/

}
