/***************************************************************************
                          primitivecommand.cpp  -  description
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "primitivecommand.h"
#include <Entities/entitylib.h>


template class PrimitiveCommand<bool>;
template class PrimitiveCommand<float>;
template class PrimitiveCommand<int>;
template class PrimitiveCommand<double>;
//template class PrimitiveCommand<Vertex>;
template class PrimitiveCommand<Mesh>;
//template class PrimitiveCommand<Face>;
template class PrimitiveCommand<Line>;
template class PrimitiveCommand<NurbsCurve>;
template class PrimitiveCommand<NurbsSurface>;
template class PrimitiveCommand<Spline>;

template <class T>
PrimitiveCommand<T>::PrimitiveCommand(T *o, T *n) : Command()
{
	oldValue = o;
	newValue = n;
}
template <class T>
PrimitiveCommand<T>::~PrimitiveCommand(){
}
template <class T>
bool PrimitiveCommand<T>::execute()
{
	T temp;
	temp = *oldValue;
	
	*oldValue = *newValue;
	*newValue = temp;
	return true;
}
template <class T>
bool PrimitiveCommand<T>::undo()
{
	T temp;
	temp = *oldValue;
	*oldValue = *newValue;
	*newValue = temp;
	return true;
	
}
