

//
// (c) Polar Pyramid

// suggestions to stolken@kabelfoon.nl and/or stolk@xs4all.nl
//

// Description:
//	The Vector4 class is a 4d vector containing 4 floats, can be used
//  to represent points(positions, w = 1) as well as vectors(directions, w = 0)
//

#ifndef VECTOR4_HH
#define VECTOR4_HH

class Vector3;

class Vector4
{
public:
  // the vector data

  float           x;
  float           y;
  float           z;
  float           w;
  bool             interp;


  // constructors
 Vector4();
  Vector4(const Vector4 &);
  Vector4(float x, float y, float z, float w);

  // array access
  float& operator [] (int);
   const float& operator [] (int) const;

  // assignment
  Vector4& assign(float x, float y, float z, float w);

  // math operators
  Vector4 operator - () const;
  Vector4& operator += (const Vector4&);
  Vector4& operator += (const Vector3&);
  Vector4& operator -= (const Vector4&);
  Vector4& operator -= (const Vector3&);
  Vector4& operator *= (float);
  Vector4& operator /= (float);

  Vector4 operator + (const Vector4&) const;
  Vector4 operator + (const Vector3&) const;
  Vector4 operator - (const Vector4&) const;
  Vector4 operator - (const Vector3&) const;
  Vector4 operator / (float) const;
  void min(const Vector4&);
  void max(const Vector4&);


	 Vector4 intersectPlane(const Vector4 &, const Vector4 &) const;

  bool operator == (const Vector4&) const;
  bool operator != (const Vector4&) const;
   bool isInterpolatable();
   void setInterpolatable(bool);

  // friends
	friend Vector4 operator*(float c, Vector4 const &v);
  friend Vector4 operator*(Vector4 const &v, float c);

  // vector4 stuff
  // operations
	 float  length(void) const;
   float   lengthSqr(void) const;
   float  length3d(void) const;
   float   lengthSqr3d(void) const;
   void    normalize(void);

  // conversions
  Vector3 ToVector3(void) const;
   float * v(float *v) const;

  // dot product

   float dot(const Vector4&) const;
   float dot3d(const Vector4&) const;

  // distance functions

   float distanceSqr(const Vector4&);
   float distance(const Vector4&);
   float distanceSqr3d(const Vector4&);
   float distance3d(const Vector4&);

  void Dump(void) const;
};

typedef class Vector4 *Vector4Ptr;

#endif

