// -*- C++ -*-
// --------------------------------------------------------------------
// Some small widgets
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef WIDGETS_H
#define WIDGETS_H_

#include <QtGui>

// --------------------------------------------------------------------

class IpeAction : public QAction {
  Q_OBJECT
public:
  IpeAction(int cmd, const QIcon &icon, const QString &text, QObject *parent);
  IpeAction(int cmd, const QString &text, QObject *parent);
signals:
  void triggered(int cmd);
private slots:
  void forwardTrigger();
private:
  int iCommand;
};

class ZoomSpinBox : public QSpinBox {
public:
  ZoomSpinBox(QWidget *parent = 0);
  virtual void stepBy(int steps);
protected:
  virtual QString textFromValue(int value) const;
  virtual int valueFromText(const QString &text) const;
};

class IpeSpinBox : public QSpinBox {
public:
  IpeSpinBox(QWidget *parent = 0, int minValue = 1, int maxValue = 1,
	     int step = 1);
  // these two methods will not emit valueChanged
  void set(int value, int maxValue);
  void set(int value);
};

class DecimalSpinBox : public IpeSpinBox {
public:
  DecimalSpinBox(int minValue, int maxValue, int step,
		 int decimals = 1, QWidget *parent = 0);
protected:
  virtual QString textFromValue(int value) const;
  virtual int valueFromText(const QString &text) const;
private:
  QValidator::State validate(QString &text, int &pos) const;
private:
  int iDecimals;
};

class LayerBox : public QListWidget {
  Q_OBJECT
public:
  LayerBox(QWidget *parent = 0) : QListWidget(parent) { /* nothing else */ }
signals:
  void rightButtonPressed(QListWidgetItem *item, const QPoint &pos);
protected:
  virtual void mouseReleaseEvent(QMouseEvent *e);
};

class ArrowButton : public QToolButton {
  Q_OBJECT
public:
  ArrowButton();
  void setArrow(QPixmap &arrow);

private slots:
  void updateArrow(bool on);

private:
  QPixmap iArrow;
};

// --------------------------------------------------------------------
#endif
