/*
 *  filter.c - Filtering mechanism
 *  
 *  Copyright (C) 1999 Robert Cheramy <tibob@via.ecp.fr>
 *  Copyright (C) 1999 Andres Krapf <dae@via.ecp.fr>
 *
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#include "filter.h"
#include "utils.h"
#include "data.h"
#include "init.h"

extern struct AllLogsType * pAllLogs;

/* is host on subnet address/mask ? */
int isonsubnet(u_int32_t host, u_int32_t address, u_int32_t mask) {
  if (((address ^ host) & mask) == 0)
    return TRUE;
  return FALSE;
}

/* look if the packet should be selected and handle it */
void dofilter (struct ip *p_packet) {
  struct AllLogsType * pTempLog;

  for (pTempLog = pAllLogs; NULL != pTempLog; pTempLog = pTempLog->Next)
  {
    struct s_filter *p_filtertemp;
  
    /* Look if packet should be logged */
    /* first look IP Source */
    for(p_filtertemp = pTempLog->Filter;
	p_filtertemp != NULL;
	p_filtertemp = p_filtertemp->next) {
      /* Should ip_src be logged ? */
      if (isonsubnet(p_packet->ip_src.s_addr, p_filtertemp->thost.ip , p_filtertemp->thost.mask)) {
	/* Does ip_dst match this filter ? */
	if (isonsubnet(p_packet->ip_dst.s_addr, p_filtertemp->ohost.ip , p_filtertemp->ohost.mask) == p_filtertemp->olog) {
	  /* Log or Ignore packet ? */
	  if ((p_filtertemp->tlog & SRC) == SRC) {
	    /* log ip source, so it is output data (upload) */
	    data_add(pTempLog, p_packet->ip_src.s_addr, 0, ntohs(p_packet->ip_len));
	  }
	  /* Match found, no need to look further */
	  break;
	}
      }
    }
    
    /* then look IP Destination */
    for(p_filtertemp = pTempLog->Filter;
	p_filtertemp != NULL;
	p_filtertemp = p_filtertemp->next) {
      /* Should ip_dst be logged ? */
      if (isonsubnet(p_packet->ip_dst.s_addr, p_filtertemp->thost.ip , p_filtertemp->thost.mask)) {
	/* Does ip_src match this filter ? */
	if (isonsubnet(p_packet->ip_src.s_addr, p_filtertemp->ohost.ip , p_filtertemp->ohost.mask) == p_filtertemp->olog) {
	  /* Log or Ignore packet ? */
	  if ((p_filtertemp->tlog & DST) == DST) {
	    /* Log IP destination, so it is input data (download) */
	    data_add(pTempLog, p_packet->ip_dst.s_addr, ntohs(p_packet->ip_len), 0);
	  }
	  /* Match found, no need to look further */
	  break;
	}
      }
    }
  }
}
