<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'include/i18n.php';

AuthCheck("tech");
commonHeader(_("Knowledge Base") . " - " . _("Article Preview"));

/* Start error checking */

if ($question == "") 
{
	$error = 1;
	__("The following error occured with your request for help:  You did not enter any question.");
	PRINT "<br>";
}

if ($answer == "") 
{
	$error = 1;
	__("The following error occured with your request for help:  You did not enter any answer.");
	PRINT "<br>";
}

$categoryname = kbcategoryname($categorylist);

if ($categoryname == "") 
{
	$error = 1;
	__("The following error occured with your request for help:  You did not enter any category (You may not post Knowledge Base Articles in Main).");
	PRINT "<br>";
}

if (@$error != 1) 
{
	__("Please check that the article you are about to submit is correct.  If it is not, use the provided links to re-edit it.");
}
else
{
	PRINT "<br><b>";
	__("Errors occured with your request for help.  Your only option is to re-edit the article.");
	PRINT "</b><br>";
}
$question = htmlspecialchars(stripslashes($question));
$answer = htmlspecialchars(stripslashes($answer));
?>
<hr noshade>

<?php
PRINT '<form method=post action="'.Config::AbsLoc('users/knowledgebase-article-add.php').'">';
PRINT "<input type=hidden name=categorylist value=\"$categorylist\">";
PRINT "<input type=hidden name=question value=\"$question\">";
PRINT "<input type=hidden name=answer value=\"$answer\">";
if (!isset($faq))
{
	$faq = '';
}
PRINT "<input type=hidden name=faq value=\"$faq\">";
?>
<input type=submit value="Re-edit Article"></form> 

<br>
<?php
$htmlquestion = nl2br($question);
$htmlanswer = nl2br($answer);
$categoryname = kbcategoryname($categorylist);
printf(_("Category Selected was: %s"), $categoryname);
PRINT "\n<BR><HR><BR>";
PRINT "<strong>";
__("Question:");
PRINT "</strong><br>$htmlquestion<br><hr>";
PRINT "<br><strong>";
__("Answer:");
PRINT "</strong><br>$htmlanswer<br>";

if (@$error != 1) 
{
	PRINT '<form method=post action="'.Config::AbsLoc('users/knowledgebase-article-add.php').'">';
	PRINT "<input type=hidden name=categorylist value=\"$categorylist\">";
if (!isset($modify))
{
	$modify = '';
}
  PRINT "<input type=hidden name=modify value=\"$modify\">";
  PRINT "<input type=hidden name=commit value=\"1\">";
if (!isset($ID))
{
	$ID = '';
}
  PRINT "<input type=hidden name=ID value=\"$ID\">";
  PRINT "<input type=hidden name=question value=\"$question\">";
	PRINT "<input type=hidden name=answer value=\"$answer\">";
	PRINT "<input type=hidden name=faq value=\"$faq\">";
	PRINT "<input type=submit value=\"Add Article\"></form>";
}

 
PRINT "<br>";
commonFooter();
