(in-package :crypto-tests)


;;; standard tests

(digest-test "" "DA39A3EE5E6B4B0D3255BFEF95601890AFD80709")
(digest-test "a" "86F7E437FAA5A7FCE15D1DDCB9EAEAEA377667B8")
(digest-test "abc" "A9993E364706816ABA3E25717850C26C9CD0D89D")
(digest-test "message digest" "C12252CEDA8BE8994D5FA0290A47231C1D16AAE3")
(digest-test "abcdefghijklmnopqrstuvwxyz" "32D10C7B8CF96570CA04CE37F2A19D84240D3A89")
(digest-test "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq" "84983E441C3BD26EBAAE4AA1F95129E5E54670F1")
(digest-test "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" "761C457BF73B14D27E9E9265C46F4B4DDA11F940")
(digest-test "12345678901234567890123456789012345678901234567890123456789012345678901234567890" "50ABF5706A150990A08B2C5EA40FA0E585554732")


;;; bit-level tests from NESSIE (http://www.cryptonessie.org/)

(digest-bit-test 0 #x80 63 "C80B973C1157A7FE4F4150AD4C2A932494BF7BC7")
(digest-bit-test 0 #x40 63 "56B60A86C48BF35C2688B2B4E44E906C22221CF6")
(digest-bit-test 0 #x20 63 "F07DC15D139E20B569D018C517EA697434CB35AE")
(digest-bit-test 0 #x10 63 "CF3E842C69F06D3BC769367BC4B4F6E57B5496E5")
(digest-bit-test 0 #x08 63 "96429B7BAA941F24306C1F9103FE2B454D1323B2")
(digest-bit-test 0 #x04 63 "F8A7C819FA7A7CC6C08376001F6F7C30DC52837D")
(digest-bit-test 0 #x02 63 "78ADA92E4FEFC60B100EE2AF775B05520823B020")
(digest-bit-test 0 #x01 63 "9C8D8E5A31C9802B093C4116DFB0A23A311B8029")
(digest-bit-test 1 #x80 62 "7D43DAA11204FC356565AA3C6D05ACA04D9870C7")
(digest-bit-test 1 #x40 62 "E6B75E72075112399E5BF80A9A9CFBF6049EB5D2")
(digest-bit-test 1 #x20 62 "B445E64D88F2633490FA0EEB349D7FAC9747C8F4")
(digest-bit-test 1 #x10 62 "038C8FD9D653E91399EEBB87DFA2DD801B2B34A5")
(digest-bit-test 1 #x08 62 "DDA4821E8441BC1CA66D18A2EAAE4A6D0A495228")
(digest-bit-test 1 #x04 62 "499E5250D504F77DAE8196D52B399EDE52B19BC5")
(digest-bit-test 1 #x02 62 "CFEE25E054425F4989F1E6EFD3E1F3633FFD2D5E")
(digest-bit-test 1 #x01 62 "01F033F733AD52897A5F85743631D2C5A24DF29D")
(digest-bit-test 2 #x80 61 "8F16CF5C70AB51ED9CDB44312EAEAD39C3EC2E52")
(digest-bit-test 2 #x40 61 "740B98B60EF34F120E38818427D72187CD5DF4DA")
(digest-bit-test 2 #x20 61 "D0723C0AFF5876687A7B8CB6D0C45E6CDFE398C0")
(digest-bit-test 2 #x10 61 "BF2AA88116C9BBA41E76C4835A8DDD0C2822A5FE")
(digest-bit-test 2 #x08 61 "6EBF3F3419C3CCC586344CF24E07050A8D5E5AAA")
(digest-bit-test 2 #x04 61 "1DED9734A2A6497F545537F50E162B707EBBECEE")
(digest-bit-test 2 #x02 61 "E0150DD6726DCEC7EECF0675A7FC998A98D43852")
(digest-bit-test 2 #x01 61 "C85602D666EC3B89FFBC8D496447113D15B15910")
(digest-bit-test 3 #x80 60 "11945DDD1210E9720335BAA588911F0DD22A75F8")
(digest-bit-test 3 #x40 60 "3F085871E93D27CA79BA3CF549F4F14E925B47EB")
(digest-bit-test 3 #x20 60 "1EAF14B33C7CCA699DAD92C8514BDF68B01CCB40")
(digest-bit-test 3 #x10 60 "09444FABB51E6FE7D4452E79D1063B4A8E3E4D82")
(digest-bit-test 3 #x08 60 "87D02B5C01451B2E71917D51C078C522CECF3E0B")
(digest-bit-test 3 #x04 60 "2168E7CE44E725A2723542EF9BD06FDA7A7E7C8F")
(digest-bit-test 3 #x02 60 "2E9C528E8E7F79FF214EB169D8A4C9762125373A")
(digest-bit-test 3 #x01 60 "80762AC3A2C6589B32FBD1B5EDF9CF04B1B2215C")
(digest-bit-test 4 #x80 59 "AC293B9701FEF4DDDAC98EA2B6024719642D26BB")
(digest-bit-test 4 #x40 59 "6C7DBCCA072D9FB9096F0CB316F519DA899173E0")
(digest-bit-test 4 #x20 59 "5B5E8B8FD142866535F68E59D4FE77CB05FD9CE1")
(digest-bit-test 4 #x10 59 "42875F6AF7B7651D0C8385B425DB3FFD99550102")
(digest-bit-test 4 #x08 59 "694D8BC576F66ADE600CB6984EA7A7260CC44F14")
(digest-bit-test 4 #x04 59 "FE26D65A5424E8A8B3D3F5F1C34B9B5062BAF56E")
(digest-bit-test 4 #x02 59 "3371E839A02AADAD47C7CCA1B2E2533F2767F422")
(digest-bit-test 4 #x01 59 "4168FA28936F4B1033A4E19D0A12DA2DDD47C244")
(digest-bit-test 5 #x80 58 "24FFD42C1B342AA89E041B37755B337879ED7CA7")
(digest-bit-test 5 #x40 58 "1C0913FFD921BEF41BD7462358E086227294B183")
(digest-bit-test 5 #x20 58 "48C97D9F0E0C7B29130646BE6A56D4B2646EDB88")
(digest-bit-test 5 #x10 58 "D6777E499284128D7F6E37D730D0E3FEA173E438")
(digest-bit-test 5 #x08 58 "D032E3F7EF5669B263F474E3CCAC671CDBBAF8AB")
(digest-bit-test 5 #x04 58 "97C80A4D5A89B79294C35CD6763B2E9C757545C7")
(digest-bit-test 5 #x02 58 "15595DE8404B06AEB0AC4F5460741C5EC4618A6A")
(digest-bit-test 5 #x01 58 "E35EAC18F548B2213043E2071E8A3328073E3B0D")
(digest-bit-test 6 #x80 57 "D9CFDC0AFF96B9553CF7E3043D9276A434615E96")
(digest-bit-test 6 #x40 57 "0A99C997839E36B53BC61E11978D44052527891E")
(digest-bit-test 6 #x20 57 "F6D409B550C2EF3271D07D50ECF0AD2D88700619")
(digest-bit-test 6 #x10 57 "DEED66BF0A4E4043D3811EA8BA0326704C334B0F")
(digest-bit-test 6 #x08 57 "2567B864FD878473495FD335AECEA89FCCDF2673")
(digest-bit-test 6 #x04 57 "EB8BFF11ACD9A2E62CBEF9CD5A61697E5D5316D9")
(digest-bit-test 6 #x02 57 "C7F2D49AAA96200A373890516DC9320819416808")
(digest-bit-test 6 #x01 57 "B529D29A35A660A26B1D940EB48B3F29983F12C2")
(digest-bit-test 7 #x80 56 "55BB9C4F4175807789AB8C7E23CACFE2F8CF7031")
(digest-bit-test 7 #x40 56 "0E4FE8A0F3E5D3E415B93E85924FF96684EDD04B")
(digest-bit-test 7 #x20 56 "0CC5775BEF98969EAA8B1DF3BEDD1E305825D076")
(digest-bit-test 7 #x10 56 "1A455AD4ED941623B6A3FE01B16C1AB10C0AF1A4")
(digest-bit-test 7 #x08 56 "BC112941C3736D8608572454BC3B9B81E4F00ECD")
(digest-bit-test 7 #x04 56 "38846E9960050E14E883B55D84DB7F01215355AF")
(digest-bit-test 7 #x02 56 "087894D777079923A1F335B5CFF64EEB020B9831")
(digest-bit-test 7 #x01 56 "455BBDE02D1E9648A3C5D6B2B0BBE09B1167AB9B")
(digest-bit-test 8 #x80 55 "E09044703F1C8F36B359CB4F88D9183E2626795B")
(digest-bit-test 8 #x40 55 "A7B4E0ED99C4FF63BF6008E07AC09C0C812BAE1B")
(digest-bit-test 8 #x20 55 "3A11D6DDA00DB4C776E3FC7B6464679283E85F9A")
(digest-bit-test 8 #x10 55 "631C575338C15E3F7938F30619E17BD3F93B3C89")
(digest-bit-test 8 #x08 55 "EE5C5EA82DE03CC13772A1D41520F5771A2D54BA")
(digest-bit-test 8 #x04 55 "6C9A8F934DB6F888D6F9BD47DE8D18E97AEF836E")
(digest-bit-test 8 #x02 55 "A1332E2DD7913BD57AF24F0F9179D73D72480809")
(digest-bit-test 8 #x01 55 "0DBCC21D171566F731595798084806D37E301461")
(digest-bit-test 9 #x80 54 "E6C51116961912F5314CFFA544A6DE2B24AB90D5")
(digest-bit-test 9 #x40 54 "E6250ADF0AEC03FA20EA071B0FBD35B069E706C5")
(digest-bit-test 9 #x20 54 "325B2FA3C59CE312460897453FF74318877C6B72")
(digest-bit-test 9 #x10 54 "DEE1C0C3387D7D8C31867F1BA6AF34026D49E1D7")
(digest-bit-test 9 #x08 54 "BF533F21E4E65065AF6B3EE144683A80BF925D4B")
(digest-bit-test 9 #x04 54 "B9E4A4E179F9198A2ABFEFAB564C27EA3C6D5F52")
(digest-bit-test 9 #x02 54 "9D892745D3179215EE1D2EA9898A3AB758DD63E9")
(digest-bit-test 9 #x01 54 "3506520468939295101A6EA95E427F762720DFE9")
(digest-bit-test 10 #x80 53 "4C8D7DC1DBF470B879ABFC6DB168899AE10F70BC")
(digest-bit-test 10 #x40 53 "C426EBAA58B03228871719AA5FCB30B05BF740C9")
(digest-bit-test 10 #x20 53 "5AA07142574F0AA5AE4FD7B5A51EB9AA63C1EB42")
(digest-bit-test 10 #x10 53 "56280BC7492BC80A2AD438E42C5C3956DC30E097")
(digest-bit-test 10 #x08 53 "967580251AC2A105E964C97DA71A1FEBA94A68AF")
(digest-bit-test 10 #x04 53 "158B4D9BA108126FC615A75C18228120D7D1969E")
(digest-bit-test 10 #x02 53 "119DAB5498C9D2E0240C21B9EEFF2D384F350855")
(digest-bit-test 10 #x01 53 "59C36C62CA45E8C5CB3E20747B19EE899E3DFB00")
(digest-bit-test 11 #x80 52 "A2D8594658B47709E739AFDA17E32174FC22D293")
(digest-bit-test 11 #x40 52 "C7646820D8315F820EE5DAAF48A32E10CD942617")
(digest-bit-test 11 #x20 52 "46EBF4A676804A632551E82BE4B57BD5CA435058")
(digest-bit-test 11 #x10 52 "941FEE8AFFDCE92C7B0C0C9F53935250D1606D2F")
(digest-bit-test 11 #x08 52 "4E79BF4BC6F098285196C9F624113476C002FC50")
(digest-bit-test 11 #x04 52 "1EF86E0EEA541C8C374817BF6BF07278D3EFFEFC")
(digest-bit-test 11 #x02 52 "C24BE886919E9FEC48294C5E2C7F7BBD5332565D")
(digest-bit-test 11 #x01 52 "6C99FCD7E1F6855EED92C2A7D1F3D3D9F6E8AD87")
(digest-bit-test 12 #x80 51 "E756DA506BFC4A04465D5D7DD4C205E946485B22")
(digest-bit-test 12 #x40 51 "FD4E900DE3342EE985823CBE347D7ABFF0085087")
(digest-bit-test 12 #x20 51 "CDB5CFE636C4F385E133D9422E38AE177DDF607E")
(digest-bit-test 12 #x10 51 "F40B90D9CFD60CD39C1CF1C5ED6A6BE9B4C81EC5")
(digest-bit-test 12 #x08 51 "F82DB7F598A7A746B90E7F0FAFB95B69C98D9C39")
(digest-bit-test 12 #x04 51 "B9BED915E0015F533E4C47A65264BF7DDDB2C7DD")
(digest-bit-test 12 #x02 51 "77B7CD2112666C5C49C9326BA18EA9B7E01912CE")
(digest-bit-test 12 #x01 51 "4C0CAC3DE798E7667519CBD8313562D32CB3F666")
(digest-bit-test 13 #x80 50 "32419E5FC2008472AC4F46B03E905DFBD8357B60")
(digest-bit-test 13 #x40 50 "D6B3831658FDD1185971EA835D071FA672220080")
(digest-bit-test 13 #x20 50 "71DB19334F8216306F414D16ABB810D5F887EEC6")
(digest-bit-test 13 #x10 50 "4EF16FC64A42E04BA42070BD52C7B331A8D7B33C")
(digest-bit-test 13 #x08 50 "2773F7D0174EDA2BABC2E658D4112E1ECEED7C4D")
(digest-bit-test 13 #x04 50 "3C9EC7C855FC076D4E93446B0B97881614AE69C4")
(digest-bit-test 13 #x02 50 "C05B6BCCD76C842939C824BB7062837D606DC774")
(digest-bit-test 13 #x01 50 "7FC1463FC5E883A8783E83BA2AED9477140CEFC7")
(digest-bit-test 14 #x80 49 "23CA389ADC702949AFDC8CE40B6CE7CB88A1DA02")
(digest-bit-test 14 #x40 49 "25D9C3078E383115720D33841E04590E03FDDB85")
(digest-bit-test 14 #x20 49 "5749378C96E41C974AB6EB82720F795CE2822FF4")
(digest-bit-test 14 #x10 49 "24F8E36845E10A853528181AD6EB1649657123B7")
(digest-bit-test 14 #x08 49 "45CB9C18DA6F7ED31007F7F7AE1AE49CE685BE67")
(digest-bit-test 14 #x04 49 "B26C1E83F82D92ADC5787069EA64A97EAEB05449")
(digest-bit-test 14 #x02 49 "9ADEF89F604BCEE1A318F0F9AB93460D3F03DD3B")
(digest-bit-test 14 #x01 49 "CA02BF109DD63BAD6210E37DD0436F91BA94F33B")
(digest-bit-test 15 #x80 48 "B4DA276DDFA7179F9E1557343D30FC553F61C485")
(digest-bit-test 15 #x40 48 "3E003A83B8694BCC857A628447DD83D4B1B4B255")
(digest-bit-test 15 #x20 48 "CFAA4C7F76DCEA939513C08DFAC97C7D350EBA04")
(digest-bit-test 15 #x10 48 "004C40DD366F88F9FDDD83771C05B48B66DCD70C")
(digest-bit-test 15 #x08 48 "BEC1E4B13505FC884DE92454B178481ABC2BFA59")
(digest-bit-test 15 #x04 48 "E7CCBEF62B98CB5597DF9B14B8AC8F8B0C97F518")
(digest-bit-test 15 #x02 48 "7B0215FAF7F0443BE069C9278286165E26CBCF73")
(digest-bit-test 15 #x01 48 "108CE1122EB0C82633F976CA2EFA026BBA959308")
(digest-bit-test 16 #x80 47 "975C113EC6E5A2C1D6D79478A109040E2751D43F")
(digest-bit-test 16 #x40 47 "B61659219A809E80C7ED3D7846F6F3F3BEE7089A")
(digest-bit-test 16 #x20 47 "B8278481A63BF09E1418081155AE7E5261E1A241")
(digest-bit-test 16 #x10 47 "AC46AEABE0A215D11130DFBB031A1222C055EC7E")
(digest-bit-test 16 #x08 47 "6531C0A7931C275B4F632EF8093919DF9313C4F5")
(digest-bit-test 16 #x04 47 "C74538BD718108640DB915639119F04D72C3F096")
(digest-bit-test 16 #x02 47 "F3144CC8D9A20E480E4E58DA30ACFEE56D591CFD")
(digest-bit-test 16 #x01 47 "98556435801AA5697D810F8473630343A1B31A61")
(digest-bit-test 17 #x80 46 "DA48390CD34E4B6128B0164BD47120E098CCC32E")
(digest-bit-test 17 #x40 46 "0E5758502FAB4FAC56076ECBC3E3434184CD81D1")
(digest-bit-test 17 #x20 46 "C6AD9BDFC1A609434A034987B95DF0A95F16AA09")
(digest-bit-test 17 #x10 46 "6B7EDE476CEFDCFD23C99A2507C7289C703CC52A")
(digest-bit-test 17 #x08 46 "8EBED867CA66DF27A46CFD0DF20C836EF5A46C2A")
(digest-bit-test 17 #x04 46 "0D1A9561D0E873FEDE31413352A8C6877431662B")
(digest-bit-test 17 #x02 46 "71DC3FD33E02157B10FCBA37BE9424783098890E")
(digest-bit-test 17 #x01 46 "700BB77FF59F2F0EA7770106EA4ED5D45A86E2CD")
(digest-bit-test 18 #x80 45 "F657B3ED77505CDAFFCA43B21549A5D9426306C9")
(digest-bit-test 18 #x40 45 "661C99496AED852B153656EC8B26EF26366395AC")
(digest-bit-test 18 #x20 45 "5B95A6DA71F704BF5A432D1987EBF996996043CC")
(digest-bit-test 18 #x10 45 "A97DD84F3159897B8369F7D7CCC0C1B32D2C397B")
(digest-bit-test 18 #x08 45 "891799A91B5D53171B3FC831B0AEB08969206365")
(digest-bit-test 18 #x04 45 "C9109757AA36E1856C660A2B52183EA5CF50F0D8")
(digest-bit-test 18 #x02 45 "4FCD24B654212348D52FDCF0C0942737F997E6FA")
(digest-bit-test 18 #x01 45 "D1397B8A4066E2168FD8AADE3EE10CA203CF17CF")
(digest-bit-test 19 #x80 44 "349FBC1CCBF6069A09A8FC7995C069E32DE61F0B")
(digest-bit-test 19 #x40 44 "A2CDC16FE423A24901918C97398D1B961CFC316C")
(digest-bit-test 19 #x20 44 "317843ABBDC2B0953E4FA0904733F4242D7947E0")
(digest-bit-test 19 #x10 44 "0D7FFF1FF47D64E3E48D7282B34BF6747284B415")
(digest-bit-test 19 #x08 44 "78F1BE3F2CE991B8DA39691A5604B9E635611DA4")
(digest-bit-test 19 #x04 44 "F9ABB648ADB9141E575B8EB55D19A7C3D668E77E")
(digest-bit-test 19 #x02 44 "E4F6C06F5EE755AF403815180F77B928E4825517")
(digest-bit-test 19 #x01 44 "7E012352BA1CC23980832C211BBE905B20500589")
(digest-bit-test 20 #x80 43 "BC8B0C78E3881EB468080BA61399C19A57E37722")
(digest-bit-test 20 #x40 43 "129B6F6CCD15EA61F479D5BAB6D3AF9A6ECBE8F8")
(digest-bit-test 20 #x20 43 "274CBEEA6E5437DE4E1C509A2D7898192D1190C9")
(digest-bit-test 20 #x10 43 "7D2E8445D5AF45B4234C662D7365DE0FDE3F137A")
(digest-bit-test 20 #x08 43 "09778AE85FB61B38629ADA752E43968CFDEA9735")
(digest-bit-test 20 #x04 43 "FFAC48B01BDDD251E36EC2117FE4D7FB3E2DAE88")
(digest-bit-test 20 #x02 43 "BF7F915990E45208E2115494C3C84B54E3F94D1A")
(digest-bit-test 20 #x01 43 "BCEBAE614742D8B4EA82342D41081B9477AF1298")
(digest-bit-test 21 #x80 42 "38ADB2132156AD53D301331100DC40E1A8B5061A")
(digest-bit-test 21 #x40 42 "EA743C69E66472733131F459195BEC8AF9226306")
(digest-bit-test 21 #x20 42 "847E47943D04B434A66BF9BD9B0703A1E480F9F5")
(digest-bit-test 21 #x10 42 "BB62CE0B4DDC49A425C9020C558EA08613C304ED")
(digest-bit-test 21 #x08 42 "2183FBE664BEECDADC7A01EEBBFB5948AAB60A6E")
(digest-bit-test 21 #x04 42 "0B80D23DF470BB06F2519E17C03002CC0AD4F2CC")
(digest-bit-test 21 #x02 42 "FDDD3E02E14360F5DB82D9791E42087B4FC86AF2")
(digest-bit-test 21 #x01 42 "49BB25180763123AC51C3BC43C7DDBC32D778FE4")
(digest-bit-test 22 #x80 41 "4D34E126B4F06392A6648DAA3DBA9F48C128B9B1")
(digest-bit-test 22 #x40 41 "7D90EBA93DF3A8E8AAF26F42AA3B87246A4C2086")
(digest-bit-test 22 #x20 41 "B6919E57AABDD131F4B01A8CA3CD5DEE4EC0ED85")
(digest-bit-test 22 #x10 41 "AB4CF9C77E130A221852FC35623DD8B056FA7A00")
(digest-bit-test 22 #x08 41 "9C2F76C3FB5ED565DE41FD703227B420E9BBDA64")
(digest-bit-test 22 #x04 41 "3BA8BC25929043F59402ACE9C9E57758C2A1037D")
(digest-bit-test 22 #x02 41 "722073DD703E1E9AC88AD3D0F1E267479BCBFAB3")
(digest-bit-test 22 #x01 41 "94D62AD63B4DFA23208CE1EA8F95F114F023C58A")
(digest-bit-test 23 #x80 40 "F9DF96D378B1992100EED2DF0D4D349A17F6EB93")
(digest-bit-test 23 #x40 40 "CD83248D90959C86D383C0E9A7A722AA8C9D4688")
(digest-bit-test 23 #x20 40 "BC548A565154A6694995B5BFA59423D65F3A8981")
(digest-bit-test 23 #x10 40 "E8A080EE63161372523FB08370F525FEF7535C43")
(digest-bit-test 23 #x08 40 "203B3667F5227B2ED4EE398A9078E840B25289F4")
(digest-bit-test 23 #x04 40 "9196A67C90584CC300100BBCFF5DDC6FD71A2405")
(digest-bit-test 23 #x02 40 "7D540DC309A2597BFD5B5AE0C4DCD926E49F4920")
(digest-bit-test 23 #x01 40 "3060E082B61E4C6EC0D4030C17817453D69D9285")
(digest-bit-test 24 #x80 39 "E1BF28EA2645C40BF120B26D7AB4FC5A1EC254A8")
(digest-bit-test 24 #x40 39 "9BAA92BCA186E8C5948CAE54F88D09F2AEC14D7F")
(digest-bit-test 24 #x20 39 "18BA5CA9513B130CE92453FF36A5A0D2FAA9A476")
(digest-bit-test 24 #x10 39 "DBED362F2B76BBF6FA58E18D29397A95F0FA0112")
(digest-bit-test 24 #x08 39 "E2E1A4BBDED9D5FA2DA200B233E2186630396F57")
(digest-bit-test 24 #x04 39 "4211DC41833E093510D395A5B14BB96D64C38D92")
(digest-bit-test 24 #x02 39 "E726FCCE510DF503CE82640AC1F7AB28C19D7C46")
(digest-bit-test 24 #x01 39 "D702CBE5864F3B07AFFC43367136D69A1F2B8D42")
(digest-bit-test 25 #x80 38 "54B17EE781A17EDC3B4C420D78F83C7C978F3CAB")
(digest-bit-test 25 #x40 38 "49C732AF40F4A74D780D4250267706F7FB1A6C47")
(digest-bit-test 25 #x20 38 "17DDCE095E7D0CFD5F795AB462EDFCC116B7E532")
(digest-bit-test 25 #x10 38 "D0C2B1BF2F99F8D107800A78C414701FC1A842F6")
(digest-bit-test 25 #x08 38 "43027A3615D6C7A83D14581535FBACAA36572ADD")
(digest-bit-test 25 #x04 38 "DD40216A698A881B04541E2405CF43D38BD62D61")
(digest-bit-test 25 #x02 38 "A14ED13406E4751DF32F0C6F1BD82F03B0D335DD")
(digest-bit-test 25 #x01 38 "30600629A515EA95FADAA13E33CC4F1C6D2E7EE5")
(digest-bit-test 26 #x80 37 "D8003007E44D39E16CBF0A0B7BB72E523705FF35")
(digest-bit-test 26 #x40 37 "090919153F6F2B0B7414013B00F29BA16C3F6ED4")
(digest-bit-test 26 #x20 37 "A9F90B4F50C93EC61148D8A0AC41B10CBBD42C51")
(digest-bit-test 26 #x10 37 "56F121A340DE79356F95BE7E371C4214643A92FD")
(digest-bit-test 26 #x08 37 "CCFA24CFD91E151AA67B88120B6E3E6F252F41BE")
(digest-bit-test 26 #x04 37 "DF66AF08C35C0DDD6FAA088CEF132466022F1CAD")
(digest-bit-test 26 #x02 37 "E081C6CC8E45EB60EC5EF41F56255BAC13546D06")
(digest-bit-test 26 #x01 37 "AEC50B2FEFD190011516392B43B61E86C9F4F779")
(digest-bit-test 27 #x80 36 "D9D04DCDF5855C520BF87ACCF7C86AD48E648935")
(digest-bit-test 27 #x40 36 "21A6A0044B5F5BFFA8245672EB0C0AC70CAF9757")
(digest-bit-test 27 #x20 36 "EB9B20C75D2DE45B58049D0A7B7AC42A21E14161")
(digest-bit-test 27 #x10 36 "84569C7E024FDA33562804ED1F1959CD60C1537E")
(digest-bit-test 27 #x08 36 "D6A143BBE76833DDBA3B2F2BD8481C1F0FEFA59F")
(digest-bit-test 27 #x04 36 "26D802656E0E29EAA263CD58FF39CD8D08567A1C")
(digest-bit-test 27 #x02 36 "A8A2791D33CC80A935F07744012667E989E19805")
(digest-bit-test 27 #x01 36 "1B2AC35A2425E935D1B4398D72313306586E77DB")
(digest-bit-test 28 #x80 35 "A89C88DD8D3057BB49344BA9D7D274986BDAC954")
(digest-bit-test 28 #x40 35 "48D0F840967AF3F7F67162B04467996F7E0248AD")
(digest-bit-test 28 #x20 35 "1E2355A26E6E96391A6CBB14F41790743EB65D3D")
(digest-bit-test 28 #x10 35 "6580E48E6E1F51CC4FA2B65D74C8183B59F69A6A")
(digest-bit-test 28 #x08 35 "0C4E898BB1CD11C1FBE41A434A2A73697E2A39EF")
(digest-bit-test 28 #x04 35 "F4261C323CEFAEE5CDA5F20275BFB4B62D8206B8")
(digest-bit-test 28 #x02 35 "1A4788A361CECCED29EFEAC51FF8F6BB68DFDED4")
(digest-bit-test 28 #x01 35 "2C414B96A80B2BE5D1A6E1A29DD24E68FB7EF776")
(digest-bit-test 29 #x80 34 "5B8C03EF6CCBF12DF96F9D46DEF25C497EB8E4EF")
(digest-bit-test 29 #x40 34 "509A557F6D594B365626EC8A836468DEF7BA1970")
(digest-bit-test 29 #x20 34 "4A5BB3D4B6336D2BC02E60BDA63195F07A767B62")
(digest-bit-test 29 #x10 34 "4B52399A9FE907CDBE8370F1F7F28F8884DB5B70")
(digest-bit-test 29 #x08 34 "310775D674A5A05F9F6FB70CDDD3C9EF68A6ED8D")
(digest-bit-test 29 #x04 34 "10F543F139A0F6BC2B8051974222D4870C79A050")
(digest-bit-test 29 #x02 34 "890E02391B11FAB9602F0EE18B0CA0A34AF425F5")
(digest-bit-test 29 #x01 34 "9DEA28EC04E1A9BDDE165FB81B9E123256CBB876")
(digest-bit-test 30 #x80 33 "4972106BA1ECEFD0C55068120585EF2D94239CBE")
(digest-bit-test 30 #x40 33 "787F7049BB78E3712E5B9B4F447DB38D2A42DA67")
(digest-bit-test 30 #x20 33 "3E8E2C84DE92183C61419BE04FF01A26ACEF9EA9")
(digest-bit-test 30 #x10 33 "DCF8E1EDB48F42331F5DD50C06269F51A1C7B2D5")
(digest-bit-test 30 #x08 33 "BDEAEDC13E7010849D258AA7C9BE0206F95C853A")
(digest-bit-test 30 #x04 33 "36AA3434BAD394718B21ACDF6EC2526F51627948")
(digest-bit-test 30 #x02 33 "E6EE7041303A55D95BA3093507F58F5DA10B8254")
(digest-bit-test 30 #x01 33 "380CC98BD9C83AA09DC30DB59C3029A3ECBA5C1C")
(digest-bit-test 31 #x80 32 "9B928D8148F4114F158E46824E766FF2A7A62B34")
(digest-bit-test 31 #x40 32 "F33FAC77F2A2036C6116D19EFBCF07B1C0F38FAD")
(digest-bit-test 31 #x20 32 "1CA9B7E149C031EE02C254182A90B62547DB6AA4")
(digest-bit-test 31 #x10 32 "B1DB2B2305B65A1421B7084A78F97FF2D227865B")
(digest-bit-test 31 #x08 32 "BAC51FAAADF6127971F210E8EDDBE17E99E17993")
(digest-bit-test 31 #x04 32 "D26C92EAD620313A4B21CDACF0F32287BFD21F74")
(digest-bit-test 31 #x02 32 "D7A7B4D4D0CA22EEC9D2E7CB1D8FDE422225483C")
(digest-bit-test 31 #x01 32 "F936AF09029B1E14CDDB9387E8362EB29A436A0B")
(digest-bit-test 32 #x80 31 "C335854A19D6B6B099AA4145E1CD9658DAC4B60F")
(digest-bit-test 32 #x40 31 "B8EA6301BA799CAEDF54DED2F4E04253E1831D8F")
(digest-bit-test 32 #x20 31 "6BEA287617579A5B351CDDC18D14E1CF0E695250")
(digest-bit-test 32 #x10 31 "AD6C45B1CD47B6C705D3B75CCF90AC0D1915686C")
(digest-bit-test 32 #x08 31 "6EB575E8412D916DF0AC6FFDBB5CC79EBA83DCE5")
(digest-bit-test 32 #x04 31 "226D1AC28AB39B62D24E2B80BAF4D9DBA0B1C755")
(digest-bit-test 32 #x02 31 "A109D1D9CFD7800D310BCBA64E2F1300C7367734")
(digest-bit-test 32 #x01 31 "37B7DCF21E0E183A9A86170997DF242A84A85FF7")
(digest-bit-test 33 #x80 30 "C3E28649F4C02F21C4CD5D8E27D4E3D67016C2AC")
(digest-bit-test 33 #x40 30 "79889011EDC1EE59541FD593B24B4AA905BD17C4")
(digest-bit-test 33 #x20 30 "4E1D04704B703757389B3C91FB05D2AA7E2D9043")
(digest-bit-test 33 #x10 30 "A86CB3BFB25AE2F28C063E6B88CFFD8C37850CF6")
(digest-bit-test 33 #x08 30 "093FFB88A184EA1E0F81E244E40A13449CEC646E")
(digest-bit-test 33 #x04 30 "EC7D66DA9C3FA2CCA0365E2AD3E2A78BD59DB1BB")
(digest-bit-test 33 #x02 30 "F8EFA4B89684A900E6A7DFBD8E76834074D3C653")
(digest-bit-test 33 #x01 30 "2B95691BE17BFEAC4911ED9C629B47DFA8729E1E")
(digest-bit-test 34 #x80 29 "93A743FC2BE88424D24B459475CF7579B6FE82D9")
(digest-bit-test 34 #x40 29 "C68E51DA0171770DFA3FA96234AEF2F53BC493BF")
(digest-bit-test 34 #x20 29 "3B74CC5D74226619E37F01EE83D2B48540CD734F")
(digest-bit-test 34 #x10 29 "AA08CCB4A80FA396B4E8D60F679EEC506B7B9A65")
(digest-bit-test 34 #x08 29 "A11E372982163EBFC67412B34B63D86FC3E83067")
(digest-bit-test 34 #x04 29 "605312FB9DCAFE0794773C6016E428EFA6F762D7")
(digest-bit-test 34 #x02 29 "112984BB5F7E77D2838A44D9166A01EB339E3C11")
(digest-bit-test 34 #x01 29 "2338180643FC2A6F60A8CB718DAC7E1639F57351")
(digest-bit-test 35 #x80 28 "F14B90992F4D5A1243BFC5A63C94C49590C46B68")
(digest-bit-test 35 #x40 28 "FFB6AD250782AE8C16F9A610973C77DFEF095F1C")
(digest-bit-test 35 #x20 28 "D1B731D084179C8D12E5365EFF7100BBECA13427")
(digest-bit-test 35 #x10 28 "96730C09F3AB3E06BBD64A4A42850877E7AE4293")
(digest-bit-test 35 #x08 28 "58F5585F58985EB95C7A3EF8561D5FFBBB60A6A9")
(digest-bit-test 35 #x04 28 "89DE54F734D3A6A3A2E05D9C58C630A9C25D4981")
(digest-bit-test 35 #x02 28 "5AB0D562986A32A334ECA6CC5B21433C18B7819A")
(digest-bit-test 35 #x01 28 "7E3D6DFE5A25FCC4A340D9CC5A998F0614688176")
(digest-bit-test 36 #x80 27 "18977350D746C049A89B49814682FBC8DAC9E28C")
(digest-bit-test 36 #x40 27 "93F5DEE808872B1ACB23F7CF21B5C7CB5EC7FC52")
(digest-bit-test 36 #x20 27 "015100CAE85185F42A48B70EB95AB0DE9AE118A4")
(digest-bit-test 36 #x10 27 "D12E261473BF1C68A961F34334DF31E164CD73A8")
(digest-bit-test 36 #x08 27 "D74FDFB0D814771E7B4B955C268D15B5AA99D72F")
(digest-bit-test 36 #x04 27 "CED846E7527C74653CD30D80E8097BBD8C29BCA6")
(digest-bit-test 36 #x02 27 "77A55E00E669E34FD0F9A16F2D16DEFC900EA466")
(digest-bit-test 36 #x01 27 "281F0F08687150F51218B5F9119CA082D4F3423E")
(digest-bit-test 37 #x80 26 "404BA3E3275F06E9FAC48C8D92F51E9AF4DF55D3")
(digest-bit-test 37 #x40 26 "97EB1BC7B8D1DFA3549B8A2E07595676163D09D3")
(digest-bit-test 37 #x20 26 "C099C6B7A8352BEB1262ECD02782BF4428FF69C4")
(digest-bit-test 37 #x10 26 "9D77E37FF377A4C222E7C81003051CD4DA9FE9EB")
(digest-bit-test 37 #x08 26 "C59DA8793931E9E4B930E100CDBB4C36EBF3ECA6")
(digest-bit-test 37 #x04 26 "BB6C8B6F3896DD85F33740404A834920E8AEA444")
(digest-bit-test 37 #x02 26 "DD366C91DE61D6B1581472C950C6D1223BC67CBC")
(digest-bit-test 37 #x01 26 "66071311DB52813C4F7F6538B28ED8EA38002555")
(digest-bit-test 38 #x80 25 "7FCB5E982D0475D029869F3947C25B1A55755589")
(digest-bit-test 38 #x40 25 "DE0ED84A276AA030B8EA70DC3C9CF295ADCCF007")
(digest-bit-test 38 #x20 25 "E6BED540761C6FDA38AC6DB6661D676DF7AFC71E")
(digest-bit-test 38 #x10 25 "829EADE04C28286AB3C589069D58B7226EBD15A3")
(digest-bit-test 38 #x08 25 "794F0FF33702723E8E6981F006632062CCC05D15")
(digest-bit-test 38 #x04 25 "8AFA385DBBDEE2BFA4FDCF01D047F3A131E08A67")
(digest-bit-test 38 #x02 25 "1E86C19A1A91270275C3E6E41CED9B7D4FF81133")
(digest-bit-test 38 #x01 25 "3ABBD0AD167CEE74D94CA4593B3C2EA74B9246C7")
(digest-bit-test 39 #x80 24 "6ED914AE39347E3A9A96080AAFBD497E33701866")
(digest-bit-test 39 #x40 24 "05CE2DD4AB125A0E913DFD514D9DD935B8DD3D62")
(digest-bit-test 39 #x20 24 "7C577206C0F66B2DF7ADB657B6AD528144913B26")
(digest-bit-test 39 #x10 24 "1D43ABCFCAE5E92A06796E7A751C8F569D88F7FC")
(digest-bit-test 39 #x08 24 "7B4CCFFD7E64AB1D7816CA43886EFE58CDE89B7B")
(digest-bit-test 39 #x04 24 "0F3D83BF05E509F3939B23C71D8E518E38A6C3C1")
(digest-bit-test 39 #x02 24 "223CB390EBBE15C117225A39DD45D7A9FC5B1D7B")
(digest-bit-test 39 #x01 24 "96AAC2F7DFA3FF387C3E12A53D8C51F93D362A44")
(digest-bit-test 40 #x80 23 "946F7992EF21D07B55B8CCCCB4840834CFC52492")
(digest-bit-test 40 #x40 23 "1254CEDA60C0DD56A06395D4B78A07A9A623CF8D")
(digest-bit-test 40 #x20 23 "4548994E655B8B63EC7761015C46BDAD46BBCA94")
(digest-bit-test 40 #x10 23 "A4DA64E02BB6FC6783254CCE92F4C28D79753F25")
(digest-bit-test 40 #x08 23 "8A213BDC144A8B6A4C518C1C22A425D3F21FEC85")
(digest-bit-test 40 #x04 23 "768B6B9397CE32864C5EE1A90EAF42D0489CDBE6")
(digest-bit-test 40 #x02 23 "F9313FB67EE62D61CB35B58A67F2668E8996A77F")
(digest-bit-test 40 #x01 23 "56F8DBF4CCF51AD0BFA042B7B2410346BC138E36")
(digest-bit-test 41 #x80 22 "DCCB6932C8AAE2EFA72EFAF9AAFB4804FA28AEDA")
(digest-bit-test 41 #x40 22 "2061CDBFE1D8A55C9F9D8DD49A8366139327ECD6")
(digest-bit-test 41 #x20 22 "956C4CD7F0E47501F07FD6694ADEE481A0A706D7")
(digest-bit-test 41 #x10 22 "B0A22915B6D5990EAE90AD3E550F9294D18F6E90")
(digest-bit-test 41 #x08 22 "21286BA23811271A072A75A3A7ECF33F186533B6")
(digest-bit-test 41 #x04 22 "BA591B8FBD5C8DFAE091AD997AF7D58D56656356")
(digest-bit-test 41 #x02 22 "34522D926DC21F0997400B42927EBF1CB291B961")
(digest-bit-test 41 #x01 22 "A0AA85260B30DA9D658413214918F7BEA7E3BC15")
(digest-bit-test 42 #x80 21 "696E36B391191DBA094532F9F61C9432AC42BB36")
(digest-bit-test 42 #x40 21 "032498A6EC908F466125E7A8A0BDC928199B5111")
(digest-bit-test 42 #x20 21 "2CE9D0CA449332DD88531128A549AC5AB50C38C5")
(digest-bit-test 42 #x10 21 "4970CDDB596A876A39F9D273CF718961603D2190")
(digest-bit-test 42 #x08 21 "A09DAB62BC9FD4A646B346398CE8665A0BB8108F")
(digest-bit-test 42 #x04 21 "9AE7485721299A29977998D5480505CA77BCDC40")
(digest-bit-test 42 #x02 21 "61BDD16D7695CDBC7E09C8ACC87C2EB64851CB39")
(digest-bit-test 42 #x01 21 "1DF7548A0CAD64526A030BC9BFC5626D17479831")
(digest-bit-test 43 #x80 20 "E6D75B4731632B08A9EC48332E3CC9C9E5F9994D")
(digest-bit-test 43 #x40 20 "29DE6BD404BF0FE6C284C578B017A6E713F59ECB")
(digest-bit-test 43 #x20 20 "55895E9A39F68680BA67F2CBB4EEA698496CB950")
(digest-bit-test 43 #x10 20 "85FCBA107C2156453C42CFFC30C63B40C9CAFDAF")
(digest-bit-test 43 #x08 20 "A9BB529EC301805AA8ACBE8389AD48E0385162BF")
(digest-bit-test 43 #x04 20 "154F31BEAFD8730A343C80051A2F9C149A3DD4D5")
(digest-bit-test 43 #x02 20 "F303E5E88C37C0EFF29180B372E00B9A8DC7DDB7")
(digest-bit-test 43 #x01 20 "A3B287D882127B00F7A723DB405298A460C73796")
(digest-bit-test 44 #x80 19 "4C8100F4E5629FB2CC6324D77737569522E5C775")
(digest-bit-test 44 #x40 19 "C1B6D177E1D224B3FB8B7719263CF6F2FA211323")
(digest-bit-test 44 #x20 19 "7EAF07E00BB7FD8F18E06BE05A137E314BA34BF2")
(digest-bit-test 44 #x10 19 "0C2AAE56115BE62930C4AE04B4FD152F64ED409C")
(digest-bit-test 44 #x08 19 "D676E0F5DE53FDAC16B35D06BB777599E838A1E0")
(digest-bit-test 44 #x04 19 "C500095E6F880659EEC666FF7F5BC37E39FABC2C")
(digest-bit-test 44 #x02 19 "D7E6EBA584DA5CD273D2E154330229B417F34361")
(digest-bit-test 44 #x01 19 "66BC10E7F84332A968D2E9E0CB79C68643ECECF9")
(digest-bit-test 45 #x80 18 "8EF22381D402646D3E102FB413703A8277D2B565")
(digest-bit-test 45 #x40 18 "B449114BD723E547DCAC5CA2D88BCEC690254F98")
(digest-bit-test 45 #x20 18 "2647472C0C4875CDA5E266ACBE6B2836539AB432")
(digest-bit-test 45 #x10 18 "29D6E52268ABDF244FE662DBA33AB9435EE66D1C")
(digest-bit-test 45 #x08 18 "4F0E93F97BBFC3395210D426F08D88D0C2BFD599")
(digest-bit-test 45 #x04 18 "6D76EB4C96F011E859EA81B136870784C70722F3")
(digest-bit-test 45 #x02 18 "4182D12C128BD5EE2EC8851C943B21720A6ECC32")
(digest-bit-test 45 #x01 18 "0DB22B512839C314A0235B245B66ECCC4FB29176")
(digest-bit-test 46 #x80 17 "9F9F449FEF08DE2A3F202B481C5B9B9690938B82")
(digest-bit-test 46 #x40 17 "6FD1EE49A36F67407F36B193DF20FB0EE9EBB3BF")
(digest-bit-test 46 #x20 17 "178C4E21E76A1718A4263E1DC9197D76345C1756")
(digest-bit-test 46 #x10 17 "C6519DC7593847544FDC38D2F024ED55A66BAED5")
(digest-bit-test 46 #x08 17 "BDF4A387201CA0D1D2FFDEE174F913ADEA999CC7")
(digest-bit-test 46 #x04 17 "549C43613AC1743E5B4E7A9A506F665B11CAE4CF")
(digest-bit-test 46 #x02 17 "0E59307C457A57EB30D5A9E9D797CA6B64D5F191")
(digest-bit-test 46 #x01 17 "9D15C38B6220C7F41EFA2C8B6A2DD1C17A19C109")
(digest-bit-test 47 #x80 16 "CBA55F53BBCB90E739B2344C8E8508D631CA429E")
(digest-bit-test 47 #x40 16 "86CF8C99F8996DC0DB12E004721A781533B33F68")
(digest-bit-test 47 #x20 16 "5E735505672A66959BCAD565F6DD9B4D311923BA")
(digest-bit-test 47 #x10 16 "E15C395B45066D50F2F25B8F85DEC3791281BA0A")
(digest-bit-test 47 #x08 16 "CDD485F608FA7BF001F59BA9DAAF266C50FCFA98")
(digest-bit-test 47 #x04 16 "94BEEAC05F3E5A6FB2CF1CB1229B230542451864")
(digest-bit-test 47 #x02 16 "D5481F60FCEF55D8C101FBBA7C054D88E37637F9")
(digest-bit-test 47 #x01 16 "4843CA5C5A803061D2FFCCD73FAEEE578AB13DBD")
(digest-bit-test 48 #x80 15 "D479FC21C0A351DDEDE3E79541B4E1B5F9542FD6")
(digest-bit-test 48 #x40 15 "E5F1EE88DF160FE503195104AC809E78F1697049")
(digest-bit-test 48 #x20 15 "1D37721790245F4182292F058930C37B4A9CE7EE")
(digest-bit-test 48 #x10 15 "44D614ADA253C44BC5FDEF6FA7DFF5792E621698")
(digest-bit-test 48 #x08 15 "745F03BFB20EF8CBD663767E3326AD6B1B4FC679")
(digest-bit-test 48 #x04 15 "9A88A295DCE2B8E8E48FBF7BE3CE55B33635A97F")
(digest-bit-test 48 #x02 15 "09909637CE971B7015281B85210B30C12F76E09E")
(digest-bit-test 48 #x01 15 "F0E9EE70866ABF4F2AAEB307663032214B976F27")
(digest-bit-test 49 #x80 14 "C19991C30080994CF78DD0B8CBB59DCE2C64079A")
(digest-bit-test 49 #x40 14 "29FE5880518565977D40DD45AEC19BAE84515E81")
(digest-bit-test 49 #x20 14 "0FBA86225438A82DB0F2DD6D655D1D85A5AD3B14")
(digest-bit-test 49 #x10 14 "AE8E67D9F7A3CD1D5B883EB4988BD751EDA4F6A4")
(digest-bit-test 49 #x08 14 "DFB8DA261C6CF4E55156F9CC6C760FC236479614")
(digest-bit-test 49 #x04 14 "DA9E82445FAB469B724230008E70C96CADD60239")
(digest-bit-test 49 #x02 14 "3820C5054068282169D937A1B01C2C5206012BEE")
(digest-bit-test 49 #x01 14 "C733A544F82A013C0F1A26D4A040357D2EAA4C52")
(digest-bit-test 50 #x80 13 "5F3CD7855C356B7587E8DEDAF9ED0262AABEE7C4")
(digest-bit-test 50 #x40 13 "E740EAEECA9A5E5C59578E6D89674EF1A56970E1")
(digest-bit-test 50 #x20 13 "A51B76E73BFBDBF980BF6FEA495A3CFB7D25809A")
(digest-bit-test 50 #x10 13 "A6E554F7E2D4FF1CA71395BA093BDD19A3661639")
(digest-bit-test 50 #x08 13 "5BD9F14F7985CB09638FEAF2CD5389A9A18BE557")
(digest-bit-test 50 #x04 13 "F65ADF18A93A5B67DEC169D2A73F4AE1673FC773")
(digest-bit-test 50 #x02 13 "73F8B85993F0D3CB12ABA034FDBA2F4D6E3E168B")
(digest-bit-test 50 #x01 13 "5055E365875B5E91C91B87619E3FC079ADD4DEEB")
(digest-bit-test 51 #x80 12 "C8FCB6653D648A5162C53D624DC0E85745769BB4")
(digest-bit-test 51 #x40 12 "3D7C3EA505167F9FBD99D18A5B615ECFD9C26D15")
(digest-bit-test 51 #x20 12 "061BD5CF62919A1B2E1163520436E2AA552BE242")
(digest-bit-test 51 #x10 12 "6A0FE1B5F651E7CA327D0083BA65E6F8FC42337B")
(digest-bit-test 51 #x08 12 "338BC5B38BBA52B80A2BFE88FCF95E925A9702D8")
(digest-bit-test 51 #x04 12 "F510D70693808ED495B06D86A784627DE4D87672")
(digest-bit-test 51 #x02 12 "AD0D2471322D2C27DB1F0BABC3C292CD3AB3239C")
(digest-bit-test 51 #x01 12 "93FF72C5D4A53FE0823F4F392D5407B298C5ADBB")
(digest-bit-test 52 #x80 11 "EF17405E6D26269F503EEEA3504FC9280D2603B9")
(digest-bit-test 52 #x40 11 "E5036DD48A55451D8212A27A85FE5779C30964FE")
(digest-bit-test 52 #x20 11 "10B74A030D16992F2DF906256858186D882554A6")
(digest-bit-test 52 #x10 11 "7181DC401250F84AAE4AA1FFB94A89ACD98E5FAC")
(digest-bit-test 52 #x08 11 "441C9327F5DC2907FD3C85C01D094FB2727AA6AF")
(digest-bit-test 52 #x04 11 "068A13FD27DCE7B9BDE20EBF9C28C1227EDA5F6F")
(digest-bit-test 52 #x02 11 "37273BD0E062B21349798C89B95A6E74BF58821A")
(digest-bit-test 52 #x01 11 "0A5A8FDBAF2101414D23860287A37C0582641646")
(digest-bit-test 53 #x80 10 "05B6211A7398032D2CC58C9BC3FA1A66D70C1E83")
(digest-bit-test 53 #x40 10 "0FFC3B8756C5D5765FD64B2EB9F065B2CAF06C5A")
(digest-bit-test 53 #x20 10 "992E5DD62BF677CC7439C10C73FBBA5B61A6C8E5")
(digest-bit-test 53 #x10 10 "385CE73875A2150C12D1558B3B89A53BA780A9BA")
(digest-bit-test 53 #x08 10 "C5DC05F37C48D5A299806C2AB3D3E992D9994A09")
(digest-bit-test 53 #x04 10 "D53B026111BCAF9C8FF3255709850E153EC7F149")
(digest-bit-test 53 #x02 10 "40CEF784A88C9DA3355C80C9B220B12B578F8430")
(digest-bit-test 53 #x01 10 "9E83DBD01B91EE6A3615334D3530EB52FC6D79AF")
(digest-bit-test 54 #x80 9 "BD2A8E4A91DF23662428C4FDDB93D665AAE02BEF")
(digest-bit-test 54 #x40 9 "06EA50EEE8EE904D4BCAB484C7A0D57F1E686D3C")
(digest-bit-test 54 #x20 9 "BEC01BB7F8BDBF144DFE0B3DD05427666F1DAA00")
(digest-bit-test 54 #x10 9 "3F281D9F9288C3284D6D614606ACE0288FA46FDE")
(digest-bit-test 54 #x08 9 "8B3B8B96A5AF2FEA5DED2EED9DBF87AC28872287")
(digest-bit-test 54 #x04 9 "FE60132B70DD243B661E7851828C79708CADFCF9")
(digest-bit-test 54 #x02 9 "B5ED866E9BCCA4E703FBB30A1E4924D72FAF4D50")
(digest-bit-test 54 #x01 9 "A0A55EC19E35FD0870BBC90A7CF333ADE724DE25")
(digest-bit-test 55 #x80 8 "0CBC0062C25F233616DE607A0A54B6D16B5A016F")
(digest-bit-test 55 #x40 8 "7FB304F334DA910FBBB412ED6A41CBEE66A0093A")
(digest-bit-test 55 #x20 8 "22032F4E752E7D5D26DB09991EF731E87E118680")
(digest-bit-test 55 #x10 8 "E2E5204F0258896446F8F943ECCB94688EDA05CA")
(digest-bit-test 55 #x08 8 "BCE31D00762D3D3699CAF25BAC4BBE27C4853530")
(digest-bit-test 55 #x04 8 "296B3124D4AA6C9E37A08720D6A7697CC075340F")
(digest-bit-test 55 #x02 8 "D14EB2BB8EC810A4CBFF2189095F99EC54CA0BAB")
(digest-bit-test 55 #x01 8 "A02059C3AC82077C2081C90C869257C530AB43C2")
(digest-bit-test 56 #x80 7 "73C80B1D08CBFD229CAD79F4F613A1D2A5E442EA")
(digest-bit-test 56 #x40 7 "1DA62F48EBB2D50EC062DD98C85FE8345B1129EC")
(digest-bit-test 56 #x20 7 "2FDFA42088BE5E2EF6AFA13890635ADB64BF59A7")
(digest-bit-test 56 #x10 7 "29F98848CC4E358FE51512739FD2985A3D9C5592")
(digest-bit-test 56 #x08 7 "AED5C356ED2DAA62BF20174834062B66F728C39C")
(digest-bit-test 56 #x04 7 "26C420F37DD3C7CDFFEF3EDD8E2F1842AFEFECBD")
(digest-bit-test 56 #x02 7 "CC70839427BC048BB08BB44E67758D1124B643BE")
(digest-bit-test 56 #x01 7 "DC393101E9B13892DC97EA811DD6D33421E672AC")
(digest-bit-test 57 #x80 6 "D01E8D33C9EAFBD8BE5369E3B6A857074BE5F78B")
(digest-bit-test 57 #x40 6 "13DB83187325B05980E84AAEE5C632D028109B17")
(digest-bit-test 57 #x20 6 "3D6E9C628537656EB88DC5F76E18E2A2DCEB38A7")
(digest-bit-test 57 #x10 6 "DEB2662AC60DA809BB5D94E2A5B9B38A7696D383")
(digest-bit-test 57 #x08 6 "BD9E94D831BF1235DCCC7D361AA374C97501E87B")
(digest-bit-test 57 #x04 6 "6D9052727FC9912CBBCB67120D2FD27C3C6E9A28")
(digest-bit-test 57 #x02 6 "E8640E2A840DE60356471F4B44220A9E15266A73")
(digest-bit-test 57 #x01 6 "C09A06651D0E3599ED42FAC3726575EFC3404C66")
(digest-bit-test 58 #x80 5 "F42C449EC2D162E5A7CB1688133BF9A290A9C3B3")
(digest-bit-test 58 #x40 5 "D399A7B5077BCB4527194109E04EF89CC71277EA")
(digest-bit-test 58 #x20 5 "866BB6B24E81487390F6A36545379421ADE02B6F")
(digest-bit-test 58 #x10 5 "7CBB546D49007E94D064D4F905245D19B9060EAB")
(digest-bit-test 58 #x08 5 "4D58003B6F36A7352F3ECF258FA4509D79E7D2CE")
(digest-bit-test 58 #x04 5 "C80BA62BE5DA26073C287AA03BEEDB4E916BB0FE")
(digest-bit-test 58 #x02 5 "06AB61CB329F3423AE513B49551191D6FA515FB1")
(digest-bit-test 58 #x01 5 "2FF9AF0FAF9A3B0AB42DE6B02E77FDC5B297CE28")
(digest-bit-test 59 #x80 4 "B2A39AAA8924F3D8059734794597889477F27E6F")
(digest-bit-test 59 #x40 4 "8D06BC2C793D856974AE5459AA669169E07EAC62")
(digest-bit-test 59 #x20 4 "0833ABD972DD3228DA4F024F5662DBE2117282D7")
(digest-bit-test 59 #x10 4 "A4ECE25FBFD97E44832F6B89A0648E248E2FD49F")
(digest-bit-test 59 #x08 4 "616310FDB4E72B3B985281C3EBD1C176A1273CFD")
(digest-bit-test 59 #x04 4 "9D19F19B80897024806F8CB2325960E375727ED7")
(digest-bit-test 59 #x02 4 "9E14014EE80E7614091F2AA5A0A9CAF27909F313")
(digest-bit-test 59 #x01 4 "5D119D7F6858CD7495DE1E9A645D2F80F8291DF5")
(digest-bit-test 60 #x80 3 "EBB2F360AB47F053A8BC736F45F33158C6EA878C")
(digest-bit-test 60 #x40 3 "5FE1A052AA885D1B4AD99D9F196DBE92CF65885D")
(digest-bit-test 60 #x20 3 "F552BEE8D59BF0654AC344F1A0CC3AE5597A7A71")
(digest-bit-test 60 #x10 3 "DC7825AC0CD824F74AB7A47B899300C3096D8667")
(digest-bit-test 60 #x08 3 "FA5D5599C5660ED0665A79EC395C722997BC5AC2")
(digest-bit-test 60 #x04 3 "EF8916D8A9EFCF4D6E02FE72DE8CAB90A3992262")
(digest-bit-test 60 #x02 3 "9F4ED685D398A752BC4EE8C0891D724258121D25")
(digest-bit-test 60 #x01 3 "5D36B7997B600229D9421D81A9EA1CB1DA1BED2D")
(digest-bit-test 61 #x80 2 "B1DA174937C24516A28C7F4770B98F8DF059ED1B")
(digest-bit-test 61 #x40 2 "890E8D2C34E060193AB21DE16B1C1929616D6EDA")
(digest-bit-test 61 #x20 2 "AB44A81DDB33C2439E2DF6EB42B3DA5ADB4460A6")
(digest-bit-test 61 #x10 2 "4796DEFE552974795285841588C9D0B0C2B39E21")
(digest-bit-test 61 #x08 2 "C42CCE86691B2B0A0A7297D3FC3077DE7B875457")
(digest-bit-test 61 #x04 2 "8969BBAF55EC689588998ADAC8A0CEEBDBA06DC3")
(digest-bit-test 61 #x02 2 "05F6A29AE91B66CDBC0D7F3D349DF5AA6519366D")
(digest-bit-test 61 #x01 2 "554E489049A20D8BD47FB1234EA397E21D8CAE77")
(digest-bit-test 62 #x80 1 "293CADC30C0CD9CF55ED269D42FB1758E5C71667")
(digest-bit-test 62 #x40 1 "AA0D67F4E35B04373C2A73A139A8FE8A9F1D0680")
(digest-bit-test 62 #x20 1 "9F10E6DFF017BC8553CC93C9255E3A1441C55DF5")
(digest-bit-test 62 #x10 1 "3A459F9EE9CA8ECBCF864769A0D30B2A9A0AA9FB")
(digest-bit-test 62 #x08 1 "C5A5F5833988BB1B920B7C7A7324890B7E681761")
(digest-bit-test 62 #x04 1 "DD81B919473C77D804DF031EE569571657195F9C")
(digest-bit-test 62 #x02 1 "E156B150616E25C4CC689A5A10849B2CB9C4C8C7")
(digest-bit-test 62 #x01 1 "83698FCBBA5CBE3B4E67B35466425B28C4E5162B")
(digest-bit-test 63 #x80 0 "ECAFA6F24326F8CEC555731834168EC7A75AA577")
(digest-bit-test 63 #x40 0 "CBC2CF467401231717CE7339BCD8591665823F46")
(digest-bit-test 63 #x20 0 "06DAA528DFD015E666C579F6AA997E50ECEF2451")
(digest-bit-test 63 #x10 0 "D84B71FDFD8E9F0A76AA1EB174CD253789D6408B")
(digest-bit-test 63 #x08 0 "74D9106CC9C67F307425CF940CC588B278F84AE2")
(digest-bit-test 63 #x04 0 "68B9EB81C30694D4A3EE926C53A08F8B76B099E5")
(digest-bit-test 63 #x02 0 "D229D9D61E24B80CB32373BB3362A3BDC7DCCE73")
(digest-bit-test 63 #x01 0 "AAE81062811EDFD2AF3081941D667FB7033DCE80")
