use Irssi 20020300;
use strict;
use Socket;
use POSIX;

use vars qw($VERSION %IRSSI);
$VERSION = "0.9";
%IRSSI = (
        authors         => "Maciek \'fahren\' Freudenheim",
        contact         => "fahren\@bochnia.pl",
        name            => "IP KickBan",
        description     => "/IPKB nick - bans nick\'s IP and kicks nick from channel",
        license         => "GNU GPLv2 or later",
        changed         => "Fri Mar 15 15:09:42 CET 2002"
);

sub cmd_ka {
	my ($args, $server, $chan) = @_;
	my ($nick, $reason) = split(/ +/, $args, 2);

	unless ($chan && $chan->{type} eq "CHANNEL" && $chan->{chanop}) {
		Irssi::print("%R>>%n You aren't opped / You don't have active channel :/");
		return;
	}

	my $channel = $chan->{name};
	my $hn = $chan->nick_find($nick);
	
	unless ($hn) {
		Irssi::print("%R>>%n No such nickname on $channel :/");
		return;
	}
	
	my $host = $hn->{host};
	(my($user), $host) = $host =~ /(.*)@(.+)/;
	$user =~ s/^[~+-=]//;

	my $pid = fork();
	unless (defined $pid) {
		Irssi::print("%R>>%n Failed to fork() :/ -  $!");
		return;
	} elsif ($pid) {
		Irssi::pidwait_add($pid);
		return;
	}

	my $ia = gethostbyname($host);
	POSIX::_exit(1) unless ($ia); # fixme: pipe :/
	
	my $ip = inet_ntoa($ia);
	$ip =~ s/\.[0-9]+$/\.\*/;
	my $hn = "*!*$user@".$ip;

	$server->send_raw("MODE $channel +b $hn");
	$server->send_raw("KICK $channel $nick :$reason");

	POSIX::_exit(1);
}

Irssi::command_bind('ka', 'cmd_ka'); # LiCe owns
Irssi::command_bind('ipkb', 'cmd_ka');

